/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.xml.ScriptElement;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptTagHandler
extends DefaultHandler {
    private Locator locator;
    private String fileName;
    private int inlineScriptCount = 0;
    private boolean inScript = false;
    private EPUBVersion version = EPUBVersion.Unknown;
    private final Report report;
    public static final Pattern xmlHttpRequestPattern = Pattern.compile("new[\\s]*XMLHttpRequest[\\s]*\\(");
    public static final Pattern microsoftXmlHttpRequestPattern = Pattern.compile("Microsoft.XMLHTTP");
    public static final Pattern evalPattern = Pattern.compile("((^eval[\\s]*\\()|([^a-zA-Z0-9]eval[\\s]*\\()|([\\s]+eval[\\s]*\\())");
    public static final Pattern localStoragePattern = Pattern.compile("localStorage\\.");
    public static final Pattern sessionStoragePattern = Pattern.compile("sessionStorage\\.");
    private final Vector<ScriptElement> scriptElements = new Vector();

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ScriptTagHandler(Report report) {
        this.report = report;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setVersion(EPUBVersion version) {
        this.version = version;
    }

    public int getScriptElementCount() {
        return this.scriptElements.size();
    }

    public Vector<ScriptElement> getScriptElements() {
        return this.scriptElements;
    }

    public int getInlineScriptCount() {
        return this.inlineScriptCount;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.compareToIgnoreCase("SCRIPT") == 0) {
            this.inScript = true;
            if (this.version == EPUBVersion.VERSION_2) {
                this.report.message(MessageId.SCP_004, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), qName), new Object[0]);
            }
            ScriptElement scriptElement = new ScriptElement();
            boolean isExternal = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrName.equalsIgnoreCase("src")) {
                    isExternal = true;
                }
                scriptElement.addAttribute(attrName, attrValue);
            }
            if (isExternal) {
                this.report.info(this.fileName, FeatureEnum.SCRIPT, "external");
            } else {
                this.report.info(this.fileName, FeatureEnum.SCRIPT, "tag");
            }
            this.scriptElements.add(scriptElement);
        } else {
            HashSet<String> scriptEvents = OPSHandler30.getScriptEvents();
            HashSet<String> mouseEvents = OPSHandler30.getMouseEvents();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getLocalName(i).toLowerCase();
                if (scriptEvents.contains(attrName)) {
                    ++this.inlineScriptCount;
                    if (this.version == EPUBVersion.VERSION_2) {
                        this.report.message(MessageId.SCP_004, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), attrName), new Object[0]);
                    }
                    this.report.message(MessageId.SCP_006, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), attrName), new Object[0]);
                    String attrValue = attributes.getValue(i);
                    this.CheckForInner(attrValue);
                }
                if (!mouseEvents.contains(attrName)) continue;
                if (this.version == EPUBVersion.VERSION_2) {
                    this.report.message(MessageId.SCP_004, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), attrName), new Object[0]);
                }
                this.report.message(MessageId.SCP_009, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), attrName), new Object[0]);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.compareToIgnoreCase("SCRIPT") == 0) {
            this.inScript = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inScript) {
            String script = new String(ch, start, length);
            this.CheckForInner(script);
        }
    }

    public void CheckForInner(String script) {
        String lower = script.toLowerCase();
        int column = lower.indexOf("innerhtml");
        if (column >= 0) {
            this.report.message(MessageId.SCP_007, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, column)), new Object[0]);
        }
        if ((column = lower.indexOf("innertext")) >= 0) {
            this.report.message(MessageId.SCP_008, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, column)), new Object[0]);
        }
        Matcher m = null;
        if (script.contains("eval") && (m = evalPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_001, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = localStoragePattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_003, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = sessionStoragePattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_003, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = xmlHttpRequestPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_002, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, m.start())), new Object[0]);
        }
        if ((m = microsoftXmlHttpRequestPattern.matcher(script)).find()) {
            this.report.message(MessageId.SCP_002, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), ScriptTagHandler.trimContext(script, m.start())), new Object[0]);
        }
    }

    public static String trimContext(String context, int start) {
        String trimmed = context.substring(start).trim();
        int end = trimmed.indexOf("\n");
        if (end < 0 && trimmed.length() < 60) {
            return trimmed;
        }
        int newEnd = Math.min(60, end > 0 ? end : trimmed.length());
        return trimmed.substring(0, newEnd);
    }
}

