/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.XmlDocParser;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.epubpackage.PackageManifest;
import com.adobe.epubcheck.ctc.epubpackage.PackageSpine;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EpubNavCheck
implements DocumentValidator {
    private final XmlDocParser docParser;
    private final Document packageMainDocument;
    private final EpubPackage epack;
    private final Report report;

    public EpubNavCheck(EpubPackage epack, Report report) {
        ZipFile zip = epack.getZip();
        this.packageMainDocument = epack.getPackDoc();
        this.epack = epack;
        this.docParser = new XmlDocParser(zip, report);
        this.report = report;
    }

    @Override
    public boolean validate() {
        boolean result = false;
        Vector<String> navDocPath = this.getNAVDocuments(this.packageMainDocument);
        if (navDocPath != null && navDocPath.size() > 0) {
            for (String navDoc : navDocPath) {
                if (navDoc == null) continue;
                String fileToParse = this.epack.getPackageMainPath() != null && this.epack.getPackageMainPath().length() > 0 ? PathUtil.resolveRelativeReference(this.epack.getPackageMainFile(), navDoc, null) : navDoc;
                ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
                if (entry == null) continue;
                this.checkNavDoc(fileToParse);
            }
        }
        return result;
    }

    private Vector<String> getNAVDocuments(Document doc) {
        Vector<String> navItems = new Vector<String>();
        NodeList manifestList = doc.getElementsByTagName("manifest");
        for (int m = 0; m < manifestList.getLength(); ++m) {
            Node manifestNode = manifestList.item(m);
            NodeList itemNodes = manifestNode.getChildNodes();
            for (int it = 0; it < itemNodes.getLength(); ++it) {
                String nodePropertiesAttr;
                NamedNodeMap itemNodeAttributes = itemNodes.item(it).getAttributes();
                if (itemNodeAttributes == null || itemNodeAttributes.getNamedItem("properties") == null || (nodePropertiesAttr = itemNodeAttributes.getNamedItem("properties").getNodeValue()) == null || nodePropertiesAttr.compareToIgnoreCase("nav") != 0) continue;
                String hrefValue = null;
                if (itemNodeAttributes.getNamedItem("href").getNodeValue() != null) {
                    hrefValue = itemNodeAttributes.getNamedItem("href").getNodeValue();
                }
                navItems.add(hrefValue);
            }
        }
        return navItems;
    }

    private boolean checkNavDoc(String navDocEntry) {
        HashSet<String> tocLinkSet = new HashSet<String>();
        boolean containsNavElements = false;
        Document doc = this.docParser.parseDocument(navDocEntry);
        if (doc == null) {
            return false;
        }
        NodeList n = doc.getElementsByTagName("nav");
        for (int i = 0; i < n.getLength(); ++i) {
            Element navElement = (Element)n.item(i);
            String type = navElement.getAttributeNS("http://www.idpf.org/2007/ops", "type");
            if (type == null) continue;
            if (type.equals("toc")) {
                containsNavElements = true;
                NodeList links = navElement.getElementsByTagName("a");
                int navOrder = 1;
                for (int j = 0; j < links.getLength(); ++j) {
                    String href;
                    Element link = (Element)links.item(j);
                    String path = href = link.getAttribute("href");
                    int hash = href.indexOf("#");
                    if (hash >= 0) {
                        path = href.substring(0, hash);
                    }
                    if ((path = PathUtil.resolveRelativeReference(navDocEntry, path, null)).equals("") || tocLinkSet.contains(path)) continue;
                    this.report.info(path, FeatureEnum.NAVIGATION_ORDER, String.valueOf(navOrder));
                    ++navOrder;
                    tocLinkSet.add(path);
                }
                continue;
            }
            if (!type.equals("page-list")) continue;
            this.report.message(MessageId.NAV_002, EPUBLocation.create(navDocEntry, HandlerUtil.getElementLineNumber(navElement), HandlerUtil.getElementColumnNumber(navElement), "page-list"), new Object[0]);
        }
        PackageManifest manifest = this.epack.getManifest();
        PackageSpine spine = this.epack.getSpine();
        if (spine != null) {
            String tocFileName = spine.getToc();
            for (int i = 0; i < spine.itemsLength(); ++i) {
                SpineItem si = spine.getItem(i);
                ManifestItem mi = manifest.getItem(si.getIdref());
                if (mi == null) continue;
                String path = mi.getHref();
                path = PathUtil.resolveRelativeReference(this.epack.getPackageMainFile(), path, null);
                if (path == null || path.equals(tocFileName) || path.equals(navDocEntry) || tocLinkSet.contains(path)) continue;
                this.report.message(MessageId.OPF_058, EPUBLocation.create(navDocEntry, -1, -1, path), new Object[0]);
            }
        }
        return containsNavElements;
    }
}

