/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.AnchorTagHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.SearchDictionary;
import com.adobe.epubcheck.util.TextSearchDictionaryEntry;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class EpubExtLinksCheck
implements DocumentValidator {
    private final Report report;
    private final EpubPackage epack;

    public EpubExtLinksCheck(EpubPackage epack, Report report) {
        this.epack = epack;
        this.report = report;
    }

    @Override
    public boolean validate() {
        SearchDictionary tsd = new SearchDictionary(SearchDictionary.DictionaryType.LINK_VALUES);
        SearchDictionary validTypes = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem itemEntry = this.epack.getManifest().getItem(i);
            if (!validTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            String fileToParse = this.epack.getManifestItemFileName(itemEntry);
            XMLContentDocParser parser = new XMLContentDocParser(this.epack.getZip(), this.report);
            AnchorTagHandler h = new AnchorTagHandler();
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            parser.parseDoc(fileToParse, h);
            Vector<AnchorTagHandler.DocTagContent> v = h.getHrefAttributesValues();
            for (int e = 0; e < v.size(); ++e) {
                ZipEntry imgentry;
                String imageFile;
                AnchorTagHandler.DocTagContent value = v.elementAt(e);
                this.searchInsideValue(value, tsd, fileToParse);
                String type = value.getType();
                if ("img".compareToIgnoreCase(type) != 0 && "altimg".compareToIgnoreCase(type) != 0 || (imageFile = value.getValue()).matches("^[^:/?#]+:.*")) continue;
                int index = (imageFile = PathUtil.resolveRelativeReference(fileToParse, imageFile, null)).lastIndexOf("#");
                if (index > 0) {
                    imageFile = imageFile.substring(0, index);
                }
                if ((imgentry = this.epack.getZip().getEntry(imageFile)) != null || !"altimg".equalsIgnoreCase(type)) continue;
                this.report.message(MessageId.RSC_018, EPUBLocation.create(fileToParse, value.getLine(), value.getColumn(), value.getContext()), value.getValue());
            }
        }
        return true;
    }

    private void searchInsideValue(AnchorTagHandler.DocTagContent entry, SearchDictionary tds, String file) {
        for (int s = 0; s < tds.getDictEntries().size(); ++s) {
            TextSearchDictionaryEntry de = tds.getDictEntries().get(s);
            MessageId messageCode = de.getErrorCode();
            Pattern p = de.getPattern();
            Matcher matcher = p.matcher(entry.getValue());
            int position = 0;
            while (matcher.find(position)) {
                position = matcher.end();
                this.report.message(messageCode, EPUBLocation.create(file, entry.getLine(), entry.getColumn(), entry.getValue()), new Object[0]);
            }
        }
    }
}

