/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;

public class NodeNameFn
extends SystemFunctionCall {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        return this.simplifyArguments(visitor);
    }

    public int getIntrinsicDependencies() {
        if (this.getNumberOfArguments() == 0) {
            return 2;
        }
        return super.getIntrinsicDependencies();
    }

    public QNameValue evaluateItem(XPathContext c) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        return NodeNameFn.nodeName(node);
    }

    public static QNameValue nodeName(NodeInfo node) {
        if (node == null) {
            return null;
        }
        int nc = node.getNameCode();
        if (nc == -1) {
            return null;
        }
        return new QNameValue(node.getNamePool(), nc);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = arguments.length == 0 ? this.getContextNode(context) : (NodeInfo)arguments[0].head();
        QNameValue name = NodeNameFn.nodeName(node);
        return name == null ? EmptySequence.getInstance() : name;
    }
}

