/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class JFXXSegment {
    public static final int JPEG = 16;
    public static final int INDEXED = 17;
    public static final int RGB = 19;
    final int extensionCode;
    final byte[] thumbnail;

    private JFXXSegment(int n, byte[] byArray) {
        this.extensionCode = n;
        this.thumbnail = byArray;
    }

    public String toString() {
        return String.format("JFXX extension (%s thumb size: %d)", this.extensionAsString(), this.thumbnail.length);
    }

    private String extensionAsString() {
        switch (this.extensionCode) {
            case 16: {
                return "JPEG";
            }
            case 17: {
                return "Indexed";
            }
            case 19: {
                return "RGB";
            }
        }
        return String.valueOf(this.extensionCode);
    }

    public static JFXXSegment read(InputStream inputStream, int n) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        return new JFXXSegment(dataInputStream.readUnsignedByte(), JPEGImageReader.readFully(dataInputStream, n - 1));
    }
}

