# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Code generated by protogen. DO NOT EDIT.

import collections


class AKS:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKS ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AKSBasicAuth:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AKSServiceAccount:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSServiceAccount ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSServiceAccountUserImpersonation:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AKSServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class AKSUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AKSUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWS:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthcheck_region',
        'healthy',
        'id',
        'name',
        'port_override',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthcheck_region=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_region = healthcheck_region if healthcheck_region is not None else ''
        '''
         The AWS region healthcheck requests should attempt to connect to.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_region: ' + repr(self.healthcheck_region) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_region': self.healthcheck_region,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_region=d.get('healthcheck_region'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSConsole:
    '''
    AWSConsole is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'enable_env_variables',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        enable_env_variables=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.enable_env_variables = enable_env_variables if enable_env_variables is not None else False
        '''
         If true, prefer environment variables to authenticate connection even if EC2 roles are configured.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds AWS console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsole ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'enable_env_variables: ' + repr(self.enable_env_variables) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'enable_env_variables': self.enable_env_variables,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            enable_env_variables=d.get('enable_env_variables'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSConsoleStaticKeyPair:
    '''
    AWSConsoleStaticKeyPair is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'session_expiry',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        session_expiry=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to authenticate with.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.session_expiry = session_expiry if session_expiry is not None else 0
        '''
         The length of time in seconds AWS console sessions will live before needing to reauthenticate.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSConsoleStaticKeyPair ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'session_expiry: ' + repr(self.session_expiry) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'session_expiry': self.session_expiry,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            session_expiry=d.get('session_expiry'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AWSStore:
    __slots__ = [
        'id',
        'name',
        'region',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        region=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to target e.g. us-east-1
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AWSStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'region': self.region,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            region=d.get('region'),
            tags=d.get('tags'),
        )


class AccountAttachment:
    '''
         AccountAttachments assign an account to a role.
    '''
    __slots__ = [
        'account_id',
        'id',
        'role_id',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        role_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The id of the account of this AccountAttachment.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountAttachment.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The id of the attached role of this AccountAttachment.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachment ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            role_id=d.get('role_id'),
        )


class AccountAttachmentCreateResponse:
    '''
         AccountAttachmentCreateResponse reports how the AccountAttachments were created in the system.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The created AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentCreateResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentDeleteResponse:
    '''
         AccountAttachmentDeleteResponse returns information about a AccountAttachment that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentGetResponse:
    '''
         AccountAttachmentGetResponse returns a requested AccountAttachment.
    '''
    __slots__ = [
        'account_attachment',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_attachment=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The requested AccountAttachment.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentGetResponse ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountAttachmentHistory:
    '''
         AccountAttachmentHistory records the state of an AccountAttachment at a given point in time,
     where every change (create or delete) to an AccountAttachment produces an
     AccountAttachmentHistory record.
    '''
    __slots__ = [
        'account_attachment',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_attachment=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_attachment = account_attachment if account_attachment is not None else None
        '''
         The complete AccountAttachment state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountAttachment.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountAttachment was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountAttachment state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountAttachmentHistory ' + \
            'account_attachment: ' + repr(self.account_attachment) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_attachment': self.account_attachment,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_attachment=d.get('account_attachment'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountCreateResponse:
    '''
         AccountCreateResponse reports how the Accounts were created in the system.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
        'token',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
        token=None,
    ):
        self.account = account if account is not None else None
        '''
         The created Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Account. The Account will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.AccountCreateResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            token=d.get('token'),
        )


class AccountDeleteResponse:
    '''
         AccountDeleteResponse returns information about a Account that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGetResponse:
    '''
         AccountGetResponse returns a requested Account.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The requested Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGetResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrant:
    '''
         AccountGrants connect a resource directly to an account, giving the account the permission to connect to that resource.
    '''
    __slots__ = [
        'account_id',
        'id',
        'resource_id',
        'start_from',
        'valid_until',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        resource_id=None,
        start_from=None,
        valid_until=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account ID of this AccountGrant.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the AccountGrant.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The resource ID of this AccountGrant.
        '''
        self.start_from = start_from if start_from is not None else None
        '''
         The timestamp when the resource will be granted. When creating an AccountGrant, if this field is not specified, it will default to the current time.
        '''
        self.valid_until = valid_until if valid_until is not None else None
        '''
         The timestamp when the resource grant will expire.
        '''

    def __repr__(self):
        return '<sdm.AccountGrant ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'start_from: ' + repr(self.start_from) + ' ' +\
            'valid_until: ' + repr(self.valid_until) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'resource_id': self.resource_id,
            'start_from': self.start_from,
            'valid_until': self.valid_until,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            resource_id=d.get('resource_id'),
            start_from=d.get('start_from'),
            valid_until=d.get('valid_until'),
        )


class AccountGrantCreateResponse:
    '''
         AccountGrantCreateResponse reports how the AccountGrants were created in the system.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The created AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantCreateResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantDeleteResponse:
    '''
         AccountGrantDeleteResponse returns information about a AccountGrant that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantGetResponse:
    '''
         AccountGrantGetResponse returns a requested AccountGrant.
    '''
    __slots__ = [
        'account_grant',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account_grant=None,
        meta=None,
        rate_limit=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The requested AccountGrant.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantGetResponse ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AccountGrantHistory:
    '''
         AccountGrantHistory records the state of an AccountGrant at a given point in time,
     where every change (create or delete) to an AccountGrant produces an
     AccountGrantHistory record.
    '''
    __slots__ = [
        'account_grant',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_grant=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_grant = account_grant if account_grant is not None else None
        '''
         The complete AccountGrant state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountGrant.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountGrant was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountGrant state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountGrantHistory ' + \
            'account_grant: ' + repr(self.account_grant) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant': self.account_grant,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant=d.get('account_grant'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountHistory:
    '''
         AccountHistory records the state of an Account at a given point in time,
     where every change (create, update and delete) to an Account produces an
     AccountHistory record.
    '''
    __slots__ = [
        'account',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account = account if account is not None else None
        '''
         The complete Account state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Account.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Account was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Account state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountHistory ' + \
            'account: ' + repr(self.account) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountPermission:
    '''
         AccountPermission represents an individual API action available to an account.
    '''
    __slots__ = [
        'account_id',
        'granted_at',
        'permission',
        'scope',
        'scoped_id',
    ]

    def __init__(
        self,
        account_id=None,
        granted_at=None,
        permission=None,
        scope=None,
        scoped_id=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The unique identifier of the Account this permission belongs to.
        '''
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which the permission was granted. If a permission was
         granted, revoked, and granted again, this will reflect the later time.
        '''
        self.permission = permission if permission is not None else ''
        '''
         The value of this permission, split into vertical and action e.g.
         'secretstore:List', 'role:update'
        '''
        self.scope = scope if scope is not None else ''
        '''
         The scope of this permission. A global scope means this action can be taken
         on any entity; otherwise the action can only be taken on or in the scope of
         the scoped id.
        '''
        self.scoped_id = scoped_id if scoped_id is not None else ''
        '''
         The ID to which or in whose context this operation is permitted. e.g. The ID of a
         role that a team leader has the abillity to remove and add accounts to, or the
         ID of a resource that a user has the permission to connect to. If Scope is global,
         scoped id is not populated.
        '''

    def __repr__(self):
        return '<sdm.AccountPermission ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'granted_at: ' + repr(self.granted_at) + ' ' +\
            'permission: ' + repr(self.permission) + ' ' +\
            'scope: ' + repr(self.scope) + ' ' +\
            'scoped_id: ' + repr(self.scoped_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'granted_at': self.granted_at,
            'permission': self.permission,
            'scope': self.scope,
            'scoped_id': self.scoped_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            granted_at=d.get('granted_at'),
            permission=d.get('permission'),
            scope=d.get('scope'),
            scoped_id=d.get('scoped_id'),
        )


class AccountResource:
    '''
         AccountResource represents an individual access grant of a Account to a Resource.
    '''
    __slots__ = [
        'account_grant_id',
        'account_id',
        'created_at',
        'expires_at',
        'granted_at',
        'resource_id',
        'role_id',
    ]

    def __init__(
        self,
        account_grant_id=None,
        account_id=None,
        created_at=None,
        expires_at=None,
        granted_at=None,
        resource_id=None,
        role_id=None,
    ):
        self.account_grant_id = account_grant_id if account_grant_id is not None else ''
        '''
         The unique identifier of the AccountGrant through which the Account was granted access to the Resource.
         If empty, access was not granted through an AccountGrant.
        '''
        self.account_id = account_id if account_id is not None else ''
        '''
         The unique identifier of the Account to which access is granted.
        '''
        self.created_at = created_at if created_at is not None else None
        '''
         The time this grant was created, distinct from 'granted at' in the case where access is scheduled
         for the future. If access was granted, revoked, and granted again, this will reflect the later creation time.
        '''
        self.expires_at = expires_at if expires_at is not None else None
        '''
         The time at which access will expire. If empty, this access has no expiration.
        '''
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which access was granted. If access was granted,
         revoked, and granted again, this will reflect the later time.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The unique identifier of the Resource to which access is granted.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The unique identifier of the Role through which the Account was granted access to the Resource.
         If empty, access was not granted through an AccountAttachment to a Role.
        '''

    def __repr__(self):
        return '<sdm.AccountResource ' + \
            'account_grant_id: ' + repr(self.account_grant_id) + ' ' +\
            'account_id: ' + repr(self.account_id) + ' ' +\
            'created_at: ' + repr(self.created_at) + ' ' +\
            'expires_at: ' + repr(self.expires_at) + ' ' +\
            'granted_at: ' + repr(self.granted_at) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_grant_id': self.account_grant_id,
            'account_id': self.account_id,
            'created_at': self.created_at,
            'expires_at': self.expires_at,
            'granted_at': self.granted_at,
            'resource_id': self.resource_id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_grant_id=d.get('account_grant_id'),
            account_id=d.get('account_id'),
            created_at=d.get('created_at'),
            expires_at=d.get('expires_at'),
            granted_at=d.get('granted_at'),
            resource_id=d.get('resource_id'),
            role_id=d.get('role_id'),
        )


class AccountResourceHistory:
    '''
         AccountResourceHistory records the state of a AccountResource at a given point in time,
     where every change (create or delete) to a AccountResource produces an
     AccountResourceHistory record.
    '''
    __slots__ = [
        'account_resource',
        'activity_id',
        'deleted_at',
        'timestamp',
    ]

    def __init__(
        self,
        account_resource=None,
        activity_id=None,
        deleted_at=None,
        timestamp=None,
    ):
        self.account_resource = account_resource if account_resource is not None else None
        '''
         The complete AccountResource state at this time.
        '''
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the AccountResource.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this AccountResource was deleted, the time it was deleted.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the AccountResource state was recorded.
        '''

    def __repr__(self):
        return '<sdm.AccountResourceHistory ' + \
            'account_resource: ' + repr(self.account_resource) + ' ' +\
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_resource': self.account_resource,
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_resource=d.get('account_resource'),
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            timestamp=d.get('timestamp'),
        )


class AccountUpdateResponse:
    '''
         AccountUpdateResponse returns the fields of a Account after it has been updated by
     a AccountUpdateRequest.
    '''
    __slots__ = [
        'account',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        account=None,
        meta=None,
        rate_limit=None,
    ):
        self.account = account if account is not None else None
        '''
         The updated Account.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.AccountUpdateResponse ' + \
            'account: ' + repr(self.account) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account': self.account,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account=d.get('account'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class Activity:
    '''
         An Activity is a record of an action taken against a strongDM deployment, e.g.
     a user creation, resource deletion, sso configuration change, etc.
    '''
    __slots__ = [
        'actor',
        'completed_at',
        'description',
        'entities',
        'id',
        'ip_address',
        'user_agent',
        'verb',
    ]

    def __init__(
        self,
        actor=None,
        completed_at=None,
        description=None,
        entities=None,
        id=None,
        ip_address=None,
        user_agent=None,
        verb=None,
    ):
        self.actor = actor if actor is not None else None
        '''
         The account who executed this activity. If the actor later has a name or email change,
         that change is not reflected here. Actor is a snapshot of the executing account at
         the time an activity took place.
        '''
        self.completed_at = completed_at if completed_at is not None else None
        '''
         The time this activity took effect.
        '''
        self.description = description if description is not None else ''
        '''
         A humanized description of the activity.
        '''
        self.entities = entities if entities is not None else []
        '''
         The entities involved in this activity. These entities can be any first class
         entity in the strongDM system, eg. a user, a role, a node, an account grant. Not
         every activity affects explicit entities.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Activity.
        '''
        self.ip_address = ip_address if ip_address is not None else ''
        '''
         The IP from which this action was taken.
        '''
        self.user_agent = user_agent if user_agent is not None else ''
        '''
         The User Agent present when this request was executed. Generally a client type and version
         like strongdm-cli/55.66.77
        '''
        self.verb = verb if verb is not None else ''
        '''
         The kind of activity which has taken place.
        '''

    def __repr__(self):
        return '<sdm.Activity ' + \
            'actor: ' + repr(self.actor) + ' ' +\
            'completed_at: ' + repr(self.completed_at) + ' ' +\
            'description: ' + repr(self.description) + ' ' +\
            'entities: ' + repr(self.entities) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'ip_address: ' + repr(self.ip_address) + ' ' +\
            'user_agent: ' + repr(self.user_agent) + ' ' +\
            'verb: ' + repr(self.verb) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'actor': self.actor,
            'completed_at': self.completed_at,
            'description': self.description,
            'entities': self.entities,
            'id': self.id,
            'ip_address': self.ip_address,
            'user_agent': self.user_agent,
            'verb': self.verb,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            actor=d.get('actor'),
            completed_at=d.get('completed_at'),
            description=d.get('description'),
            entities=d.get('entities'),
            id=d.get('id'),
            ip_address=d.get('ip_address'),
            user_agent=d.get('user_agent'),
            verb=d.get('verb'),
        )


class ActivityActor:
    __slots__ = [
        'activity_external_id',
        'email',
        'first_name',
        'id',
        'last_name',
    ]

    def __init__(
        self,
        activity_external_id=None,
        email=None,
        first_name=None,
        id=None,
        last_name=None,
    ):
        self.activity_external_id = activity_external_id if activity_external_id is not None else ''
        '''
         The external ID of the actor at the time this activity occurred.
        '''
        self.email = email if email is not None else ''
        '''
         The email of the actor at the time this activity occurred.
        '''
        self.first_name = first_name if first_name is not None else ''
        '''
         The first name of the actor at the time this activity occurred.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the actor. Immutable.
        '''
        self.last_name = last_name if last_name is not None else ''
        '''
         The last name of the actor at the time this activity occurred.
        '''

    def __repr__(self):
        return '<sdm.ActivityActor ' + \
            'activity_external_id: ' + repr(self.activity_external_id) + ' ' +\
            'email: ' + repr(self.email) + ' ' +\
            'first_name: ' + repr(self.first_name) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_name: ' + repr(self.last_name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_external_id': self.activity_external_id,
            'email': self.email,
            'first_name': self.first_name,
            'id': self.id,
            'last_name': self.last_name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_external_id=d.get('activity_external_id'),
            email=d.get('email'),
            first_name=d.get('first_name'),
            id=d.get('id'),
            last_name=d.get('last_name'),
        )


class ActivityEntity:
    __slots__ = [
        'email',
        'external_id',
        'id',
        'name',
        'type',
    ]

    def __init__(
        self,
        email=None,
        external_id=None,
        id=None,
        name=None,
        type=None,
    ):
        self.email = email if email is not None else ''
        '''
         The email of the affected entity, if it has one (for example, if it is an account).
        '''
        self.external_id = external_id if external_id is not None else ''
        '''
         The external ID of the affected entity, if it has one (for example, if it is an account).
        '''
        self.id = id if id is not None else ''
        '''
         The unique identifier of the entity this activity affected.
        '''
        self.name = name if name is not None else ''
        '''
         A display name representing the affected entity.
        '''
        self.type = type if type is not None else ''
        '''
         The type of entity affected, one of the Activity Entities constants.
        '''

    def __repr__(self):
        return '<sdm.ActivityEntity ' + \
            'email: ' + repr(self.email) + ' ' +\
            'external_id: ' + repr(self.external_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'email': self.email,
            'external_id': self.external_id,
            'id': self.id,
            'name': self.name,
            'type': self.type,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            email=d.get('email'),
            external_id=d.get('external_id'),
            id=d.get('id'),
            name=d.get('name'),
            type=d.get('type'),
        )


class ActivityGetResponse:
    '''
         ActivityGetResponse returns a requested Activity.
    '''
    __slots__ = [
        'activity',
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        activity=None,
        meta=None,
        rate_limit=None,
    ):
        self.activity = activity if activity is not None else None
        '''
         The requested Activity.
        '''
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ActivityGetResponse ' + \
            'activity: ' + repr(self.activity) + ' ' +\
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity': self.activity,
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity=d.get('activity'),
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class AmazonEKS:
    __slots__ = [
        'access_key',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKS ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSInstanceProfile:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSInstanceProfile ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSInstanceProfileUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'role_arn',
        'role_external_id',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        role_arn=None,
        role_external_id=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSInstanceProfileUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonEKSUserImpersonation:
    __slots__ = [
        'access_key',
        'bind_interface',
        'certificate_authority',
        'cluster_name',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        certificate_authority=None,
        cluster_name=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.cluster_name = cluster_name if cluster_name is not None else ''
        '''
         The name of the cluster to connect to.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonEKSUserImpersonation ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'cluster_name: ' + repr(self.cluster_name) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'cluster_name': self.cluster_name,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            cluster_name=d.get('cluster_name'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonES:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. search-?.region.es.amazonaws.com"
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.AmazonES ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AmazonMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AmazonMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Athena:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'output',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        output=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.output = output if output is not None else ''
        '''
         The AWS S3 output location.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to e.g. us-east-1.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Athena ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'output: ' + repr(self.output) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'output': self.output,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            output=d.get('output'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class AuroraMysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AuroraPostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AuroraPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Azure:
    __slots__ = [
        'app_id',
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'password',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        '''
         The application ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The tenant ID to authenticate to.
        '''

    def __repr__(self):
        return '<sdm.Azure ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureCertificate:
    __slots__ = [
        'app_id',
        'bind_interface',
        'client_certificate',
        'egress_filter',
        'healthy',
        'id',
        'name',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        app_id=None,
        bind_interface=None,
        client_certificate=None,
        egress_filter=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tenant_id=None,
    ):
        self.app_id = app_id if app_id is not None else ''
        '''
         The application ID to authenticate with.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The service Principal certificate file, both private and public key included.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The tenant ID to authenticate to.
        '''

    def __repr__(self):
        return '<sdm.AzureCertificate ' + \
            'app_id: ' + repr(self.app_id) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'app_id': self.app_id,
            'bind_interface': self.bind_interface,
            'client_certificate': self.client_certificate,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            app_id=d.get('app_id'),
            bind_interface=d.get('bind_interface'),
            client_certificate=d.get('client_certificate'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class AzureMysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzureMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AzurePostgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzurePostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class AzurePostgresManagedIdentity:
    '''
    AzurePostgresManagedIdentity is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.AzurePostgresManagedIdentity ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class AzureStore:
    __slots__ = [
        'id',
        'name',
        'tags',
        'vault_uri',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        tags=None,
        vault_uri=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.vault_uri = vault_uri if vault_uri is not None else ''
        '''
         The URI of the key vault to target e.g. https://myvault.vault.azure.net
        '''

    def __repr__(self):
        return '<sdm.AzureStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'vault_uri: ' + repr(self.vault_uri) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
            'vault_uri': self.vault_uri,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
            vault_uri=d.get('vault_uri'),
        )


class BigQuery:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'private_key',
        'project',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        private_key=None,
        project=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.private_key = private_key if private_key is not None else ''
        '''
         The JSON Private key to authenticate with.
        '''
        self.project = project if project is not None else ''
        '''
         The project to connect to.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.BigQuery ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'private_key: ' + repr(self.private_key) + ' ' +\
            'project: ' + repr(self.project) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'private_key': self.private_key,
            'project': self.project,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            private_key=d.get('private_key'),
            project=d.get('project'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Cassandra:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Cassandra ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Citus:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Citus ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Clustrix:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Clustrix ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Cockroach:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Cockroach ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class ControlPanelGetSSHCAPublicKeyResponse:
    '''
         ControlPanelGetSSHCAPublicKeyResponse represents a request for an
     organization's SSH Certificate Authority public key.
    '''
    __slots__ = [
        'meta',
        'public_key',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        public_key=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The public key of the SSH Certificate Authority, in OpenSSH RSA public
         key format.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelGetSSHCAPublicKeyResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'public_key': self.public_key,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            public_key=d.get('public_key'),
            rate_limit=d.get('rate_limit'),
        )


class ControlPanelVerifyJWTResponse:
    '''
         ControlPanelVerifyJWTResponse reports whether x-sdm-token is valid.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'valid',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        valid=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.valid = valid if valid is not None else False
        '''
         Reports if the given token is valid.
        '''

    def __repr__(self):
        return '<sdm.ControlPanelVerifyJWTResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'valid: ' + repr(self.valid) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'valid': self.valid,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            valid=d.get('valid'),
        )


class CreateResponseMetadata:
    '''
         CreateResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.CreateResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class CyberarkConjurStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkConjurStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMExperimentalStore:
    '''
    CyberarkPAMExperimentalStore is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMExperimentalStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class CyberarkPAMStore:
    __slots__ = [
        'appurl',
        'id',
        'name',
        'tags',
    ]

    def __init__(
        self,
        appurl=None,
        id=None,
        name=None,
        tags=None,
    ):
        self.appurl = appurl if appurl is not None else ''
        '''
         The URL of the Cyberark instance
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.CyberarkPAMStore ' + \
            'appurl: ' + repr(self.appurl) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'appurl': self.appurl,
            'id': self.id,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            appurl=d.get('appurl'),
            id=d.get('id'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class DB2I:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DB2I ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class DB2LUW:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DB2LUW ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DeleteResponseMetadata:
    '''
         DeleteResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.DeleteResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class DelineaStore:
    __slots__ = [
        'id',
        'name',
        'server_url',
        'tags',
        'tenant_name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        server_url=None,
        tags=None,
        tenant_name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.server_url = server_url if server_url is not None else ''
        '''
         The URL of the Delinea instance
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_name = tenant_name if tenant_name is not None else ''
        '''
         The tenant name to target
        '''

    def __repr__(self):
        return '<sdm.DelineaStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'server_url: ' + repr(self.server_url) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_name: ' + repr(self.tenant_name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'server_url': self.server_url,
            'tags': self.tags,
            'tenant_name': self.tenant_name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            server_url=d.get('server_url'),
            tags=d.get('tags'),
            tenant_name=d.get('tenant_name'),
        )


class DocumentDBHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DocumentDBReplicaSet:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         Hostname must contain the hostname/port pairs of all instances in the replica set separated by commas.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.DocumentDBReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Druid:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Druid ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class DynamoDB:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial e.g. dynamodb.region.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The region to authenticate requests against e.g. us-east-1
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.DynamoDB ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Elastic:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Elastic ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class ElasticacheRedis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.ElasticacheRedis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class GCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'id',
        'keyfile',
        'name',
        'port_override',
        'scopes',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        id=None,
        keyfile=None,
        name=None,
        port_override=None,
        scopes=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.keyfile = keyfile if keyfile is not None else ''
        '''
         The service account keyfile to authenticate with.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.scopes = scopes if scopes is not None else ''
        '''
         Space separated scopes that this login should assume into when authenticating.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'keyfile: ' + repr(self.keyfile) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'scopes: ' + repr(self.scopes) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'id': self.id,
            'keyfile': self.keyfile,
            'name': self.name,
            'port_override': self.port_override,
            'scopes': self.scopes,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            keyfile=d.get('keyfile'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            scopes=d.get('scopes'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class GCPStore:
    __slots__ = [
        'id',
        'name',
        'projectid',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        projectid=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.projectid = projectid if projectid is not None else ''
        '''
         The GCP project ID to target.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GCPStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'projectid: ' + repr(self.projectid) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'projectid': self.projectid,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            projectid=d.get('projectid'),
            tags=d.get('tags'),
        )


class Gateway:
    '''
         Gateway represents a StrongDM CLI installation running in gateway mode.
    '''
    __slots__ = [
        'bind_address',
        'connects_to',
        'device',
        'gateway_filter',
        'id',
        'listen_address',
        'location',
        'maintenance_windows',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        bind_address=None,
        connects_to=None,
        device=None,
        gateway_filter=None,
        id=None,
        listen_address=None,
        location=None,
        maintenance_windows=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.bind_address = bind_address if bind_address is not None else ''
        '''
         The hostname/port tuple which the gateway daemon will bind to.
         If not provided on create, set to "0.0.0.0:listen_address_port".
        '''
        self.connects_to = connects_to if connects_to is not None else ''
        '''
         ConnectsTo can be used to restrict the peering between relays and
         gateways.
        '''
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways. Deprecated.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Gateway.
        '''
        self.listen_address = listen_address if listen_address is not None else ''
        '''
         The public hostname/port tuple at which the gateway will be accessible to clients.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.maintenance_windows = maintenance_windows if maintenance_windows is not None else []
        '''
         Maintenance Windows define when this node is allowed to restart. If a node
         is requested to restart, it will check each window to determine if any of
         them permit it to restart, and if any do, it will. This check is repeated
         per window until the restart is successfully completed.
         
         If not set here, may be set on the command line or via an environment variable
         on the process itself; any server setting will take precedence over local
         settings. This setting is ineffective for nodes below version 38.44.0.
         
         If this setting is not applied via this remote configuration or via local
         configuration, the default setting is used: always allow restarts if serving
         no connections, and allow a restart even if serving connections between 7-8 UTC, any day.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Gateway. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the gateway. One of: "new", "verifying_restart",
         "restarting", "started", "stopped", "dead", "unknown"
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Gateway ' + \
            'bind_address: ' + repr(self.bind_address) + ' ' +\
            'connects_to: ' + repr(self.connects_to) + ' ' +\
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'listen_address: ' + repr(self.listen_address) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'maintenance_windows: ' + repr(self.maintenance_windows) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_address': self.bind_address,
            'connects_to': self.connects_to,
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'listen_address': self.listen_address,
            'location': self.location,
            'maintenance_windows': self.maintenance_windows,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_address=d.get('bind_address'),
            connects_to=d.get('connects_to'),
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            listen_address=d.get('listen_address'),
            location=d.get('location'),
            maintenance_windows=d.get('maintenance_windows'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class GetResponseMetadata:
    '''
         GetResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.GetResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class GoogleGKE:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'service_account_key',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        service_account_key=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        '''
         The service account key to authenticate with.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKE ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class GoogleGKEUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'egress_filter',
        'endpoint',
        'healthcheck_namespace',
        'healthy',
        'id',
        'name',
        'secret_store_id',
        'service_account_key',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        egress_filter=None,
        endpoint=None,
        healthcheck_namespace=None,
        healthy=None,
        id=None,
        name=None,
        secret_store_id=None,
        service_account_key=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The endpoint to dial.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.service_account_key = service_account_key if service_account_key is not None else ''
        '''
         The service account key to authenticate with.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.GoogleGKEUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'service_account_key: ' + repr(self.service_account_key) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'service_account_key': self.service_account_key,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            service_account_key=d.get('service_account_key'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Greenplum:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Greenplum ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class HTTPAuth:
    __slots__ = [
        'auth_header',
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        auth_header=None,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.auth_header = auth_header if auth_header is not None else ''
        '''
         The content to set as the authorization header.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''

    def __repr__(self):
        return '<sdm.HTTPAuth ' + \
            'auth_header: ' + repr(self.auth_header) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_header': self.auth_header,
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_header=d.get('auth_header'),
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class HTTPBasicAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'password',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        password=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.HTTPBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
            username=d.get('username'),
        )


class HTTPNoAuth:
    __slots__ = [
        'bind_interface',
        'default_path',
        'egress_filter',
        'headers_blacklist',
        'healthcheck_path',
        'healthy',
        'host_override',
        'id',
        'name',
        'secret_store_id',
        'subdomain',
        'tags',
        'url',
    ]

    def __init__(
        self,
        bind_interface=None,
        default_path=None,
        egress_filter=None,
        headers_blacklist=None,
        healthcheck_path=None,
        healthy=None,
        host_override=None,
        id=None,
        name=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        url=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.default_path = default_path if default_path is not None else ''
        '''
         Automatically redirect to this path upon connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.headers_blacklist = headers_blacklist if headers_blacklist is not None else ''
        '''
         Header names (e.g. Authorization), to omit from logs.
        '''
        self.healthcheck_path = healthcheck_path if healthcheck_path is not None else ''
        '''
         This path will be used to check the health of your site.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.host_override = host_override if host_override is not None else ''
        '''
         The host header will be overwritten with this field if provided.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.url = url if url is not None else ''
        '''
         The base address of your website without the path.
        '''

    def __repr__(self):
        return '<sdm.HTTPNoAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'default_path: ' + repr(self.default_path) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'headers_blacklist: ' + repr(self.headers_blacklist) + ' ' +\
            'healthcheck_path: ' + repr(self.healthcheck_path) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'host_override: ' + repr(self.host_override) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'url: ' + repr(self.url) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'default_path': self.default_path,
            'egress_filter': self.egress_filter,
            'headers_blacklist': self.headers_blacklist,
            'healthcheck_path': self.healthcheck_path,
            'healthy': self.healthy,
            'host_override': self.host_override,
            'id': self.id,
            'name': self.name,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'url': self.url,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            default_path=d.get('default_path'),
            egress_filter=d.get('egress_filter'),
            headers_blacklist=d.get('headers_blacklist'),
            healthcheck_path=d.get('healthcheck_path'),
            healthy=d.get('healthy'),
            host_override=d.get('host_override'),
            id=d.get('id'),
            name=d.get('name'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            url=d.get('url'),
        )


class Kubernetes:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Kubernetes ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class KubernetesBasicAuth:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesBasicAuth ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class KubernetesServiceAccount:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccount ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesServiceAccountUserImpersonation:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'token',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        token=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.token = token if token is not None else ''
        '''
         The API token to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.KubernetesServiceAccountUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            token=d.get('token'),
        )


class KubernetesUserImpersonation:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'egress_filter',
        'healthcheck_namespace',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        egress_filter=None,
        healthcheck_namespace=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_namespace = healthcheck_namespace if healthcheck_namespace is not None else ''
        '''
         The path used to check the health of your connection.  Defaults to `default`.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.KubernetesUserImpersonation ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_namespace: ' + repr(self.healthcheck_namespace) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'egress_filter': self.egress_filter,
            'healthcheck_namespace': self.healthcheck_namespace,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            egress_filter=d.get('egress_filter'),
            healthcheck_namespace=d.get('healthcheck_namespace'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class MTLSMysql:
    '''
    MTLSMysql is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'server_name',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        server_name=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        '''
         Server name for TLS verification (unverified by StrongDM if empty)
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MTLSMysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class MTLSPostgres:
    __slots__ = [
        'bind_interface',
        'certificate_authority',
        'client_certificate',
        'client_key',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'server_name',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        certificate_authority=None,
        client_certificate=None,
        client_key=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        server_name=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.certificate_authority = certificate_authority if certificate_authority is not None else ''
        '''
         The CA to authenticate TLS connections with.
        '''
        self.client_certificate = client_certificate if client_certificate is not None else ''
        '''
         The certificate to authenticate TLS connections with.
        '''
        self.client_key = client_key if client_key is not None else ''
        '''
         The key to authenticate TLS connections with.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_name = server_name if server_name is not None else ''
        '''
         Server name for TLS verification (unverified by StrongDM if empty)
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MTLSPostgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'certificate_authority: ' + repr(self.certificate_authority) + ' ' +\
            'client_certificate: ' + repr(self.client_certificate) + ' ' +\
            'client_key: ' + repr(self.client_key) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_name: ' + repr(self.server_name) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'certificate_authority': self.certificate_authority,
            'client_certificate': self.client_certificate,
            'client_key': self.client_key,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'server_name': self.server_name,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            certificate_authority=d.get('certificate_authority'),
            client_certificate=d.get('client_certificate'),
            client_key=d.get('client_key'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            server_name=d.get('server_name'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Maria:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Maria ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Memcached:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Memcached ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Memsql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Memsql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class MongoHost:
    '''
    MongoHost is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyHost:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoLegacyHost ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoLegacyReplicaset:
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoLegacyReplicaset ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoReplicaSet:
    '''
    MongoReplicaSet is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'connect_to_replica',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'replica_set',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        connect_to_replica=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        replica_set=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.connect_to_replica = connect_to_replica if connect_to_replica is not None else False
        '''
         Set to connect to a replica instead of the primary node.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.replica_set = replica_set if replica_set is not None else ''
        '''
         The name of the mongo replicaset.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoReplicaSet ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'connect_to_replica: ' + repr(self.connect_to_replica) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'replica_set: ' + repr(self.replica_set) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'connect_to_replica': self.connect_to_replica,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'replica_set': self.replica_set,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            connect_to_replica=d.get('connect_to_replica'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            replica_set=d.get('replica_set'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class MongoShardedCluster:
    '''
    MongoShardedCluster is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'auth_database',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        auth_database=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.auth_database = auth_database if auth_database is not None else ''
        '''
         The authentication database to use.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.MongoShardedCluster ' + \
            'auth_database: ' + repr(self.auth_database) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_database': self.auth_database,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_database=d.get('auth_database'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Mysql:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Mysql ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Neptune:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The neptune endpoint to connect to as in endpoint.region.neptune.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Neptune ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class NeptuneIAM:
    __slots__ = [
        'access_key',
        'bind_interface',
        'egress_filter',
        'endpoint',
        'healthy',
        'id',
        'name',
        'port',
        'port_override',
        'region',
        'role_arn',
        'role_external_id',
        'secret_access_key',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        access_key=None,
        bind_interface=None,
        egress_filter=None,
        endpoint=None,
        healthy=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        region=None,
        role_arn=None,
        role_external_id=None,
        secret_access_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.access_key = access_key if access_key is not None else ''
        '''
         The Access Key ID to use to authenticate.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.endpoint = endpoint if endpoint is not None else ''
        '''
         The neptune endpoint to connect to as in endpoint.region.neptune.amazonaws.com
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.region = region if region is not None else ''
        '''
         The AWS region to connect to.
        '''
        self.role_arn = role_arn if role_arn is not None else ''
        '''
         The role to assume after logging in.
        '''
        self.role_external_id = role_external_id if role_external_id is not None else ''
        '''
         The external ID to associate with assume role requests. Does nothing if a role ARN is not provided.
        '''
        self.secret_access_key = secret_access_key if secret_access_key is not None else ''
        '''
         The Secret Access Key to use to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.NeptuneIAM ' + \
            'access_key: ' + repr(self.access_key) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'endpoint: ' + repr(self.endpoint) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'region: ' + repr(self.region) + ' ' +\
            'role_arn: ' + repr(self.role_arn) + ' ' +\
            'role_external_id: ' + repr(self.role_external_id) + ' ' +\
            'secret_access_key: ' + repr(self.secret_access_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_key': self.access_key,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'endpoint': self.endpoint,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'region': self.region,
            'role_arn': self.role_arn,
            'role_external_id': self.role_external_id,
            'secret_access_key': self.secret_access_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_key=d.get('access_key'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            endpoint=d.get('endpoint'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            region=d.get('region'),
            role_arn=d.get('role_arn'),
            role_external_id=d.get('role_external_id'),
            secret_access_key=d.get('secret_access_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class NodeCreateResponse:
    '''
         NodeCreateResponse reports how the Nodes were created in the system.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
        'token',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
        token=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The created Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.token = token if token is not None else ''
        '''
         The auth token generated for the Node. The Node will use this token to
         authenticate with the strongDM API.
        '''

    def __repr__(self):
        return '<sdm.NodeCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'token: ' + repr(self.token) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
            'token': self.token,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
            token=d.get('token'),
        )


class NodeDeleteResponse:
    '''
         NodeDeleteResponse returns information about a Node that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class NodeGetResponse:
    '''
         NodeGetResponse returns a requested Node.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The requested Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class NodeHistory:
    '''
         NodeHistory records the state of a Node at a given point in time,
     where every change (create, update and delete) to a Node produces an
     NodeHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'node',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        node=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Node.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Node was deleted, the time it was deleted.
        '''
        self.node = node if node is not None else None
        '''
         The complete Node state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Node state was recorded.
        '''

    def __repr__(self):
        return '<sdm.NodeHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'node': self.node,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            node=d.get('node'),
            timestamp=d.get('timestamp'),
        )


class NodeMaintenanceWindow:
    __slots__ = [
        'cron_schedule',
        'require_idleness',
    ]

    def __init__(
        self,
        cron_schedule=None,
        require_idleness=None,
    ):
        self.cron_schedule = cron_schedule if cron_schedule is not None else ''
        '''
         Cron job syntax for when this maintenance window is active. On this schedule, associated
         nodes will restart if requested, provided other checks allow the restart to proceed. Times
         are represented in UTC.
         e.g. * 7 * * 0,6 to check for a restart at every minute from 7:00 to 8:00 UTC on Sunday and
         Saturday. Not all possible inputs are supported: the month and day of month selections
         must be '*'.
        '''
        self.require_idleness = require_idleness if require_idleness is not None else False
        '''
         Require Idleness defines whether this window can sever live connections. If true,
         this window will not allow a node to be restarted unless it is serving no connections.
         If false, given a restart of the node has been requested (for an update, usually), the
         node will restart as soon as it enters an allowed day / hour combination. At least one
         maintenance window, out of all configured windows for a node, must have this as false.
        '''

    def __repr__(self):
        return '<sdm.NodeMaintenanceWindow ' + \
            'cron_schedule: ' + repr(self.cron_schedule) + ' ' +\
            'require_idleness: ' + repr(self.require_idleness) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'cron_schedule': self.cron_schedule,
            'require_idleness': self.require_idleness,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            cron_schedule=d.get('cron_schedule'),
            require_idleness=d.get('require_idleness'),
        )


class NodeUpdateResponse:
    '''
         NodeUpdateResponse returns the fields of a Node after it has been updated by
     a NodeUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'node',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        node=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.node = node if node is not None else None
        '''
         The updated Node.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.NodeUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'node: ' + repr(self.node) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'node': self.node,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            node=d.get('node'),
            rate_limit=d.get('rate_limit'),
        )


class Oracle:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Oracle ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Organization:
    __slots__ = [
        'auth_provider',
        'created_at',
        'idle_timeout',
        'idle_timeout_enabled',
        'kind',
        'log_local_encoder',
        'log_local_format',
        'log_local_storage',
        'log_remote_encoder',
        'log_socket_path',
        'log_tcp_address',
        'mfa_enabled',
        'mfa_provider',
        'name',
        'require_secret_store',
        'saml_metadata_url',
        'scim_provider',
        'sensitive_label',
        'session_timeout',
        'session_timeout_enabled',
        'ssh_certificate_authority_public_key',
        'ssh_certificate_authority_updated_at',
        'updated_at',
        'websites_subdomain',
    ]

    def __init__(
        self,
        auth_provider=None,
        created_at=None,
        idle_timeout=None,
        idle_timeout_enabled=None,
        kind=None,
        log_local_encoder=None,
        log_local_format=None,
        log_local_storage=None,
        log_remote_encoder=None,
        log_socket_path=None,
        log_tcp_address=None,
        mfa_enabled=None,
        mfa_provider=None,
        name=None,
        require_secret_store=None,
        saml_metadata_url=None,
        scim_provider=None,
        sensitive_label=None,
        session_timeout=None,
        session_timeout_enabled=None,
        ssh_certificate_authority_public_key=None,
        ssh_certificate_authority_updated_at=None,
        updated_at=None,
        websites_subdomain=None,
    ):
        self.auth_provider = auth_provider if auth_provider is not None else ''
        '''
         The Organization's authentication provider.
        '''
        self.created_at = created_at if created_at is not None else None
        '''
         The time at which the Organization was created.
        '''
        self.idle_timeout = idle_timeout if idle_timeout is not None else None
        '''
         The Organization's idle timeout, if enabled.
        '''
        self.idle_timeout_enabled = idle_timeout_enabled if idle_timeout_enabled is not None else False
        '''
         Indicates if the Organization has idle timeouts enabled.
        '''
        self.kind = kind if kind is not None else ''
        '''
         The Organization's type.
        '''
        self.log_local_encoder = log_local_encoder if log_local_encoder is not None else ''
        '''
         The Organization's local log encryption encoder.
        '''
        self.log_local_format = log_local_format if log_local_format is not None else ''
        '''
         The Organization's local log format.
        '''
        self.log_local_storage = log_local_storage if log_local_storage is not None else ''
        '''
         The Organization's local log storage.
        '''
        self.log_remote_encoder = log_remote_encoder if log_remote_encoder is not None else ''
        '''
         The Organization's remote log encryption encoder.
        '''
        self.log_socket_path = log_socket_path if log_socket_path is not None else ''
        '''
         The Organization's socket path for Socket local log storage.
        '''
        self.log_tcp_address = log_tcp_address if log_tcp_address is not None else ''
        '''
         The Organization's TCP address for TCP or Syslog local log storage.
        '''
        self.mfa_enabled = mfa_enabled if mfa_enabled is not None else False
        '''
         Indicates if the Organization has multi-factor authentication enabled.
        '''
        self.mfa_provider = mfa_provider if mfa_provider is not None else ''
        '''
         The Organization's multi-factor authentication provider, if enabled.
        '''
        self.name = name if name is not None else ''
        '''
         The Organization's name.
        '''
        self.require_secret_store = require_secret_store if require_secret_store is not None else False
        '''
         Indicates if the Organization requires secret stores.
        '''
        self.saml_metadata_url = saml_metadata_url if saml_metadata_url is not None else ''
        '''
         The Organization's URL for SAML metadata.
        '''
        self.scim_provider = scim_provider if scim_provider is not None else ''
        '''
         The Organization's SCIM provider.
        '''
        self.sensitive_label = sensitive_label if sensitive_label is not None else ''
        '''
         The Organization's label for sensitive resources.
        '''
        self.session_timeout = session_timeout if session_timeout is not None else None
        '''
         The Organization's session timeout, if enabled.
        '''
        self.session_timeout_enabled = session_timeout_enabled if session_timeout_enabled is not None else False
        '''
         Indicates if the Organization has session timeouts enabled.
        '''
        self.ssh_certificate_authority_public_key = ssh_certificate_authority_public_key if ssh_certificate_authority_public_key is not None else ''
        '''
         The Organization's SSH certificate authority public key.
        '''
        self.ssh_certificate_authority_updated_at = ssh_certificate_authority_updated_at if ssh_certificate_authority_updated_at is not None else None
        '''
         The time at which the Organization's SSH certificate authority was last updated.
        '''
        self.updated_at = updated_at if updated_at is not None else None
        '''
         The time at which the Organization was last updated.
        '''
        self.websites_subdomain = websites_subdomain if websites_subdomain is not None else ''
        '''
         The Organization's web site domain.
        '''

    def __repr__(self):
        return '<sdm.Organization ' + \
            'auth_provider: ' + repr(self.auth_provider) + ' ' +\
            'created_at: ' + repr(self.created_at) + ' ' +\
            'idle_timeout: ' + repr(self.idle_timeout) + ' ' +\
            'idle_timeout_enabled: ' + repr(self.idle_timeout_enabled) + ' ' +\
            'kind: ' + repr(self.kind) + ' ' +\
            'log_local_encoder: ' + repr(self.log_local_encoder) + ' ' +\
            'log_local_format: ' + repr(self.log_local_format) + ' ' +\
            'log_local_storage: ' + repr(self.log_local_storage) + ' ' +\
            'log_remote_encoder: ' + repr(self.log_remote_encoder) + ' ' +\
            'log_socket_path: ' + repr(self.log_socket_path) + ' ' +\
            'log_tcp_address: ' + repr(self.log_tcp_address) + ' ' +\
            'mfa_enabled: ' + repr(self.mfa_enabled) + ' ' +\
            'mfa_provider: ' + repr(self.mfa_provider) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'require_secret_store: ' + repr(self.require_secret_store) + ' ' +\
            'saml_metadata_url: ' + repr(self.saml_metadata_url) + ' ' +\
            'scim_provider: ' + repr(self.scim_provider) + ' ' +\
            'sensitive_label: ' + repr(self.sensitive_label) + ' ' +\
            'session_timeout: ' + repr(self.session_timeout) + ' ' +\
            'session_timeout_enabled: ' + repr(self.session_timeout_enabled) + ' ' +\
            'ssh_certificate_authority_public_key: ' + repr(self.ssh_certificate_authority_public_key) + ' ' +\
            'ssh_certificate_authority_updated_at: ' + repr(self.ssh_certificate_authority_updated_at) + ' ' +\
            'updated_at: ' + repr(self.updated_at) + ' ' +\
            'websites_subdomain: ' + repr(self.websites_subdomain) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'auth_provider': self.auth_provider,
            'created_at': self.created_at,
            'idle_timeout': self.idle_timeout,
            'idle_timeout_enabled': self.idle_timeout_enabled,
            'kind': self.kind,
            'log_local_encoder': self.log_local_encoder,
            'log_local_format': self.log_local_format,
            'log_local_storage': self.log_local_storage,
            'log_remote_encoder': self.log_remote_encoder,
            'log_socket_path': self.log_socket_path,
            'log_tcp_address': self.log_tcp_address,
            'mfa_enabled': self.mfa_enabled,
            'mfa_provider': self.mfa_provider,
            'name': self.name,
            'require_secret_store': self.require_secret_store,
            'saml_metadata_url': self.saml_metadata_url,
            'scim_provider': self.scim_provider,
            'sensitive_label': self.sensitive_label,
            'session_timeout': self.session_timeout,
            'session_timeout_enabled': self.session_timeout_enabled,
            'ssh_certificate_authority_public_key':
            self.ssh_certificate_authority_public_key,
            'ssh_certificate_authority_updated_at':
            self.ssh_certificate_authority_updated_at,
            'updated_at': self.updated_at,
            'websites_subdomain': self.websites_subdomain,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            auth_provider=d.get('auth_provider'),
            created_at=d.get('created_at'),
            idle_timeout=d.get('idle_timeout'),
            idle_timeout_enabled=d.get('idle_timeout_enabled'),
            kind=d.get('kind'),
            log_local_encoder=d.get('log_local_encoder'),
            log_local_format=d.get('log_local_format'),
            log_local_storage=d.get('log_local_storage'),
            log_remote_encoder=d.get('log_remote_encoder'),
            log_socket_path=d.get('log_socket_path'),
            log_tcp_address=d.get('log_tcp_address'),
            mfa_enabled=d.get('mfa_enabled'),
            mfa_provider=d.get('mfa_provider'),
            name=d.get('name'),
            require_secret_store=d.get('require_secret_store'),
            saml_metadata_url=d.get('saml_metadata_url'),
            scim_provider=d.get('scim_provider'),
            sensitive_label=d.get('sensitive_label'),
            session_timeout=d.get('session_timeout'),
            session_timeout_enabled=d.get('session_timeout_enabled'),
            ssh_certificate_authority_public_key=d.get(
                'ssh_certificate_authority_public_key'),
            ssh_certificate_authority_updated_at=d.get(
                'ssh_certificate_authority_updated_at'),
            updated_at=d.get('updated_at'),
            websites_subdomain=d.get('websites_subdomain'),
        )


class OrganizationHistoryRecord:
    '''
         OrganizationHistoryRecord records the state of an Organization at a given point in time,
     where every change to an Organization produces an OrganizationHistoryRecord.
    '''
    __slots__ = [
        'activity_id',
        'organization',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        organization=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Organization.
         May be empty for some system-initiated organization updates.
        '''
        self.organization = organization if organization is not None else None
        '''
         The complete Organization state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Organization state was recorded.
        '''

    def __repr__(self):
        return '<sdm.OrganizationHistoryRecord ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'organization: ' + repr(self.organization) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'organization': self.organization,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            organization=d.get('organization'),
            timestamp=d.get('timestamp'),
        )


class Postgres:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Postgres ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Presto:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Presto ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Query:
    '''
         A Query is a record of a single client request to a resource, such as a SQL query.
     Longer-running queries including long-running SSH commands and SSH, RDP, or Kubernetes
     interactive sessions will return two Query records with the same identifier, one record
     at the start of the query and a second record upon the completion of the query with
     additional detail.
    '''
    __slots__ = [
        'account_email',
        'account_first_name',
        'account_id',
        'account_last_name',
        'account_tags',
        'capture',
        'completed_at',
        'duration',
        'egress_node_id',
        'encrypted',
        'id',
        'query_body',
        'query_category',
        'query_hash',
        'query_key',
        'record_count',
        'remote_identity_username',
        'replayable',
        'resource_id',
        'resource_name',
        'resource_tags',
        'resource_type',
        'timestamp',
    ]

    def __init__(
        self,
        account_email=None,
        account_first_name=None,
        account_id=None,
        account_last_name=None,
        account_tags=None,
        capture=None,
        completed_at=None,
        duration=None,
        egress_node_id=None,
        encrypted=None,
        id=None,
        query_body=None,
        query_category=None,
        query_hash=None,
        query_key=None,
        record_count=None,
        remote_identity_username=None,
        replayable=None,
        resource_id=None,
        resource_name=None,
        resource_tags=None,
        resource_type=None,
        timestamp=None,
    ):
        self.account_email = account_email if account_email is not None else ''
        '''
         The email of the account performing this query, at the time the query was executed.
         If the account email is later changed, that change will not be reflected via this field.
        '''
        self.account_first_name = account_first_name if account_first_name is not None else ''
        '''
         The given name of the account performing this query, at the time the query was executed.
         If the account is later renamed, that change will not be reflected via this field.
        '''
        self.account_id = account_id if account_id is not None else ''
        '''
         Unique identifier of the Account that performed the Query.
        '''
        self.account_last_name = account_last_name if account_last_name is not None else ''
        '''
         The family name of the account performing this query, at the time the query was executed.
         If the account is later renamed, that change will not be reflected via this field.
        '''
        self.account_tags = account_tags if account_tags is not None else _porcelain_zero_value_tags(
        )
        '''
         The tags of the account accessed, at the time the query was executed. If the account
         tags are later changed, that change will not be reflected via this field.
        '''
        self.capture = capture if capture is not None else None
        '''
         For queries against SSH, Kubernetes, and RDP resources, this contains additional information
         about the captured query.
        '''
        self.completed_at = completed_at if completed_at is not None else None
        '''
         The time at which the Query was completed.
         Empty if this record indicates the start of a long-running query.
        '''
        self.duration = duration if duration is not None else None
        '''
         The duration of the Query.
        '''
        self.egress_node_id = egress_node_id if egress_node_id is not None else ''
        '''
         The unique ID of the node through which the Resource was accessed.
        '''
        self.encrypted = encrypted if encrypted is not None else False
        '''
         Indicates that the body of the Query is encrypted.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Query.
        '''
        self.query_body = query_body if query_body is not None else ''
        '''
         The captured content of the Query.
         For queries against SSH, Kubernetes, and RDP resources, this contains a JSON representation of the QueryCapture.
        '''
        self.query_category = query_category if query_category is not None else ''
        '''
         The general category of Resource against which Query was performed, e.g. "web" or "cloud".
        '''
        self.query_hash = query_hash if query_hash is not None else ''
        '''
         The hash of the body of the Query.
        '''
        self.query_key = query_key if query_key is not None else ''
        '''
         The symmetric key used to encrypt the body of this Query and its replay if replayable.
         If the Query is encrypted, this field contains an encrypted symmetric key in base64 encoding.
         This key must be decrypted with the organization's private key to obtain the symmetric key needed to decrypt the body.
         If the Query is not encrypted, this field is empty.
        '''
        self.record_count = record_count if record_count is not None else 0
        '''
         The number of records returned by the Query, for a database Resource.
        '''
        self.remote_identity_username = remote_identity_username if remote_identity_username is not None else ''
        '''
         The username of the RemoteIdentity used to access the Resource.
        '''
        self.replayable = replayable if replayable is not None else False
        '''
         Indicates that the Query is replayable, e.g. for some SSH or K8s sessions.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         Unique identifier of the Resource against which the Query was performed.
        '''
        self.resource_name = resource_name if resource_name is not None else ''
        '''
         The name of the resource accessed, at the time the query was executed. If the resource
         is later renamed, that change will not be reflected via this field.
        '''
        self.resource_tags = resource_tags if resource_tags is not None else _porcelain_zero_value_tags(
        )
        '''
         The tags of the resource accessed, at the time the query was executed. If the resource
         tags are later changed, that change will not be reflected via this field.
        '''
        self.resource_type = resource_type if resource_type is not None else ''
        '''
         The specific type of Resource against which the Query was performed, e.g. "ssh" or "postgres".
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Query was started.
        '''

    def __repr__(self):
        return '<sdm.Query ' + \
            'account_email: ' + repr(self.account_email) + ' ' +\
            'account_first_name: ' + repr(self.account_first_name) + ' ' +\
            'account_id: ' + repr(self.account_id) + ' ' +\
            'account_last_name: ' + repr(self.account_last_name) + ' ' +\
            'account_tags: ' + repr(self.account_tags) + ' ' +\
            'capture: ' + repr(self.capture) + ' ' +\
            'completed_at: ' + repr(self.completed_at) + ' ' +\
            'duration: ' + repr(self.duration) + ' ' +\
            'egress_node_id: ' + repr(self.egress_node_id) + ' ' +\
            'encrypted: ' + repr(self.encrypted) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'query_body: ' + repr(self.query_body) + ' ' +\
            'query_category: ' + repr(self.query_category) + ' ' +\
            'query_hash: ' + repr(self.query_hash) + ' ' +\
            'query_key: ' + repr(self.query_key) + ' ' +\
            'record_count: ' + repr(self.record_count) + ' ' +\
            'remote_identity_username: ' + repr(self.remote_identity_username) + ' ' +\
            'replayable: ' + repr(self.replayable) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'resource_name: ' + repr(self.resource_name) + ' ' +\
            'resource_tags: ' + repr(self.resource_tags) + ' ' +\
            'resource_type: ' + repr(self.resource_type) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_email': self.account_email,
            'account_first_name': self.account_first_name,
            'account_id': self.account_id,
            'account_last_name': self.account_last_name,
            'account_tags': self.account_tags,
            'capture': self.capture,
            'completed_at': self.completed_at,
            'duration': self.duration,
            'egress_node_id': self.egress_node_id,
            'encrypted': self.encrypted,
            'id': self.id,
            'query_body': self.query_body,
            'query_category': self.query_category,
            'query_hash': self.query_hash,
            'query_key': self.query_key,
            'record_count': self.record_count,
            'remote_identity_username': self.remote_identity_username,
            'replayable': self.replayable,
            'resource_id': self.resource_id,
            'resource_name': self.resource_name,
            'resource_tags': self.resource_tags,
            'resource_type': self.resource_type,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_email=d.get('account_email'),
            account_first_name=d.get('account_first_name'),
            account_id=d.get('account_id'),
            account_last_name=d.get('account_last_name'),
            account_tags=d.get('account_tags'),
            capture=d.get('capture'),
            completed_at=d.get('completed_at'),
            duration=d.get('duration'),
            egress_node_id=d.get('egress_node_id'),
            encrypted=d.get('encrypted'),
            id=d.get('id'),
            query_body=d.get('query_body'),
            query_category=d.get('query_category'),
            query_hash=d.get('query_hash'),
            query_key=d.get('query_key'),
            record_count=d.get('record_count'),
            remote_identity_username=d.get('remote_identity_username'),
            replayable=d.get('replayable'),
            resource_id=d.get('resource_id'),
            resource_name=d.get('resource_name'),
            resource_tags=d.get('resource_tags'),
            resource_type=d.get('resource_type'),
            timestamp=d.get('timestamp'),
        )


class QueryCapture:
    '''
         A QueryCapture contains additional information about queries against SSH, Kubernetes, and RDP resources.
    '''
    __slots__ = [
        'client_command',
        'command',
        'container',
        'env',
        'file_name',
        'file_size',
        'height',
        'pod',
        'request_body',
        'request_method',
        'request_uri',
        'type',
        'width',
    ]

    def __init__(
        self,
        client_command=None,
        command=None,
        container=None,
        env=None,
        file_name=None,
        file_size=None,
        height=None,
        pod=None,
        request_body=None,
        request_method=None,
        request_uri=None,
        type=None,
        width=None,
    ):
        self.client_command = client_command if client_command is not None else ''
        '''
         The command executed on the client for a Kubernetes session.
        '''
        self.command = command if command is not None else ''
        '''
         The command executed over an SSH or Kubernetes session.
        '''
        self.container = container if container is not None else ''
        '''
         The target container of a Kubernetes operation.
        '''
        self.env = env if env is not None else {}
        '''
         The environment variables for an SSH or Kubernetes session.
        '''
        self.file_name = file_name if file_name is not None else ''
        '''
         The remote file name of an SCP operation.
        '''
        self.file_size = file_size if file_size is not None else 0
        '''
         The file size transferred for an SCP operation.
        '''
        self.height = height if height is not None else 0
        '''
         The height of the terminal or window for SSH, Kubernetes, and RDP interactive sessions.
        '''
        self.pod = pod if pod is not None else ''
        '''
         The target pod of a Kubernetes operation.
        '''
        self.request_body = request_body if request_body is not None else b''
        '''
         The HTTP request body of a Kubernetes operation.
        '''
        self.request_method = request_method if request_method is not None else ''
        '''
         The HTTP request method of a Kubernetes operation.
        '''
        self.request_uri = request_uri if request_uri is not None else ''
        '''
         The HTTP request URI of a Kubernetes operation.
        '''
        self.type = type if type is not None else ''
        '''
         The CaptureType of this query capture.
        '''
        self.width = width if width is not None else 0
        '''
         The width of the terminal or window for SSH, Kubernetes, and RDP interactive sessions.
        '''

    def __repr__(self):
        return '<sdm.QueryCapture ' + \
            'client_command: ' + repr(self.client_command) + ' ' +\
            'command: ' + repr(self.command) + ' ' +\
            'container: ' + repr(self.container) + ' ' +\
            'env: ' + repr(self.env) + ' ' +\
            'file_name: ' + repr(self.file_name) + ' ' +\
            'file_size: ' + repr(self.file_size) + ' ' +\
            'height: ' + repr(self.height) + ' ' +\
            'pod: ' + repr(self.pod) + ' ' +\
            'request_body: ' + repr(self.request_body) + ' ' +\
            'request_method: ' + repr(self.request_method) + ' ' +\
            'request_uri: ' + repr(self.request_uri) + ' ' +\
            'type: ' + repr(self.type) + ' ' +\
            'width: ' + repr(self.width) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'client_command': self.client_command,
            'command': self.command,
            'container': self.container,
            'env': self.env,
            'file_name': self.file_name,
            'file_size': self.file_size,
            'height': self.height,
            'pod': self.pod,
            'request_body': self.request_body,
            'request_method': self.request_method,
            'request_uri': self.request_uri,
            'type': self.type,
            'width': self.width,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            client_command=d.get('client_command'),
            command=d.get('command'),
            container=d.get('container'),
            env=d.get('env'),
            file_name=d.get('file_name'),
            file_size=d.get('file_size'),
            height=d.get('height'),
            pod=d.get('pod'),
            request_body=d.get('request_body'),
            request_method=d.get('request_method'),
            request_uri=d.get('request_uri'),
            type=d.get('type'),
            width=d.get('width'),
        )


class RDP:
    __slots__ = [
        'bind_interface',
        'downgrade_nla_connections',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        downgrade_nla_connections=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.downgrade_nla_connections = downgrade_nla_connections if downgrade_nla_connections is not None else False
        '''
         When set, network level authentication will not be used. May resolve unexpected authentication errors to older servers. When set, healthchecks cannot detect if a provided username / password pair is correct.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RDP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'downgrade_nla_connections: ' + repr(self.downgrade_nla_connections) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'downgrade_nla_connections': self.downgrade_nla_connections,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            downgrade_nla_connections=d.get('downgrade_nla_connections'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class RabbitMQAMQP091:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.RabbitMQAMQP091 ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class RateLimitMetadata:
    '''
         RateLimitMetadata contains information about remaining requests avaialable
     to the user over some timeframe.
    '''
    __slots__ = [
        'bucket',
        'limit',
        'remaining',
        'reset_at',
    ]

    def __init__(
        self,
        bucket=None,
        limit=None,
        remaining=None,
        reset_at=None,
    ):
        self.bucket = bucket if bucket is not None else ''
        '''
         The bucket this user/token is associated with, which may be shared between
         multiple users/tokens.
        '''
        self.limit = limit if limit is not None else 0
        '''
         How many total requests the user/token is authorized to make before being
         rate limited.
        '''
        self.remaining = remaining if remaining is not None else 0
        '''
         How many remaining requests out of the limit are still avaialable.
        '''
        self.reset_at = reset_at if reset_at is not None else None
        '''
         The time when remaining will be reset to limit.
        '''

    def __repr__(self):
        return '<sdm.RateLimitMetadata ' + \
            'bucket: ' + repr(self.bucket) + ' ' +\
            'limit: ' + repr(self.limit) + ' ' +\
            'remaining: ' + repr(self.remaining) + ' ' +\
            'reset_at: ' + repr(self.reset_at) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bucket': self.bucket,
            'limit': self.limit,
            'remaining': self.remaining,
            'reset_at': self.reset_at,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bucket=d.get('bucket'),
            limit=d.get('limit'),
            remaining=d.get('remaining'),
            reset_at=d.get('reset_at'),
        )


class RawTCP:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.RawTCP ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Redis:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'tls_required',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tls_required=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tls_required = tls_required if tls_required is not None else False
        '''
         If set, TLS must be used to connect to this resource.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Redis ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tls_required: ' + repr(self.tls_required) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tls_required': self.tls_required,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tls_required=d.get('tls_required'),
            username=d.get('username'),
        )


class Redshift:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Redshift ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Relay:
    '''
         Relay represents a StrongDM CLI installation running in relay mode.
    '''
    __slots__ = [
        'connects_to',
        'device',
        'gateway_filter',
        'id',
        'location',
        'maintenance_windows',
        'name',
        'state',
        'tags',
        'version',
    ]

    def __init__(
        self,
        connects_to=None,
        device=None,
        gateway_filter=None,
        id=None,
        location=None,
        maintenance_windows=None,
        name=None,
        state=None,
        tags=None,
        version=None,
    ):
        self.connects_to = connects_to if connects_to is not None else ''
        '''
         ConnectsTo can be used to restrict the peering between relays and
         gateways.
        '''
        self.device = device if device is not None else ''
        '''
         Device is a read only device name uploaded by the gateway process when
         it comes online.
        '''
        self.gateway_filter = gateway_filter if gateway_filter is not None else ''
        '''
         GatewayFilter can be used to restrict the peering between relays and
         gateways. Deprecated.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Relay.
        '''
        self.location = location if location is not None else ''
        '''
         Location is a read only network location uploaded by the gateway process
         when it comes online.
        '''
        self.maintenance_windows = maintenance_windows if maintenance_windows is not None else []
        '''
         Maintenance Windows define when this node is allowed to restart. If a node
         is requested to restart, it will check each window to determine if any of
         them permit it to restart, and if any do, it will. This check is repeated
         per window until the restart is successfully completed.
         
         If not set here, may be set on the command line or via an environment variable
         on the process itself; any server setting will take precedence over local
         settings. This setting is ineffective for nodes below version 38.44.0.
         
         If this setting is not applied via this remote configuration or via local
         configuration, the default setting is used: always allow restarts if serving
         no connections, and allow a restart even if serving connections between 7-8 UTC, any day.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Relay. Node names must include only letters, numbers, and hyphens (no spaces, underscores, or other special characters). Generated if not provided on create.
        '''
        self.state = state if state is not None else ''
        '''
         The current state of the relay. One of: "new", "verifying_restart",
         "awaiting_restart", "restarting", "started", "stopped", "dead",
         "unknown".
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.version = version if version is not None else ''
        '''
         Version is a read only sdm binary version uploaded by the gateway process
         when it comes online.
        '''

    def __repr__(self):
        return '<sdm.Relay ' + \
            'connects_to: ' + repr(self.connects_to) + ' ' +\
            'device: ' + repr(self.device) + ' ' +\
            'gateway_filter: ' + repr(self.gateway_filter) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'location: ' + repr(self.location) + ' ' +\
            'maintenance_windows: ' + repr(self.maintenance_windows) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'state: ' + repr(self.state) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'version: ' + repr(self.version) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'connects_to': self.connects_to,
            'device': self.device,
            'gateway_filter': self.gateway_filter,
            'id': self.id,
            'location': self.location,
            'maintenance_windows': self.maintenance_windows,
            'name': self.name,
            'state': self.state,
            'tags': self.tags,
            'version': self.version,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            connects_to=d.get('connects_to'),
            device=d.get('device'),
            gateway_filter=d.get('gateway_filter'),
            id=d.get('id'),
            location=d.get('location'),
            maintenance_windows=d.get('maintenance_windows'),
            name=d.get('name'),
            state=d.get('state'),
            tags=d.get('tags'),
            version=d.get('version'),
        )


class RemoteIdentity:
    '''
         RemoteIdentities define the username to be used for a specific account
     when connecting to a remote resource using that group.
    '''
    __slots__ = [
        'account_id',
        'id',
        'remote_identity_group_id',
        'username',
    ]

    def __init__(
        self,
        account_id=None,
        id=None,
        remote_identity_group_id=None,
        username=None,
    ):
        self.account_id = account_id if account_id is not None else ''
        '''
         The account for this remote identity.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentity.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The remote identity group.
        '''
        self.username = username if username is not None else ''
        '''
         The username to be used as the remote identity for this account.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentity ' + \
            'account_id: ' + repr(self.account_id) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'account_id': self.account_id,
            'id': self.id,
            'remote_identity_group_id': self.remote_identity_group_id,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            account_id=d.get('account_id'),
            id=d.get('id'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            username=d.get('username'),
        )


class RemoteIdentityCreateResponse:
    '''
         RemoteIdentityCreateResponse reports how the RemoteIdentities were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The created RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityDeleteResponse:
    '''
         RemoteIdentityDeleteResponse returns information about a RemoteIdentity that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RemoteIdentityGetResponse:
    '''
         RemoteIdentityGetResponse returns a requested RemoteIdentity.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The requested RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class RemoteIdentityGroup:
    '''
         A RemoteIdentityGroup defines a group of remote identities.
    '''
    __slots__ = [
        'id',
        'name',
    ]

    def __init__(
        self,
        id=None,
        name=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the RemoteIdentityGroup.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroup ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
        )


class RemoteIdentityGroupGetResponse:
    '''
         RemoteIdentityGroupGetResponse returns a requested RemoteIdentityGroup.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity_group',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity_group=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity_group = remote_identity_group if remote_identity_group is not None else None
        '''
         The requested RemoteIdentityGroup.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroupGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity_group: ' + repr(self.remote_identity_group) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity_group': self.remote_identity_group,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity_group=d.get('remote_identity_group'),
        )


class RemoteIdentityGroupHistory:
    '''
         RemoteIdentityGroupHistory records the state of a RemoteIdentityGroup at a given point in time,
     where every change (create, update and delete) to a RemoteIdentityGroup produces an
     RemoteIdentityGroupHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'remote_identity_group',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        remote_identity_group=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the RemoteIdentityGroup.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this RemoteIdentityGroup was deleted, the time it was deleted.
        '''
        self.remote_identity_group = remote_identity_group if remote_identity_group is not None else None
        '''
         The complete RemoteIdentityGroup state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the RemoteIdentityGroup state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityGroupHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'remote_identity_group: ' + repr(self.remote_identity_group) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'remote_identity_group': self.remote_identity_group,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            remote_identity_group=d.get('remote_identity_group'),
            timestamp=d.get('timestamp'),
        )


class RemoteIdentityHistory:
    '''
         RemoteIdentityHistory records the state of a RemoteIdentity at a given point in time,
     where every change (create, update and delete) to a RemoteIdentity produces an
     RemoteIdentityHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'remote_identity',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        remote_identity=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the RemoteIdentity.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this RemoteIdentity was deleted, the time it was deleted.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The complete RemoteIdentity state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the RemoteIdentity state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'remote_identity': self.remote_identity,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            remote_identity=d.get('remote_identity'),
            timestamp=d.get('timestamp'),
        )


class RemoteIdentityUpdateResponse:
    '''
         RemoteIdentityUpdateResponse returns the fields of a RemoteIdentity after it has been updated by
     a RemoteIdentityUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'remote_identity',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        remote_identity=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.remote_identity = remote_identity if remote_identity is not None else None
        '''
         The updated RemoteIdentity.
        '''

    def __repr__(self):
        return '<sdm.RemoteIdentityUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'remote_identity: ' + repr(self.remote_identity) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'remote_identity': self.remote_identity,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            remote_identity=d.get('remote_identity'),
        )


class ReplayChunk:
    '''
         A ReplayChunk represents a single "chunk" of data from the query replay.
    '''
    __slots__ = [
        'data',
        'events',
    ]

    def __init__(
        self,
        data=None,
        events=None,
    ):
        self.data = data if data is not None else b''
        '''
         The raw data of the ReplayChunk. The data is encrypted if the associated Query is encrypted.
        '''
        self.events = events if events is not None else []
        '''
         The list of events of the ReplayChunk. If the Query is encrypted, this field is always empty
         and the events can be obtained by decrypting the data using the QueryKey returned with the Query.
        '''

    def __repr__(self):
        return '<sdm.ReplayChunk ' + \
            'data: ' + repr(self.data) + ' ' +\
            'events: ' + repr(self.events) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'data': self.data,
            'events': self.events,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            data=d.get('data'),
            events=d.get('events'),
        )


class ReplayChunkEvent:
    '''
         A ReplayChunkEvent represents a single event within a query replay.
     The timing information included in each ReplayChunkEvent may be used to replay a session in real time.
    '''
    __slots__ = [
        'data',
        'duration',
    ]

    def __init__(
        self,
        data=None,
        duration=None,
    ):
        self.data = data if data is not None else b''
        '''
         The raw data of the ReplayChunkEvent.
        '''
        self.duration = duration if duration is not None else None
        '''
         The time duration over which the data in this ReplayChunkEvent was transferred.
        '''

    def __repr__(self):
        return '<sdm.ReplayChunkEvent ' + \
            'data: ' + repr(self.data) + ' ' +\
            'duration: ' + repr(self.duration) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'data': self.data,
            'duration': self.duration,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            data=d.get('data'),
            duration=d.get('duration'),
        )


class ResourceCreateResponse:
    '''
         ResourceCreateResponse reports how the Resources were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The created Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceDeleteResponse:
    '''
         ResourceDeleteResponse returns information about a Resource that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.ResourceDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class ResourceGetResponse:
    '''
         ResourceGetResponse returns a requested Resource.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The requested Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class ResourceHistory:
    '''
         ResourceHistory records the state of a Resource at a given point in time,
     where every change (create, update and delete) to a Resource produces an
     ResourceHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'resource',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        resource=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Resource.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Resource was deleted, the time it was deleted.
        '''
        self.resource = resource if resource is not None else None
        '''
         The complete Resource state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Resource state was recorded.
        '''

    def __repr__(self):
        return '<sdm.ResourceHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'resource': self.resource,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            resource=d.get('resource'),
            timestamp=d.get('timestamp'),
        )


class ResourceUpdateResponse:
    '''
         ResourceUpdateResponse returns the fields of a Resource after it has been updated by
     a ResourceUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'resource',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        resource=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.resource = resource if resource is not None else None
        '''
         The updated Resource.
        '''

    def __repr__(self):
        return '<sdm.ResourceUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'resource: ' + repr(self.resource) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'resource': self.resource,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            resource=d.get('resource'),
        )


class Role:
    '''
         A Role has a list of access rules which determine which Resources the members
     of the Role have access to. An Account can be a member of multiple Roles via
     AccountAttachments.
    '''
    __slots__ = [
        'access_rules',
        'id',
        'managed_by',
        'name',
        'tags',
    ]

    def __init__(
        self,
        access_rules=None,
        id=None,
        managed_by=None,
        name=None,
        tags=None,
    ):
        self.access_rules = access_rules if access_rules is not None else _porcelain_zero_value_access_rules(
        )
        '''
         AccessRules is a list of access rules defining the resources this Role has access to.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Role.
        '''
        self.managed_by = managed_by if managed_by is not None else ''
        '''
         Managed By is a read only field for what service manages this role, e.g. StrongDM, Okta, Azure.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Role.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Role ' + \
            'access_rules: ' + repr(self.access_rules) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'managed_by: ' + repr(self.managed_by) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'access_rules': self.access_rules,
            'id': self.id,
            'managed_by': self.managed_by,
            'name': self.name,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            access_rules=d.get('access_rules'),
            id=d.get('id'),
            managed_by=d.get('managed_by'),
            name=d.get('name'),
            tags=d.get('tags'),
        )


class RoleCreateResponse:
    '''
         RoleCreateResponse reports how the Roles were created in the system. It can
     communicate partial successes or failures.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The created Role.
        '''

    def __repr__(self):
        return '<sdm.RoleCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleDeleteResponse:
    '''
         RoleDeleteResponse returns information about a Role that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.RoleDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class RoleGetResponse:
    '''
         RoleGetResponse returns a requested Role.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The requested Role.
        '''

    def __repr__(self):
        return '<sdm.RoleGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class RoleHistory:
    '''
         RoleHistory records the state of a Role at a given point in time,
     where every change (create, update and delete) to a Role produces an
     RoleHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'role',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        role=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the Role.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this Role was deleted, the time it was deleted.
        '''
        self.role = role if role is not None else None
        '''
         The complete Role state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the Role state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RoleHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'role': self.role,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            role=d.get('role'),
            timestamp=d.get('timestamp'),
        )


class RoleResource:
    '''
         RoleResource represents an individual access grant of a Role to a Resource.
    '''
    __slots__ = [
        'granted_at',
        'resource_id',
        'role_id',
    ]

    def __init__(
        self,
        granted_at=None,
        resource_id=None,
        role_id=None,
    ):
        self.granted_at = granted_at if granted_at is not None else None
        '''
         The most recent time at which access was granted. If access was granted,
         revoked, and granted again, this will reflect the later time.
        '''
        self.resource_id = resource_id if resource_id is not None else ''
        '''
         The unique identifier of the Resource to which access is granted.
        '''
        self.role_id = role_id if role_id is not None else ''
        '''
         The unique identifier of the Role to which access is granted.
        '''

    def __repr__(self):
        return '<sdm.RoleResource ' + \
            'granted_at: ' + repr(self.granted_at) + ' ' +\
            'resource_id: ' + repr(self.resource_id) + ' ' +\
            'role_id: ' + repr(self.role_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'granted_at': self.granted_at,
            'resource_id': self.resource_id,
            'role_id': self.role_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            granted_at=d.get('granted_at'),
            resource_id=d.get('resource_id'),
            role_id=d.get('role_id'),
        )


class RoleResourceHistory:
    '''
         RoleResourceHistory records the state of a RoleResource at a given point in time,
     where every change (create or delete) to a RoleResource produces an
     RoleResourceHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'role_resource',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        role_resource=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the RoleResource.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this RoleResource was deleted, the time it was deleted.
        '''
        self.role_resource = role_resource if role_resource is not None else None
        '''
         The complete RoleResource state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the RoleResource state was recorded.
        '''

    def __repr__(self):
        return '<sdm.RoleResourceHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'role_resource: ' + repr(self.role_resource) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'role_resource': self.role_resource,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            role_resource=d.get('role_resource'),
            timestamp=d.get('timestamp'),
        )


class RoleUpdateResponse:
    '''
         RoleUpdateResponse returns the fields of a Role after it has been updated by
     a RoleUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'role',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        role=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.role = role if role is not None else None
        '''
         The updated Role.
        '''

    def __repr__(self):
        return '<sdm.RoleUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'role: ' + repr(self.role) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'role': self.role,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            role=d.get('role'),
        )


class SQLServer:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'password',
        'port',
        'port_override',
        'schema',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        password=None,
        port=None,
        port_override=None,
        schema=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.schema = schema if schema is not None else ''
        '''
         The Schema to use to direct initial requests.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SQLServer ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'schema': self.schema,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            schema=d.get('schema'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SQLServerAzureAD:
    __slots__ = [
        'bind_interface',
        'client_id',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'override_database',
        'port',
        'port_override',
        'schema',
        'secret',
        'secret_store_id',
        'subdomain',
        'tags',
        'tenant_id',
    ]

    def __init__(
        self,
        bind_interface=None,
        client_id=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        schema=None,
        secret=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        tenant_id=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.client_id = client_id if client_id is not None else ''
        '''
         The Azure AD application (client) ID with which to authenticate.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.schema = schema if schema is not None else ''
        '''
         The Schema to use to direct initial requests.
        '''
        self.secret = secret if secret is not None else ''
        '''
         The Azure AD client secret (application password) with which to authenticate.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.tenant_id = tenant_id if tenant_id is not None else ''
        '''
         The Azure AD directory (tenant) ID with which to authenticate.
        '''

    def __repr__(self):
        return '<sdm.SQLServerAzureAD ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'client_id: ' + repr(self.client_id) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret: ' + repr(self.secret) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'tenant_id: ' + repr(self.tenant_id) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'client_id': self.client_id,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'schema': self.schema,
            'secret': self.secret,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'tenant_id': self.tenant_id,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            client_id=d.get('client_id'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            schema=d.get('schema'),
            secret=d.get('secret'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            tenant_id=d.get('tenant_id'),
        )


class SQLServerKerberosAD:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'keytab',
        'krb_config',
        'name',
        'override_database',
        'port',
        'port_override',
        'realm',
        'schema',
        'secret_store_id',
        'server_spn',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        keytab=None,
        krb_config=None,
        name=None,
        override_database=None,
        port=None,
        port_override=None,
        realm=None,
        schema=None,
        secret_store_id=None,
        server_spn=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.keytab = keytab if keytab is not None else ''
        '''
         The keytab file in base64 format containing an entry with the principal name (username@realm) and key version number with which to authenticate.
        '''
        self.krb_config = krb_config if krb_config is not None else ''
        '''
         The Kerberos 5 configuration file (krb5.conf) specifying the Active Directory server (KDC) for the configured realm.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.override_database = override_database if override_database is not None else False
        '''
         If set, the database configured cannot be changed by users. This setting is not recommended for most use cases, as some clients will insist their database has changed when it has not, leading to user confusion.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.realm = realm if realm is not None else ''
        '''
         The Active Directory domain (realm) to which the configured username belongs.
        '''
        self.schema = schema if schema is not None else ''
        '''
         The Schema to use to direct initial requests.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.server_spn = server_spn if server_spn is not None else ''
        '''
         The Service Principal Name of the Microsoft SQL Server instance in Active Directory.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SQLServerKerberosAD ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'keytab: ' + repr(self.keytab) + ' ' +\
            'krb_config: ' + repr(self.krb_config) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'override_database: ' + repr(self.override_database) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'realm: ' + repr(self.realm) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'server_spn: ' + repr(self.server_spn) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'keytab': self.keytab,
            'krb_config': self.krb_config,
            'name': self.name,
            'override_database': self.override_database,
            'port': self.port,
            'port_override': self.port_override,
            'realm': self.realm,
            'schema': self.schema,
            'secret_store_id': self.secret_store_id,
            'server_spn': self.server_spn,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            keytab=d.get('keytab'),
            krb_config=d.get('krb_config'),
            name=d.get('name'),
            override_database=d.get('override_database'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            realm=d.get('realm'),
            schema=d.get('schema'),
            secret_store_id=d.get('secret_store_id'),
            server_spn=d.get('server_spn'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSH:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'key_type',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'public_key',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        key_type=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        public_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        '''
         Whether deprecated, insecure key exchanges are allowed for use to connect to the target ssh server.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.key_type = key_type if key_type is not None else ''
        '''
         The key type to use e.g. rsa-2048 or ed25519
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        '''
         Whether port forwarding is allowed through this server.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.public_key = public_key if public_key is not None else ''
        '''
         The public key to append to a server's authorized keys. This will be generated after resource creation.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SSH ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_type: ' + repr(self.key_type) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'public_key: ' + repr(self.public_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'key_type': self.key_type,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'public_key': self.public_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            key_type=d.get('key_type'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            public_key=d.get('public_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSHCert:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'key_type',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'remote_identity_group_id',
        'remote_identity_healthcheck_username',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        key_type=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        remote_identity_group_id=None,
        remote_identity_healthcheck_username=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        '''
         Whether deprecated, insecure key exchanges are allowed for use to connect to the target ssh server.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.key_type = key_type if key_type is not None else ''
        '''
         The key type to use e.g. rsa-2048 or ed25519
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        '''
         Whether port forwarding is allowed through this server.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.remote_identity_group_id = remote_identity_group_id if remote_identity_group_id is not None else ''
        '''
         The ID of the remote identity group to use for remote identity connections.
        '''
        self.remote_identity_healthcheck_username = remote_identity_healthcheck_username if remote_identity_healthcheck_username is not None else ''
        '''
         The username to use for healthchecks, when clients otherwise connect with their own remote identity username.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SSHCert ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'key_type: ' + repr(self.key_type) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'remote_identity_group_id: ' + repr(self.remote_identity_group_id) + ' ' +\
            'remote_identity_healthcheck_username: ' + repr(self.remote_identity_healthcheck_username) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'key_type': self.key_type,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'remote_identity_group_id': self.remote_identity_group_id,
            'remote_identity_healthcheck_username':
            self.remote_identity_healthcheck_username,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            key_type=d.get('key_type'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            remote_identity_group_id=d.get('remote_identity_group_id'),
            remote_identity_healthcheck_username=d.get(
                'remote_identity_healthcheck_username'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SSHCustomerKey:
    __slots__ = [
        'allow_deprecated_key_exchanges',
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'port',
        'port_forwarding',
        'port_override',
        'private_key',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        allow_deprecated_key_exchanges=None,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        port=None,
        port_forwarding=None,
        port_override=None,
        private_key=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.allow_deprecated_key_exchanges = allow_deprecated_key_exchanges if allow_deprecated_key_exchanges is not None else False
        '''
         Whether deprecated, insecure key exchanges are allowed for use to connect to the target ssh server.
        '''
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_forwarding = port_forwarding if port_forwarding is not None else False
        '''
         Whether port forwarding is allowed through this server.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.private_key = private_key if private_key is not None else ''
        '''
         The private key used to authenticate with the server.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SSHCustomerKey ' + \
            'allow_deprecated_key_exchanges: ' + repr(self.allow_deprecated_key_exchanges) + ' ' +\
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_forwarding: ' + repr(self.port_forwarding) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'private_key: ' + repr(self.private_key) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'allow_deprecated_key_exchanges':
            self.allow_deprecated_key_exchanges,
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'port': self.port,
            'port_forwarding': self.port_forwarding,
            'port_override': self.port_override,
            'private_key': self.private_key,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            allow_deprecated_key_exchanges=d.get(
                'allow_deprecated_key_exchanges'),
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            port=d.get('port'),
            port_forwarding=d.get('port_forwarding'),
            port_override=d.get('port_override'),
            private_key=d.get('private_key'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SecretStoreCreateResponse:
    '''
         SecretStoreCreateResponse reports how the SecretStores were created in the system.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The created SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreCreateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class SecretStoreDeleteResponse:
    '''
         SecretStoreDeleteResponse returns information about a SecretStore that was deleted.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreDeleteResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
        )


class SecretStoreGetResponse:
    '''
         SecretStoreGetResponse returns a requested SecretStore.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The requested SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreGetResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class SecretStoreHistory:
    '''
         SecretStoreHistory records the state of a SecretStore at a given point in time,
     where every change (create, update and delete) to a SecretStore produces an
     SecretStoreHistory record.
    '''
    __slots__ = [
        'activity_id',
        'deleted_at',
        'secret_store',
        'timestamp',
    ]

    def __init__(
        self,
        activity_id=None,
        deleted_at=None,
        secret_store=None,
        timestamp=None,
    ):
        self.activity_id = activity_id if activity_id is not None else ''
        '''
         The unique identifier of the Activity that produced this change to the SecretStore.
         May be empty for some system-initiated updates.
        '''
        self.deleted_at = deleted_at if deleted_at is not None else None
        '''
         If this SecretStore was deleted, the time it was deleted.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The complete SecretStore state at this time.
        '''
        self.timestamp = timestamp if timestamp is not None else None
        '''
         The time at which the SecretStore state was recorded.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreHistory ' + \
            'activity_id: ' + repr(self.activity_id) + ' ' +\
            'deleted_at: ' + repr(self.deleted_at) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            'timestamp: ' + repr(self.timestamp) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'activity_id': self.activity_id,
            'deleted_at': self.deleted_at,
            'secret_store': self.secret_store,
            'timestamp': self.timestamp,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            activity_id=d.get('activity_id'),
            deleted_at=d.get('deleted_at'),
            secret_store=d.get('secret_store'),
            timestamp=d.get('timestamp'),
        )


class SecretStoreUpdateResponse:
    '''
         SecretStoreUpdateResponse returns the fields of a SecretStore after it has been updated by
     a SecretStoreUpdateRequest.
    '''
    __slots__ = [
        'meta',
        'rate_limit',
        'secret_store',
    ]

    def __init__(
        self,
        meta=None,
        rate_limit=None,
        secret_store=None,
    ):
        self.meta = meta if meta is not None else None
        '''
         Reserved for future use.
        '''
        self.rate_limit = rate_limit if rate_limit is not None else None
        '''
         Rate limit information.
        '''
        self.secret_store = secret_store if secret_store is not None else None
        '''
         The updated SecretStore.
        '''

    def __repr__(self):
        return '<sdm.SecretStoreUpdateResponse ' + \
            'meta: ' + repr(self.meta) + ' ' +\
            'rate_limit: ' + repr(self.rate_limit) + ' ' +\
            'secret_store: ' + repr(self.secret_store) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'meta': self.meta,
            'rate_limit': self.rate_limit,
            'secret_store': self.secret_store,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            meta=d.get('meta'),
            rate_limit=d.get('rate_limit'),
            secret_store=d.get('secret_store'),
        )


class Service:
    '''
         A Service is a service account that can connect to resources they are granted
     directly, or granted via roles. Services are typically automated jobs.
    '''
    __slots__ = [
        'id',
        'name',
        'suspended',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        suspended=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Service.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Service.
        '''
        self.suspended = suspended if suspended is not None else False
        '''
         The Service's suspended state.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Service ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'suspended: ' + repr(self.suspended) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'suspended': self.suspended,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            suspended=d.get('suspended'),
            tags=d.get('tags'),
        )


class SingleStore:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'require_native_auth',
        'secret_store_id',
        'subdomain',
        'tags',
        'use_azure_single_server_usernames',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        require_native_auth=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        use_azure_single_server_usernames=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.require_native_auth = require_native_auth if require_native_auth is not None else False
        '''
         Whether native auth (mysql_native_password) is used for all connections (for backwards compatibility)
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.use_azure_single_server_usernames = use_azure_single_server_usernames if use_azure_single_server_usernames is not None else False
        '''
         If true, appends the hostname to the username when hitting a database.azure.com address
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SingleStore ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'require_native_auth: ' + repr(self.require_native_auth) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'use_azure_single_server_usernames: ' + repr(self.use_azure_single_server_usernames) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'require_native_auth': self.require_native_auth,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'use_azure_single_server_usernames':
            self.use_azure_single_server_usernames,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            require_native_auth=d.get('require_native_auth'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            use_azure_single_server_usernames=d.get(
                'use_azure_single_server_usernames'),
            username=d.get('username'),
        )


class Snowflake:
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port_override',
        'schema',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port_override=None,
        schema=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.schema = schema if schema is not None else ''
        '''
         The schema to provide on authentication.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Snowflake ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'schema: ' + repr(self.schema) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port_override': self.port_override,
            'schema': self.schema,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port_override=d.get('port_override'),
            schema=d.get('schema'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Snowsight:
    '''
    Snowsight is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthcheck_username',
        'healthy',
        'id',
        'name',
        'port_override',
        'samlmetadata',
        'secret_store_id',
        'subdomain',
        'tags',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthcheck_username=None,
        healthy=None,
        id=None,
        name=None,
        port_override=None,
        samlmetadata=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthcheck_username = healthcheck_username if healthcheck_username is not None else ''
        '''
         The StrongDM user email to use for healthchecks.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.samlmetadata = samlmetadata if samlmetadata is not None else ''
        '''
         The Metadata for your snowflake IDP integration
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.Snowsight ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthcheck_username: ' + repr(self.healthcheck_username) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'samlmetadata: ' + repr(self.samlmetadata) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthcheck_username': self.healthcheck_username,
            'healthy': self.healthy,
            'id': self.id,
            'name': self.name,
            'port_override': self.port_override,
            'samlmetadata': self.samlmetadata,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthcheck_username=d.get('healthcheck_username'),
            healthy=d.get('healthy'),
            id=d.get('id'),
            name=d.get('name'),
            port_override=d.get('port_override'),
            samlmetadata=d.get('samlmetadata'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
        )


class Sybase:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Sybase ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class SybaseIQ:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.SybaseIQ ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Tag:
    __slots__ = [
        'name',
        'value',
    ]

    def __init__(
        self,
        name=None,
        value=None,
    ):
        self.name = name if name is not None else ''
        '''
         The name or key of this tag. Each name can only refer to one value on a tagged entity.
        '''
        self.value = value if value is not None else ''
        '''
         The value of this tag.
        '''

    def __repr__(self):
        return '<sdm.Tag ' + \
            'name: ' + repr(self.name) + ' ' +\
            'value: ' + repr(self.value) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'name': self.name,
            'value': self.value,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            name=d.get('name'),
            value=d.get('value'),
        )


class Teradata:
    __slots__ = [
        'bind_interface',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Teradata ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class Trino:
    '''
    Trino is currently unstable, and its API may change, or it may be removed,
    without a major version bump.
    '''
    __slots__ = [
        'bind_interface',
        'database',
        'egress_filter',
        'healthy',
        'hostname',
        'id',
        'name',
        'password',
        'port',
        'port_override',
        'secret_store_id',
        'subdomain',
        'tags',
        'username',
    ]

    def __init__(
        self,
        bind_interface=None,
        database=None,
        egress_filter=None,
        healthy=None,
        hostname=None,
        id=None,
        name=None,
        password=None,
        port=None,
        port_override=None,
        secret_store_id=None,
        subdomain=None,
        tags=None,
        username=None,
    ):
        self.bind_interface = bind_interface if bind_interface is not None else ''
        '''
         The bind interface is the IP address to which the port override of a resource is bound (for example, 127.0.0.1). It is automatically generated if not provided.
        '''
        self.database = database if database is not None else ''
        '''
         The initial database to connect to. This setting does not by itself prevent switching to another database after connecting.
        '''
        self.egress_filter = egress_filter if egress_filter is not None else ''
        '''
         A filter applied to the routing logic to pin datasource to nodes.
        '''
        self.healthy = healthy if healthy is not None else False
        '''
         True if the datasource is reachable and the credentials are valid.
        '''
        self.hostname = hostname if hostname is not None else ''
        '''
         The host to dial to initiate a connection from the egress node to this resource.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the Resource.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the Resource.
        '''
        self.password = password if password is not None else ''
        '''
         The password to authenticate with.
        '''
        self.port = port if port is not None else 0
        '''
         The port to dial to initiate a connection from the egress node to this resource.
        '''
        self.port_override = port_override if port_override is not None else 0
        '''
         The local port used by clients to connect to this resource.
        '''
        self.secret_store_id = secret_store_id if secret_store_id is not None else ''
        '''
         ID of the secret store containing credentials for this resource, if any.
        '''
        self.subdomain = subdomain if subdomain is not None else ''
        '''
         Subdomain is the local DNS address.  (e.g. app-prod1 turns into app-prod1.your-org-name.sdm.network)
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''
        self.username = username if username is not None else ''
        '''
         The username to authenticate with.
        '''

    def __repr__(self):
        return '<sdm.Trino ' + \
            'bind_interface: ' + repr(self.bind_interface) + ' ' +\
            'database: ' + repr(self.database) + ' ' +\
            'egress_filter: ' + repr(self.egress_filter) + ' ' +\
            'healthy: ' + repr(self.healthy) + ' ' +\
            'hostname: ' + repr(self.hostname) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'password: ' + repr(self.password) + ' ' +\
            'port: ' + repr(self.port) + ' ' +\
            'port_override: ' + repr(self.port_override) + ' ' +\
            'secret_store_id: ' + repr(self.secret_store_id) + ' ' +\
            'subdomain: ' + repr(self.subdomain) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            'username: ' + repr(self.username) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'bind_interface': self.bind_interface,
            'database': self.database,
            'egress_filter': self.egress_filter,
            'healthy': self.healthy,
            'hostname': self.hostname,
            'id': self.id,
            'name': self.name,
            'password': self.password,
            'port': self.port,
            'port_override': self.port_override,
            'secret_store_id': self.secret_store_id,
            'subdomain': self.subdomain,
            'tags': self.tags,
            'username': self.username,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            bind_interface=d.get('bind_interface'),
            database=d.get('database'),
            egress_filter=d.get('egress_filter'),
            healthy=d.get('healthy'),
            hostname=d.get('hostname'),
            id=d.get('id'),
            name=d.get('name'),
            password=d.get('password'),
            port=d.get('port'),
            port_override=d.get('port_override'),
            secret_store_id=d.get('secret_store_id'),
            subdomain=d.get('subdomain'),
            tags=d.get('tags'),
            username=d.get('username'),
        )


class UpdateResponseMetadata:
    '''
         UpdateResponseMetadata is reserved for future use.
    '''
    __slots__ = []

    def __init__(self, ):
        pass

    def __repr__(self):
        return '<sdm.UpdateResponseMetadata ' + \
            '>'

    def to_dict(self):
        return {}

    @classmethod
    def from_dict(cls, d):
        return cls()


class User:
    '''
         A User can connect to resources they are granted directly, or granted
     via roles.
    '''
    __slots__ = [
        'email',
        'external_id',
        'first_name',
        'id',
        'last_name',
        'managed_by',
        'permission_level',
        'suspended',
        'tags',
    ]

    def __init__(
        self,
        email=None,
        external_id=None,
        first_name=None,
        id=None,
        last_name=None,
        managed_by=None,
        permission_level=None,
        suspended=None,
        tags=None,
    ):
        self.email = email if email is not None else ''
        '''
         The User's email address. Must be unique.
        '''
        self.external_id = external_id if external_id is not None else ''
        '''
         External ID is an alternative unique ID this user is represented by within an external service.
        '''
        self.first_name = first_name if first_name is not None else ''
        '''
         The User's first name.
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the User.
        '''
        self.last_name = last_name if last_name is not None else ''
        '''
         The User's last name.
        '''
        self.managed_by = managed_by if managed_by is not None else ''
        '''
         Managed By is a read only field for what service manages this user, e.g. StrongDM, Okta, Azure.
        '''
        self.permission_level = permission_level if permission_level is not None else ''
        '''
         PermissionLevel is a read only field for the user's permission level e.g. admin, DBA, user.
        '''
        self.suspended = suspended if suspended is not None else False
        '''
         The User's suspended state.
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.User ' + \
            'email: ' + repr(self.email) + ' ' +\
            'external_id: ' + repr(self.external_id) + ' ' +\
            'first_name: ' + repr(self.first_name) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'last_name: ' + repr(self.last_name) + ' ' +\
            'managed_by: ' + repr(self.managed_by) + ' ' +\
            'permission_level: ' + repr(self.permission_level) + ' ' +\
            'suspended: ' + repr(self.suspended) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'email': self.email,
            'external_id': self.external_id,
            'first_name': self.first_name,
            'id': self.id,
            'last_name': self.last_name,
            'managed_by': self.managed_by,
            'permission_level': self.permission_level,
            'suspended': self.suspended,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            email=d.get('email'),
            external_id=d.get('external_id'),
            first_name=d.get('first_name'),
            id=d.get('id'),
            last_name=d.get('last_name'),
            managed_by=d.get('managed_by'),
            permission_level=d.get('permission_level'),
            suspended=d.get('suspended'),
            tags=d.get('tags'),
        )


class VaultAppRoleStore:
    __slots__ = [
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        '''
         The namespace to make requests within
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         The URL of the Vault to target
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultAppRoleStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class VaultTLSStore:
    __slots__ = [
        'ca_cert_path',
        'client_cert_path',
        'client_key_path',
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        ca_cert_path=None,
        client_cert_path=None,
        client_key_path=None,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.ca_cert_path = ca_cert_path if ca_cert_path is not None else ''
        '''
         A path to a CA file accessible by a Node
        '''
        self.client_cert_path = client_cert_path if client_cert_path is not None else ''
        '''
         A path to a client certificate file accessible by a Node
        '''
        self.client_key_path = client_key_path if client_key_path is not None else ''
        '''
         A path to a client key file accessible by a Node
        '''
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        '''
         The namespace to make requests within
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         The URL of the Vault to target
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultTLSStore ' + \
            'ca_cert_path: ' + repr(self.ca_cert_path) + ' ' +\
            'client_cert_path: ' + repr(self.client_cert_path) + ' ' +\
            'client_key_path: ' + repr(self.client_key_path) + ' ' +\
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'ca_cert_path': self.ca_cert_path,
            'client_cert_path': self.client_cert_path,
            'client_key_path': self.client_key_path,
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            ca_cert_path=d.get('ca_cert_path'),
            client_cert_path=d.get('client_cert_path'),
            client_key_path=d.get('client_key_path'),
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


class VaultTokenStore:
    __slots__ = [
        'id',
        'name',
        'namespace',
        'server_address',
        'tags',
    ]

    def __init__(
        self,
        id=None,
        name=None,
        namespace=None,
        server_address=None,
        tags=None,
    ):
        self.id = id if id is not None else ''
        '''
         Unique identifier of the SecretStore.
        '''
        self.name = name if name is not None else ''
        '''
         Unique human-readable name of the SecretStore.
        '''
        self.namespace = namespace if namespace is not None else ''
        '''
         The namespace to make requests within
        '''
        self.server_address = server_address if server_address is not None else ''
        '''
         The URL of the Vault to target
        '''
        self.tags = tags if tags is not None else _porcelain_zero_value_tags()
        '''
         Tags is a map of key, value pairs.
        '''

    def __repr__(self):
        return '<sdm.VaultTokenStore ' + \
            'id: ' + repr(self.id) + ' ' +\
            'name: ' + repr(self.name) + ' ' +\
            'namespace: ' + repr(self.namespace) + ' ' +\
            'server_address: ' + repr(self.server_address) + ' ' +\
            'tags: ' + repr(self.tags) + ' ' +\
            '>'

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'namespace': self.namespace,
            'server_address': self.server_address,
            'tags': self.tags,
        }

    @classmethod
    def from_dict(cls, d):
        return cls(
            id=d.get('id'),
            name=d.get('name'),
            namespace=d.get('namespace'),
            server_address=d.get('server_address'),
            tags=d.get('tags'),
        )


def _porcelain_zero_value_tags():
    return {}


def _porcelain_zero_value_access_rules():
    return []
