#
# This class is automatically generated by mig. DO NOT EDIT THIS FILE.
# This class implements a Python interface to the 'AcReport'
# message type.
#

import tinyos.message.Message

# The default size of this message type in bytes.
DEFAULT_MESSAGE_SIZE = 61

# The Active Message type associated with this message.
AM_TYPE = -1

class AcReport(tinyos.message.Message.Message):
    # Create a new AcReport of size 61.
    def __init__(self, data="", addr=None, gid=None, base_offset=0, data_length=61):
        tinyos.message.Message.Message.__init__(self, data, addr, gid, base_offset, data_length)
        self.amTypeSet(AM_TYPE)
    
    # Get AM_TYPE
    def get_amType(cls):
        return AM_TYPE
    
    get_amType = classmethod(get_amType)
    
    #
    # Return a String representation of this message. Includes the
    # message type name and the non-indexed field values.
    #
    def __str__(self):
        s = "Message <AcReport> \n"
        try:
            s += "  [eui64=";
            for i in range(0, 8):
                s += "0x%x " % (self.getElement_eui64(i) & 0xff)
            s += "]\n";
        except:
            pass
        try:
            s += "  [route.hop_limit=0x%x]\n" % (self.get_route_hop_limit())
        except:
            pass
        try:
            s += "  [route.parent=0x%x]\n" % (self.get_route_parent())
        except:
            pass
        try:
            s += "  [route.parent_metric=0x%x]\n" % (self.get_route_parent_metric())
        except:
            pass
        try:
            s += "  [route.parent_etx=0x%x]\n" % (self.get_route_parent_etx())
        except:
            pass
        try:
            s += "  [seq=0x%x]\n" % (self.get_seq())
        except:
            pass
        try:
            s += "  [localTime=0x%x]\n" % (self.get_localTime())
        except:
            pass
        try:
            s += "  [globalTime=0x%x]\n" % (self.get_globalTime())
        except:
            pass
        try:
            s += "  [period=0x%x]\n" % (self.get_period())
        except:
            pass
        try:
            s += "  [readings.cumulativeRealEnergy=";
            for i in range(0, 2):
                s += "0x%x " % (self.getElement_readings_cumulativeRealEnergy(i))
            s += "]\n";
        except:
            pass
        try:
            s += "  [readings.averageRealPower=";
            for i in range(0, 2):
                s += "0x%x " % (self.getElement_readings_averageRealPower(i) & 0xff)
            s += "]\n";
        except:
            pass
        try:
            s += "  [readings.averageApparentPower=";
            for i in range(0, 2):
                s += "0x%x " % (self.getElement_readings_averageApparentPower(i) & 0xff)
            s += "]\n";
        except:
            pass
        return s

    # Message-type-specific access methods appear below.

    #
    # Accessor methods for field: eui64
    #   Field type: short[]
    #   Offset (bits): 0
    #   Size of each element (bits): 8
    #

    #
    # Return whether the field 'eui64' is signed (False).
    #
    def isSigned_eui64(self):
        return False
    
    #
    # Return whether the field 'eui64' is an array (True).
    #
    def isArray_eui64(self):
        return True
    
    #
    # Return the offset (in bytes) of the field 'eui64'
    #
    def offset_eui64(self, index1):
        offset = 0
        if index1 < 0 or index1 >= 8:
            raise IndexError
        offset += 0 + index1 * 8
        return (offset / 8)
    
    #
    # Return the offset (in bits) of the field 'eui64'
    #
    def offsetBits_eui64(self, index1):
        offset = 0
        if index1 < 0 or index1 >= 8:
            raise IndexError
        offset += 0 + index1 * 8
        return offset
    
    #
    # Return the entire array 'eui64' as a short[]
    #
    def get_eui64(self):
        tmp = [None]*8
        for index0 in range (0, self.numElements_eui64(0)):
                tmp[index0] = self.getElement_eui64(index0)
        return tmp
    
    #
    # Set the contents of the array 'eui64' from the given short[]
    #
    def set_eui64(self, value):
        for index0 in range(0, len(value)):
            self.setElement_eui64(index0, value[index0])

    #
    # Return an element (as a short) of the array 'eui64'
    #
    def getElement_eui64(self, index1):
        return self.getUIntElement(self.offsetBits_eui64(index1), 8, 1)
    
    #
    # Set an element of the array 'eui64'
    #
    def setElement_eui64(self, index1, value):
        self.setUIntElement(self.offsetBits_eui64(index1), 8, value, 1)
    
    #
    # Return the total size, in bytes, of the array 'eui64'
    #
    def totalSize_eui64(self):
        return (64 / 8)
    
    #
    # Return the total size, in bits, of the array 'eui64'
    #
    def totalSizeBits_eui64(self):
        return 64
    
    #
    # Return the size, in bytes, of each element of the array 'eui64'
    #
    def elementSize_eui64(self):
        return (8 / 8)
    
    #
    # Return the size, in bits, of each element of the array 'eui64'
    #
    def elementSizeBits_eui64(self):
        return 8
    
    #
    # Return the number of dimensions in the array 'eui64'
    #
    def numDimensions_eui64(self):
        return 1
    
    #
    # Return the number of elements in the array 'eui64'
    #
    def numElements_eui64():
        return 8
    
    #
    # Return the number of elements in the array 'eui64'
    # for the given dimension.
    #
    def numElements_eui64(self, dimension):
        array_dims = [ 8,  ]
        if dimension < 0 or dimension >= 1:
            raise IndexException
        if array_dims[dimension] == 0:
            raise IndexError
        return array_dims[dimension]
    
    #
    # Fill in the array 'eui64' with a String
    #
    def setString_eui64(self, s):
         l = len(s)
         for i in range(0, l):
             self.setElement_eui64(i, ord(s[i]));
         self.setElement_eui64(l, 0) #null terminate
    
    #
    # Read the array 'eui64' as a String
    #
    def getString_eui64(self):
        carr = "";
        for i in range(0, 4000):
            if self.getElement_eui64(i) == chr(0):
                break
            carr += self.getElement_eui64(i)
        return carr
    
    #
    # Accessor methods for field: route.hop_limit
    #   Field type: short
    #   Offset (bits): 64
    #   Size (bits): 8
    #

    #
    # Return whether the field 'route.hop_limit' is signed (False).
    #
    def isSigned_route_hop_limit(self):
        return False
    
    #
    # Return whether the field 'route.hop_limit' is an array (False).
    #
    def isArray_route_hop_limit(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'route.hop_limit'
    #
    def offset_route_hop_limit(self):
        return (64 / 8)
    
    #
    # Return the offset (in bits) of the field 'route.hop_limit'
    #
    def offsetBits_route_hop_limit(self):
        return 64
    
    #
    # Return the value (as a short) of the field 'route.hop_limit'
    #
    def get_route_hop_limit(self):
        return self.getUIntElement(self.offsetBits_route_hop_limit(), 8, 1)
    
    #
    # Set the value of the field 'route.hop_limit'
    #
    def set_route_hop_limit(self, value):
        self.setUIntElement(self.offsetBits_route_hop_limit(), 8, value, 1)
    
    #
    # Return the size, in bytes, of the field 'route.hop_limit'
    #
    def size_route_hop_limit(self):
        return (8 / 8)
    
    #
    # Return the size, in bits, of the field 'route.hop_limit'
    #
    def sizeBits_route_hop_limit(self):
        return 8
    
    #
    # Accessor methods for field: route.parent
    #   Field type: int
    #   Offset (bits): 72
    #   Size (bits): 16
    #

    #
    # Return whether the field 'route.parent' is signed (False).
    #
    def isSigned_route_parent(self):
        return False
    
    #
    # Return whether the field 'route.parent' is an array (False).
    #
    def isArray_route_parent(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'route.parent'
    #
    def offset_route_parent(self):
        return (72 / 8)
    
    #
    # Return the offset (in bits) of the field 'route.parent'
    #
    def offsetBits_route_parent(self):
        return 72
    
    #
    # Return the value (as a int) of the field 'route.parent'
    #
    def get_route_parent(self):
        return self.getUIntElement(self.offsetBits_route_parent(), 16, 1)
    
    #
    # Set the value of the field 'route.parent'
    #
    def set_route_parent(self, value):
        self.setUIntElement(self.offsetBits_route_parent(), 16, value, 1)
    
    #
    # Return the size, in bytes, of the field 'route.parent'
    #
    def size_route_parent(self):
        return (16 / 8)
    
    #
    # Return the size, in bits, of the field 'route.parent'
    #
    def sizeBits_route_parent(self):
        return 16
    
    #
    # Accessor methods for field: route.parent_metric
    #   Field type: int
    #   Offset (bits): 88
    #   Size (bits): 16
    #

    #
    # Return whether the field 'route.parent_metric' is signed (False).
    #
    def isSigned_route_parent_metric(self):
        return False
    
    #
    # Return whether the field 'route.parent_metric' is an array (False).
    #
    def isArray_route_parent_metric(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'route.parent_metric'
    #
    def offset_route_parent_metric(self):
        return (88 / 8)
    
    #
    # Return the offset (in bits) of the field 'route.parent_metric'
    #
    def offsetBits_route_parent_metric(self):
        return 88
    
    #
    # Return the value (as a int) of the field 'route.parent_metric'
    #
    def get_route_parent_metric(self):
        return self.getUIntElement(self.offsetBits_route_parent_metric(), 16, 1)
    
    #
    # Set the value of the field 'route.parent_metric'
    #
    def set_route_parent_metric(self, value):
        self.setUIntElement(self.offsetBits_route_parent_metric(), 16, value, 1)
    
    #
    # Return the size, in bytes, of the field 'route.parent_metric'
    #
    def size_route_parent_metric(self):
        return (16 / 8)
    
    #
    # Return the size, in bits, of the field 'route.parent_metric'
    #
    def sizeBits_route_parent_metric(self):
        return 16
    
    #
    # Accessor methods for field: route.parent_etx
    #   Field type: int
    #   Offset (bits): 104
    #   Size (bits): 16
    #

    #
    # Return whether the field 'route.parent_etx' is signed (False).
    #
    def isSigned_route_parent_etx(self):
        return False
    
    #
    # Return whether the field 'route.parent_etx' is an array (False).
    #
    def isArray_route_parent_etx(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'route.parent_etx'
    #
    def offset_route_parent_etx(self):
        return (104 / 8)
    
    #
    # Return the offset (in bits) of the field 'route.parent_etx'
    #
    def offsetBits_route_parent_etx(self):
        return 104
    
    #
    # Return the value (as a int) of the field 'route.parent_etx'
    #
    def get_route_parent_etx(self):
        return self.getUIntElement(self.offsetBits_route_parent_etx(), 16, 1)
    
    #
    # Set the value of the field 'route.parent_etx'
    #
    def set_route_parent_etx(self, value):
        self.setUIntElement(self.offsetBits_route_parent_etx(), 16, value, 1)
    
    #
    # Return the size, in bytes, of the field 'route.parent_etx'
    #
    def size_route_parent_etx(self):
        return (16 / 8)
    
    #
    # Return the size, in bits, of the field 'route.parent_etx'
    #
    def sizeBits_route_parent_etx(self):
        return 16
    
    #
    # Accessor methods for field: seq
    #   Field type: long
    #   Offset (bits): 120
    #   Size (bits): 32
    #

    #
    # Return whether the field 'seq' is signed (False).
    #
    def isSigned_seq(self):
        return False
    
    #
    # Return whether the field 'seq' is an array (False).
    #
    def isArray_seq(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'seq'
    #
    def offset_seq(self):
        return (120 / 8)
    
    #
    # Return the offset (in bits) of the field 'seq'
    #
    def offsetBits_seq(self):
        return 120
    
    #
    # Return the value (as a long) of the field 'seq'
    #
    def get_seq(self):
        return self.getUIntElement(self.offsetBits_seq(), 32, 1)
    
    #
    # Set the value of the field 'seq'
    #
    def set_seq(self, value):
        self.setUIntElement(self.offsetBits_seq(), 32, value, 1)
    
    #
    # Return the size, in bytes, of the field 'seq'
    #
    def size_seq(self):
        return (32 / 8)
    
    #
    # Return the size, in bits, of the field 'seq'
    #
    def sizeBits_seq(self):
        return 32
    
    #
    # Accessor methods for field: localTime
    #   Field type: long
    #   Offset (bits): 152
    #   Size (bits): 32
    #

    #
    # Return whether the field 'localTime' is signed (False).
    #
    def isSigned_localTime(self):
        return False
    
    #
    # Return whether the field 'localTime' is an array (False).
    #
    def isArray_localTime(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'localTime'
    #
    def offset_localTime(self):
        return (152 / 8)
    
    #
    # Return the offset (in bits) of the field 'localTime'
    #
    def offsetBits_localTime(self):
        return 152
    
    #
    # Return the value (as a long) of the field 'localTime'
    #
    def get_localTime(self):
        return self.getUIntElement(self.offsetBits_localTime(), 32, 1)
    
    #
    # Set the value of the field 'localTime'
    #
    def set_localTime(self, value):
        self.setUIntElement(self.offsetBits_localTime(), 32, value, 1)
    
    #
    # Return the size, in bytes, of the field 'localTime'
    #
    def size_localTime(self):
        return (32 / 8)
    
    #
    # Return the size, in bits, of the field 'localTime'
    #
    def sizeBits_localTime(self):
        return 32
    
    #
    # Accessor methods for field: globalTime
    #   Field type: long
    #   Offset (bits): 184
    #   Size (bits): 32
    #

    #
    # Return whether the field 'globalTime' is signed (False).
    #
    def isSigned_globalTime(self):
        return False
    
    #
    # Return whether the field 'globalTime' is an array (False).
    #
    def isArray_globalTime(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'globalTime'
    #
    def offset_globalTime(self):
        return (184 / 8)
    
    #
    # Return the offset (in bits) of the field 'globalTime'
    #
    def offsetBits_globalTime(self):
        return 184
    
    #
    # Return the value (as a long) of the field 'globalTime'
    #
    def get_globalTime(self):
        return self.getUIntElement(self.offsetBits_globalTime(), 32, 1)
    
    #
    # Set the value of the field 'globalTime'
    #
    def set_globalTime(self, value):
        self.setUIntElement(self.offsetBits_globalTime(), 32, value, 1)
    
    #
    # Return the size, in bytes, of the field 'globalTime'
    #
    def size_globalTime(self):
        return (32 / 8)
    
    #
    # Return the size, in bits, of the field 'globalTime'
    #
    def sizeBits_globalTime(self):
        return 32
    
    #
    # Accessor methods for field: period
    #   Field type: int
    #   Offset (bits): 216
    #   Size (bits): 16
    #

    #
    # Return whether the field 'period' is signed (False).
    #
    def isSigned_period(self):
        return False
    
    #
    # Return whether the field 'period' is an array (False).
    #
    def isArray_period(self):
        return False
    
    #
    # Return the offset (in bytes) of the field 'period'
    #
    def offset_period(self):
        return (216 / 8)
    
    #
    # Return the offset (in bits) of the field 'period'
    #
    def offsetBits_period(self):
        return 216
    
    #
    # Return the value (as a int) of the field 'period'
    #
    def get_period(self):
        return self.getUIntElement(self.offsetBits_period(), 16, 1)
    
    #
    # Set the value of the field 'period'
    #
    def set_period(self, value):
        self.setUIntElement(self.offsetBits_period(), 16, value, 1)
    
    #
    # Return the size, in bytes, of the field 'period'
    #
    def size_period(self):
        return (16 / 8)
    
    #
    # Return the size, in bits, of the field 'period'
    #
    def sizeBits_period(self):
        return 16
    
    #
    # Accessor methods for field: readings.cumulativeRealEnergy
    #   Field type: long[]
    #   Offset (bits): 0
    #   Size of each element (bits): 64
    #

    #
    # Return whether the field 'readings.cumulativeRealEnergy' is signed (False).
    #
    def isSigned_readings_cumulativeRealEnergy(self):
        return False
    
    #
    # Return whether the field 'readings.cumulativeRealEnergy' is an array (True).
    #
    def isArray_readings_cumulativeRealEnergy(self):
        return True
    
    #
    # Return the offset (in bytes) of the field 'readings.cumulativeRealEnergy'
    #
    def offset_readings_cumulativeRealEnergy(self, index1):
        offset = 0
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return (offset / 8)
    
    #
    # Return the offset (in bits) of the field 'readings.cumulativeRealEnergy'
    #
    def offsetBits_readings_cumulativeRealEnergy(self, index1):
        offset = 0
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return offset
    
    #
    # Return the entire array 'readings.cumulativeRealEnergy' as a long[]
    #
    def get_readings_cumulativeRealEnergy(self):
        tmp = [None]*2
        for index0 in range (0, self.numElements_readings_cumulativeRealEnergy(0)):
                tmp[index0] = self.getElement_readings_cumulativeRealEnergy(index0)
        return tmp
    
    #
    # Set the contents of the array 'readings.cumulativeRealEnergy' from the given long[]
    #
    def set_readings_cumulativeRealEnergy(self, value):
        for index0 in range(0, len(value)):
            self.setElement_readings_cumulativeRealEnergy(index0, value[index0])

    #
    # Return an element (as a long) of the array 'readings.cumulativeRealEnergy'
    #
    def getElement_readings_cumulativeRealEnergy(self, index1):
        return self.getUIntElement(self.offsetBits_readings_cumulativeRealEnergy(index1), 64, 1)
    
    #
    # Set an element of the array 'readings.cumulativeRealEnergy'
    #
    def setElement_readings_cumulativeRealEnergy(self, index1, value):
        self.setUIntElement(self.offsetBits_readings_cumulativeRealEnergy(index1), 64, value, 1)
    
    #
    # Return the total size, in bytes, of the array 'readings.cumulativeRealEnergy'
    #
    def totalSize_readings_cumulativeRealEnergy(self):
        return (256 / 8)
    
    #
    # Return the total size, in bits, of the array 'readings.cumulativeRealEnergy'
    #
    def totalSizeBits_readings_cumulativeRealEnergy(self):
        return 256
    
    #
    # Return the size, in bytes, of each element of the array 'readings.cumulativeRealEnergy'
    #
    def elementSize_readings_cumulativeRealEnergy(self):
        return (64 / 8)
    
    #
    # Return the size, in bits, of each element of the array 'readings.cumulativeRealEnergy'
    #
    def elementSizeBits_readings_cumulativeRealEnergy(self):
        return 64
    
    #
    # Return the number of dimensions in the array 'readings.cumulativeRealEnergy'
    #
    def numDimensions_readings_cumulativeRealEnergy(self):
        return 1
    
    #
    # Return the number of elements in the array 'readings.cumulativeRealEnergy'
    #
    def numElements_readings_cumulativeRealEnergy():
        return 2
    
    #
    # Return the number of elements in the array 'readings.cumulativeRealEnergy'
    # for the given dimension.
    #
    def numElements_readings_cumulativeRealEnergy(self, dimension):
        array_dims = [ 2,  ]
        if dimension < 0 or dimension >= 1:
            raise IndexException
        if array_dims[dimension] == 0:
            raise IndexError
        return array_dims[dimension]
    
    #
    # Accessor methods for field: readings.averageRealPower
    #   Field type: long[]
    #   Offset (bits): 64
    #   Size of each element (bits): 32
    #

    #
    # Return whether the field 'readings.averageRealPower' is signed (False).
    #
    def isSigned_readings_averageRealPower(self):
        return False
    
    #
    # Return whether the field 'readings.averageRealPower' is an array (True).
    #
    def isArray_readings_averageRealPower(self):
        return True
    
    #
    # Return the offset (in bytes) of the field 'readings.averageRealPower'
    #
    def offset_readings_averageRealPower(self, index1):
        offset = 64
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return (offset / 8)
    
    #
    # Return the offset (in bits) of the field 'readings.averageRealPower'
    #
    def offsetBits_readings_averageRealPower(self, index1):
        offset = 64
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return offset
    
    #
    # Return the entire array 'readings.averageRealPower' as a long[]
    #
    def get_readings_averageRealPower(self):
        tmp = [None]*2
        for index0 in range (0, self.numElements_readings_averageRealPower(0)):
                tmp[index0] = self.getElement_readings_averageRealPower(index0)
        return tmp
    
    #
    # Set the contents of the array 'readings.averageRealPower' from the given long[]
    #
    def set_readings_averageRealPower(self, value):
        for index0 in range(0, len(value)):
            self.setElement_readings_averageRealPower(index0, value[index0])

    #
    # Return an element (as a long) of the array 'readings.averageRealPower'
    #
    def getElement_readings_averageRealPower(self, index1):
        return self.getUIntElement(self.offsetBits_readings_averageRealPower(index1), 32, 1)
    
    #
    # Set an element of the array 'readings.averageRealPower'
    #
    def setElement_readings_averageRealPower(self, index1, value):
        self.setUIntElement(self.offsetBits_readings_averageRealPower(index1), 32, value, 1)
    
    #
    # Return the total size, in bytes, of the array 'readings.averageRealPower'
    #
    def totalSize_readings_averageRealPower(self):
        return (256 / 8)
    
    #
    # Return the total size, in bits, of the array 'readings.averageRealPower'
    #
    def totalSizeBits_readings_averageRealPower(self):
        return 256
    
    #
    # Return the size, in bytes, of each element of the array 'readings.averageRealPower'
    #
    def elementSize_readings_averageRealPower(self):
        return (32 / 8)
    
    #
    # Return the size, in bits, of each element of the array 'readings.averageRealPower'
    #
    def elementSizeBits_readings_averageRealPower(self):
        return 32
    
    #
    # Return the number of dimensions in the array 'readings.averageRealPower'
    #
    def numDimensions_readings_averageRealPower(self):
        return 1
    
    #
    # Return the number of elements in the array 'readings.averageRealPower'
    #
    def numElements_readings_averageRealPower():
        return 2
    
    #
    # Return the number of elements in the array 'readings.averageRealPower'
    # for the given dimension.
    #
    def numElements_readings_averageRealPower(self, dimension):
        array_dims = [ 2,  ]
        if dimension < 0 or dimension >= 1:
            raise IndexException
        if array_dims[dimension] == 0:
            raise IndexError
        return array_dims[dimension]
    
    #
    # Accessor methods for field: readings.averageApparentPower
    #   Field type: long[]
    #   Offset (bits): 96
    #   Size of each element (bits): 32
    #

    #
    # Return whether the field 'readings.averageApparentPower' is signed (False).
    #
    def isSigned_readings_averageApparentPower(self):
        return False
    
    #
    # Return whether the field 'readings.averageApparentPower' is an array (True).
    #
    def isArray_readings_averageApparentPower(self):
        return True
    
    #
    # Return the offset (in bytes) of the field 'readings.averageApparentPower'
    #
    def offset_readings_averageApparentPower(self, index1):
        offset = 96
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return (offset / 8)
    
    #
    # Return the offset (in bits) of the field 'readings.averageApparentPower'
    #
    def offsetBits_readings_averageApparentPower(self, index1):
        offset = 96
        if index1 < 0 or index1 >= 2:
            raise IndexError
        offset += 232 + index1 * 128
        return offset
    
    #
    # Return the entire array 'readings.averageApparentPower' as a long[]
    #
    def get_readings_averageApparentPower(self):
        tmp = [None]*2
        for index0 in range (0, self.numElements_readings_averageApparentPower(0)):
                tmp[index0] = self.getElement_readings_averageApparentPower(index0)
        return tmp
    
    #
    # Set the contents of the array 'readings.averageApparentPower' from the given long[]
    #
    def set_readings_averageApparentPower(self, value):
        for index0 in range(0, len(value)):
            self.setElement_readings_averageApparentPower(index0, value[index0])

    #
    # Return an element (as a long) of the array 'readings.averageApparentPower'
    #
    def getElement_readings_averageApparentPower(self, index1):
        return self.getUIntElement(self.offsetBits_readings_averageApparentPower(index1), 32, 1)
    
    #
    # Set an element of the array 'readings.averageApparentPower'
    #
    def setElement_readings_averageApparentPower(self, index1, value):
        self.setUIntElement(self.offsetBits_readings_averageApparentPower(index1), 32, value, 1)
    
    #
    # Return the total size, in bytes, of the array 'readings.averageApparentPower'
    #
    def totalSize_readings_averageApparentPower(self):
        return (256 / 8)
    
    #
    # Return the total size, in bits, of the array 'readings.averageApparentPower'
    #
    def totalSizeBits_readings_averageApparentPower(self):
        return 256
    
    #
    # Return the size, in bytes, of each element of the array 'readings.averageApparentPower'
    #
    def elementSize_readings_averageApparentPower(self):
        return (32 / 8)
    
    #
    # Return the size, in bits, of each element of the array 'readings.averageApparentPower'
    #
    def elementSizeBits_readings_averageApparentPower(self):
        return 32
    
    #
    # Return the number of dimensions in the array 'readings.averageApparentPower'
    #
    def numDimensions_readings_averageApparentPower(self):
        return 1
    
    #
    # Return the number of elements in the array 'readings.averageApparentPower'
    #
    def numElements_readings_averageApparentPower():
        return 2
    
    #
    # Return the number of elements in the array 'readings.averageApparentPower'
    # for the given dimension.
    #
    def numElements_readings_averageApparentPower(self, dimension):
        array_dims = [ 2,  ]
        if dimension < 0 or dimension >= 1:
            raise IndexException
        if array_dims[dimension] == 0:
            raise IndexError
        return array_dims[dimension]
    
