/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.DecimalSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private StringCollator collator;
    private transient XPathContext context;
    private int itemType;
    public static AtomicMatchKey COLLATION_KEY_NaN = new AtomicMatchKey(){

        public AtomicValue asAtomic() {
            return new QNameValue("saxon", "http://saxon.sf.net/collation-key", "NaN");
        }
    };

    public static AtomicComparer makeSortComparer(StringCollator collator, int itemType, XPathContext context) {
        switch (itemType) {
            case 513: 
            case 529: 
            case 631: {
                if (collator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(collator, Configuration.getPlatform());
            }
            case 515: 
            case 533: {
                return DecimalSortComparer.getDecimalSortComparerInstance();
            }
            case 516: 
            case 517: 
            case 635: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(context);
            }
        }
        return new AtomicSortComparer(collator, itemType, context);
    }

    protected AtomicSortComparer(StringCollator collator, int itemType, XPathContext context) {
        this.collator = collator;
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.context = context;
        this.itemType = itemType;
    }

    public StringCollator getCollator() {
        return this.collator;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return new AtomicSortComparer(this.collator, this.itemType, context);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int getItemType() {
        return this.itemType;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)a).compareTo(b, this.collator, this.context);
        }
        if (b instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)b).compareTo(a, this.collator, this.context);
        }
        if (a.isNaN()) {
            return b.isNaN() ? 0 : -1;
        }
        if (b.isNaN()) {
            return 1;
        }
        if (a instanceof StringValue && b instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(a.getStringValueCS(), b.getStringValueCS());
            }
            return this.collator.compareStrings(a.getStringValue(), b.getStringValue());
        }
        int implicitTimezone = this.context.getImplicitTimezone();
        Comparable ac = (Comparable)((Object)a.getXPathComparable(true, this.collator, implicitTimezone));
        Comparable bc = (Comparable)((Object)b.getXPathComparable(true, this.collator, implicitTimezone));
        if (ac == null || bc == null) {
            return this.compareNonComparables(a, b);
        }
        return ac.compareTo(bc);
    }

    protected int compareNonComparables(AtomicValue a, AtomicValue b) {
        throw new ClassCastException("Values are not comparable (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ')');
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        return this.compareAtomicValues(a, b) == 0;
    }
}

