/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class ListValidator
implements Validator<String> {
    ImmutableList<String> listItems;

    public ListValidator(ImmutableList<String> items) {
        if (ImmutableSet.copyOf(items).size() < items.size()) {
            throw new IllegalArgumentException("Duplicate value in list : " + items);
        }
        this.listItems = items;
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ValidationException {
        if (!this.listItems.contains((Object)parameterValue)) {
            throw new ValidationException("Expected value should be one of " + this.listItems + ", received '" + parameterValue + "'");
        }
        return parameterValue;
    }
}

