# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._service_fabric_managed_clusters_management_client_enums import *


class ScalingMechanism(msrest.serialization.Model):
    """Describes the mechanism for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddRemoveIncrementalNamedPartitionScalingMechanism, PartitionInstanceCountScaleMechanism.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server. Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingMechanismKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AddRemoveIncrementalNamedPartition': 'AddRemoveIncrementalNamedPartitionScalingMechanism', 'ScalePartitionInstanceCount': 'PartitionInstanceCountScaleMechanism'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ScalingMechanism, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AddRemoveIncrementalNamedPartitionScalingMechanism(ScalingMechanism):
    """Represents a scaling mechanism for adding or removing named partitions of a stateless service. Partition names are in the format '0','1'...'N-1'.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server. Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingMechanismKind
    :ivar min_partition_count: Required. Minimum number of named partitions of the service.
    :vartype min_partition_count: int
    :ivar max_partition_count: Required. Maximum number of named partitions of the service.
    :vartype max_partition_count: int
    :ivar scale_increment: Required. The number of instances to add or remove during a scaling
     operation.
    :vartype scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_partition_count': {'required': True},
        'max_partition_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'min_partition_count': {'key': 'minPartitionCount', 'type': 'int'},
        'max_partition_count': {'key': 'maxPartitionCount', 'type': 'int'},
        'scale_increment': {'key': 'scaleIncrement', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_partition_count: int,
        max_partition_count: int,
        scale_increment: int,
        **kwargs
    ):
        """
        :keyword min_partition_count: Required. Minimum number of named partitions of the service.
        :paramtype min_partition_count: int
        :keyword max_partition_count: Required. Maximum number of named partitions of the service.
        :paramtype max_partition_count: int
        :keyword scale_increment: Required. The number of instances to add or remove during a scaling
         operation.
        :paramtype scale_increment: int
        """
        super(AddRemoveIncrementalNamedPartitionScalingMechanism, self).__init__(**kwargs)
        self.kind = 'AddRemoveIncrementalNamedPartition'  # type: str
        self.min_partition_count = min_partition_count
        self.max_partition_count = max_partition_count
        self.scale_increment = scale_increment


class ApplicationHealthPolicy(msrest.serialization.Model):
    """Defines a health policy used to evaluate the health of an application or one of its children entities.

    All required parameters must be populated in order to send to Azure.

    :ivar consider_warning_as_error: Required. Indicates whether warnings are treated with the same
     severity as errors.
    :vartype consider_warning_as_error: bool
    :ivar max_percent_unhealthy_deployed_applications: Required. The maximum allowed percentage of
     unhealthy deployed applications. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can
     be unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number
     of nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default
     percentage is zero.
    :vartype max_percent_unhealthy_deployed_applications: int
    :ivar default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :vartype default_service_type_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy
    :ivar service_type_health_policy_map: The map with service type health policy per service type
     name. The map is empty by default.
    :vartype service_type_health_policy_map: dict[str,
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy]
    """

    _validation = {
        'consider_warning_as_error': {'required': True},
        'max_percent_unhealthy_deployed_applications': {'required': True},
    }

    _attribute_map = {
        'consider_warning_as_error': {'key': 'considerWarningAsError', 'type': 'bool'},
        'max_percent_unhealthy_deployed_applications': {'key': 'maxPercentUnhealthyDeployedApplications', 'type': 'int'},
        'default_service_type_health_policy': {'key': 'defaultServiceTypeHealthPolicy', 'type': 'ServiceTypeHealthPolicy'},
        'service_type_health_policy_map': {'key': 'serviceTypeHealthPolicyMap', 'type': '{ServiceTypeHealthPolicy}'},
    }

    def __init__(
        self,
        *,
        consider_warning_as_error: bool,
        max_percent_unhealthy_deployed_applications: int,
        default_service_type_health_policy: Optional["ServiceTypeHealthPolicy"] = None,
        service_type_health_policy_map: Optional[Dict[str, "ServiceTypeHealthPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword consider_warning_as_error: Required. Indicates whether warnings are treated with the
         same severity as errors.
        :paramtype consider_warning_as_error: bool
        :keyword max_percent_unhealthy_deployed_applications: Required. The maximum allowed percentage
         of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
         The percentage represents the maximum tolerated percentage of deployed applications that can
         be unhealthy before the application is considered in error.
         This is calculated by dividing the number of unhealthy deployed applications over the number
         of nodes where the application is currently deployed on in the cluster.
         The computation rounds up to tolerate one failure on small numbers of nodes. Default
         percentage is zero.
        :paramtype max_percent_unhealthy_deployed_applications: int
        :keyword default_service_type_health_policy: The health policy used by default to evaluate the
         health of a service type.
        :paramtype default_service_type_health_policy:
         ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy
        :keyword service_type_health_policy_map: The map with service type health policy per service
         type name. The map is empty by default.
        :paramtype service_type_health_policy_map: dict[str,
         ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy]
        """
        super(ApplicationHealthPolicy, self).__init__(**kwargs)
        self.consider_warning_as_error = consider_warning_as_error
        self.max_percent_unhealthy_deployed_applications = max_percent_unhealthy_deployed_applications
        self.default_service_type_health_policy = default_service_type_health_policy
        self.service_type_health_policy_map = service_type_health_policy_map


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for proxy-only resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location depends on the parent resource.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location depends on the parent resource.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        """
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None


class ApplicationResource(ProxyResource):
    """The application resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location depends on the parent resource.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar identity: Describes the managed identities for an Azure resource.
    :vartype identity: ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar version: The version of the application type as defined in the application manifest.
     This name must be the full Arm Resource ID for the referenced application type version.
    :vartype version: str
    :ivar parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :vartype parameters: dict[str, str]
    :ivar upgrade_policy: Describes the policy for a monitored application upgrade.
    :vartype upgrade_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUpgradePolicy
    :ivar managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :vartype managed_identities:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUserAssignedIdentity]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'managed_identities': {'key': 'properties.managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedIdentity"] = None,
        version: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        upgrade_policy: Optional["ApplicationUpgradePolicy"] = None,
        managed_identities: Optional[List["ApplicationUserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location depends on the parent resource.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Describes the managed identities for an Azure resource.
        :paramtype identity: ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentity
        :keyword version: The version of the application type as defined in the application manifest.
         This name must be the full Arm Resource ID for the referenced application type version.
        :paramtype version: str
        :keyword parameters: List of application parameters with overridden values from their default
         values specified in the application manifest.
        :paramtype parameters: dict[str, str]
        :keyword upgrade_policy: Describes the policy for a monitored application upgrade.
        :paramtype upgrade_policy:
         ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUpgradePolicy
        :keyword managed_identities: List of user assigned identities for the application, each mapped
         to a friendly name.
        :paramtype managed_identities:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUserAssignedIdentity]
        """
        super(ApplicationResource, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.version = version
        self.parameters = parameters
        self.upgrade_policy = upgrade_policy
        self.managed_identities = managed_identities


class ApplicationResourceList(msrest.serialization.Model):
    """The list of application resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationResource]
    :ivar next_link: URL to get the next set of application list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationResource"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationResource]
        """
        super(ApplicationResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeResource(ProxyResource):
    """The application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location depends on the parent resource.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location depends on the parent resource.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        """
        super(ApplicationTypeResource, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None


class ApplicationTypeResourceList(msrest.serialization.Model):
    """The list of application type names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeResource]
    :ivar next_link: URL to get the next set of application type list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationTypeResource"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeResource]
        """
        super(ApplicationTypeResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeUpdateParameters(msrest.serialization.Model):
    """Application type update request.

    :ivar tags: A set of tags. Application type update parameters.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application type update parameters.
        :paramtype tags: dict[str, str]
        """
        super(ApplicationTypeUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationTypeVersionResource(ProxyResource):
    """An application type version resource for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location depends on the parent resource.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar app_package_url: The URL to the application package.
    :vartype app_package_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'app_package_url': {'key': 'properties.appPackageUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        app_package_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location depends on the parent resource.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword app_package_url: The URL to the application package.
        :paramtype app_package_url: str
        """
        super(ApplicationTypeVersionResource, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.app_package_url = app_package_url


class ApplicationTypeVersionResourceList(msrest.serialization.Model):
    """The list of application type version resources for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionResource]
    :ivar next_link: URL to get the next set of application type version list results if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeVersionResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationTypeVersionResource"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionResource]
        """
        super(ApplicationTypeVersionResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeVersionsCleanupPolicy(msrest.serialization.Model):
    """The policy used to clean up unused versions. When the policy is not specified explicitly, the default unused application versions to keep will be 3.

    All required parameters must be populated in order to send to Azure.

    :ivar max_unused_versions_to_keep: Required. Number of unused versions per application type to
     keep.
    :vartype max_unused_versions_to_keep: int
    """

    _validation = {
        'max_unused_versions_to_keep': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'max_unused_versions_to_keep': {'key': 'maxUnusedVersionsToKeep', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_unused_versions_to_keep: int,
        **kwargs
    ):
        """
        :keyword max_unused_versions_to_keep: Required. Number of unused versions per application type
         to keep.
        :paramtype max_unused_versions_to_keep: int
        """
        super(ApplicationTypeVersionsCleanupPolicy, self).__init__(**kwargs)
        self.max_unused_versions_to_keep = max_unused_versions_to_keep


class ApplicationTypeVersionUpdateParameters(msrest.serialization.Model):
    """Application type version update request.

    :ivar tags: A set of tags. Application type version update parameters.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application type version update parameters.
        :paramtype tags: dict[str, str]
        """
        super(ApplicationTypeVersionUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationUpdateParameters(msrest.serialization.Model):
    """Application update request.

    :ivar tags: A set of tags. Application update parameters.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Application update parameters.
        :paramtype tags: dict[str, str]
        """
        super(ApplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationUpgradePolicy(msrest.serialization.Model):
    """Describes the policy for a monitored application upgrade.

    :ivar application_health_policy: Defines a health policy used to evaluate the health of an
     application or one of its children entities.
    :vartype application_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationHealthPolicy
    :ivar force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :vartype force_restart: bool
    :ivar rolling_upgrade_monitoring_policy: The policy used for monitoring the application
     upgrade.
    :vartype rolling_upgrade_monitoring_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMonitoringPolicy
    :ivar instance_close_delay_duration: Duration in seconds, to wait before a stateless instance
     is closed, to allow the active requests to drain gracefully. This would be effective when the
     instance is closing during the application/cluster upgrade, only for those instances which have
     a non-zero delay duration configured in the service description.
    :vartype instance_close_delay_duration: long
    :ivar upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are
     Monitored, and UnmonitoredAuto. Possible values include: "Monitored", "UnmonitoredAuto".
    :vartype upgrade_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMode
    :ivar upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an
     upgrade domain and prevent loss of availability when there are unexpected issues. When this
     timeout expires, processing of the upgrade domain will proceed regardless of availability loss
     issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0
     and 42949672925 inclusive. (unsigned 32-bit integer).
    :vartype upgrade_replica_set_check_timeout: long
    :ivar recreate_application: Determines whether the application should be recreated on update.
     If value=true, the rest of the upgrade policy parameters are not allowed.
    :vartype recreate_application: bool
    """

    _attribute_map = {
        'application_health_policy': {'key': 'applicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
        'force_restart': {'key': 'forceRestart', 'type': 'bool'},
        'rolling_upgrade_monitoring_policy': {'key': 'rollingUpgradeMonitoringPolicy', 'type': 'RollingUpgradeMonitoringPolicy'},
        'instance_close_delay_duration': {'key': 'instanceCloseDelayDuration', 'type': 'long'},
        'upgrade_mode': {'key': 'upgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout': {'key': 'upgradeReplicaSetCheckTimeout', 'type': 'long'},
        'recreate_application': {'key': 'recreateApplication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        application_health_policy: Optional["ApplicationHealthPolicy"] = None,
        force_restart: Optional[bool] = False,
        rolling_upgrade_monitoring_policy: Optional["RollingUpgradeMonitoringPolicy"] = None,
        instance_close_delay_duration: Optional[int] = None,
        upgrade_mode: Optional[Union[str, "RollingUpgradeMode"]] = None,
        upgrade_replica_set_check_timeout: Optional[int] = None,
        recreate_application: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword application_health_policy: Defines a health policy used to evaluate the health of an
         application or one of its children entities.
        :paramtype application_health_policy:
         ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationHealthPolicy
        :keyword force_restart: If true, then processes are forcefully restarted during upgrade even
         when the code version has not changed (the upgrade only changes configuration or data).
        :paramtype force_restart: bool
        :keyword rolling_upgrade_monitoring_policy: The policy used for monitoring the application
         upgrade.
        :paramtype rolling_upgrade_monitoring_policy:
         ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMonitoringPolicy
        :keyword instance_close_delay_duration: Duration in seconds, to wait before a stateless
         instance is closed, to allow the active requests to drain gracefully. This would be effective
         when the instance is closing during the application/cluster upgrade, only for those instances
         which have a non-zero delay duration configured in the service description.
        :paramtype instance_close_delay_duration: long
        :keyword upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are
         Monitored, and UnmonitoredAuto. Possible values include: "Monitored", "UnmonitoredAuto".
        :paramtype upgrade_mode: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMode
        :keyword upgrade_replica_set_check_timeout: The maximum amount of time to block processing of
         an upgrade domain and prevent loss of availability when there are unexpected issues. When this
         timeout expires, processing of the upgrade domain will proceed regardless of availability loss
         issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0
         and 42949672925 inclusive. (unsigned 32-bit integer).
        :paramtype upgrade_replica_set_check_timeout: long
        :keyword recreate_application: Determines whether the application should be recreated on
         update. If value=true, the rest of the upgrade policy parameters are not allowed.
        :paramtype recreate_application: bool
        """
        super(ApplicationUpgradePolicy, self).__init__(**kwargs)
        self.application_health_policy = application_health_policy
        self.force_restart = force_restart
        self.rolling_upgrade_monitoring_policy = rolling_upgrade_monitoring_policy
        self.instance_close_delay_duration = instance_close_delay_duration
        self.upgrade_mode = upgrade_mode
        self.upgrade_replica_set_check_timeout = upgrade_replica_set_check_timeout
        self.recreate_application = recreate_application


class ApplicationUserAssignedIdentity(msrest.serialization.Model):
    """ApplicationUserAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The friendly name of user assigned identity.
    :vartype name: str
    :ivar principal_id: Required. The principal id of user assigned identity.
    :vartype principal_id: str
    """

    _validation = {
        'name': {'required': True},
        'principal_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        principal_id: str,
        **kwargs
    ):
        """
        :keyword name: Required. The friendly name of user assigned identity.
        :paramtype name: str
        :keyword principal_id: Required. The principal id of user assigned identity.
        :paramtype principal_id: str
        """
        super(ApplicationUserAssignedIdentity, self).__init__(**kwargs)
        self.name = name
        self.principal_id = principal_id


class AvailableOperationDisplay(msrest.serialization.Model):
    """Operation supported by the Service Fabric resource provider.

    :ivar provider: The name of the provider.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that can be performed.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The name of the provider.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that can be performed.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super(AvailableOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ScalingTrigger(msrest.serialization.Model):
    """Describes the trigger for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AveragePartitionLoadScalingTrigger, AverageServiceLoadScalingTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the trigger associated with this scaling policy.Constant filled
     by server. Possible values include: "AveragePartitionLoadTrigger", "AverageServiceLoadTrigger".
    :vartype kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingTriggerKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AveragePartitionLoadTrigger': 'AveragePartitionLoadScalingTrigger', 'AverageServiceLoadTrigger': 'AverageServiceLoadScalingTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ScalingTrigger, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AveragePartitionLoadScalingTrigger(ScalingTrigger):
    """Represents a scaling trigger related to an average load of a metric/resource of a partition.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the trigger associated with this scaling policy.Constant filled
     by server. Possible values include: "AveragePartitionLoadTrigger", "AverageServiceLoadTrigger".
    :vartype kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingTriggerKind
    :ivar metric_name: Required. The name of the metric for which usage should be tracked.
    :vartype metric_name: str
    :ivar lower_load_threshold: Required. The lower limit of the load below which a scale in
     operation should be performed.
    :vartype lower_load_threshold: float
    :ivar upper_load_threshold: Required. The upper limit of the load beyond which a scale out
     operation should be performed.
    :vartype upper_load_threshold: float
    :ivar scale_interval: Required. The period in seconds on which a decision is made whether to
     scale or not. This property should come in ISO 8601 format "hh:mm:ss".
    :vartype scale_interval: str
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval': {'key': 'scaleInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
        **kwargs
    ):
        """
        :keyword metric_name: Required. The name of the metric for which usage should be tracked.
        :paramtype metric_name: str
        :keyword lower_load_threshold: Required. The lower limit of the load below which a scale in
         operation should be performed.
        :paramtype lower_load_threshold: float
        :keyword upper_load_threshold: Required. The upper limit of the load beyond which a scale out
         operation should be performed.
        :paramtype upper_load_threshold: float
        :keyword scale_interval: Required. The period in seconds on which a decision is made whether to
         scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        :paramtype scale_interval: str
        """
        super(AveragePartitionLoadScalingTrigger, self).__init__(**kwargs)
        self.kind = 'AveragePartitionLoadTrigger'  # type: str
        self.metric_name = metric_name
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval = scale_interval


class AverageServiceLoadScalingTrigger(ScalingTrigger):
    """Represents a scaling policy related to an average load of a metric/resource of a service.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the trigger associated with this scaling policy.Constant filled
     by server. Possible values include: "AveragePartitionLoadTrigger", "AverageServiceLoadTrigger".
    :vartype kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingTriggerKind
    :ivar metric_name: Required. The name of the metric for which usage should be tracked.
    :vartype metric_name: str
    :ivar lower_load_threshold: Required. The lower limit of the load below which a scale in
     operation should be performed.
    :vartype lower_load_threshold: float
    :ivar upper_load_threshold: Required. The upper limit of the load beyond which a scale out
     operation should be performed.
    :vartype upper_load_threshold: float
    :ivar scale_interval: Required. The period in seconds on which a decision is made whether to
     scale or not. This property should come in ISO 8601 format "hh:mm:ss".
    :vartype scale_interval: str
    :ivar use_only_primary_load: Required. Flag determines whether only the load of primary replica
     should be considered for scaling. If set to true, then trigger will only consider the load of
     primary replicas of stateful service. If set to false, trigger will consider load of all
     replicas. This parameter cannot be set to true for stateless service.
    :vartype use_only_primary_load: bool
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval': {'required': True},
        'use_only_primary_load': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval': {'key': 'scaleInterval', 'type': 'str'},
        'use_only_primary_load': {'key': 'useOnlyPrimaryLoad', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
        use_only_primary_load: bool,
        **kwargs
    ):
        """
        :keyword metric_name: Required. The name of the metric for which usage should be tracked.
        :paramtype metric_name: str
        :keyword lower_load_threshold: Required. The lower limit of the load below which a scale in
         operation should be performed.
        :paramtype lower_load_threshold: float
        :keyword upper_load_threshold: Required. The upper limit of the load beyond which a scale out
         operation should be performed.
        :paramtype upper_load_threshold: float
        :keyword scale_interval: Required. The period in seconds on which a decision is made whether to
         scale or not. This property should come in ISO 8601 format "hh:mm:ss".
        :paramtype scale_interval: str
        :keyword use_only_primary_load: Required. Flag determines whether only the load of primary
         replica should be considered for scaling. If set to true, then trigger will only consider the
         load of primary replicas of stateful service. If set to false, trigger will consider load of
         all replicas. This parameter cannot be set to true for stateless service.
        :paramtype use_only_primary_load: bool
        """
        super(AverageServiceLoadScalingTrigger, self).__init__(**kwargs)
        self.kind = 'AverageServiceLoadTrigger'  # type: str
        self.metric_name = metric_name
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval = scale_interval
        self.use_only_primary_load = use_only_primary_load


class AzureActiveDirectory(msrest.serialization.Model):
    """The settings to enable AAD authentication on the cluster.

    :ivar tenant_id: Azure active directory tenant id.
    :vartype tenant_id: str
    :ivar cluster_application: Azure active directory cluster application id.
    :vartype cluster_application: str
    :ivar client_application: Azure active directory client application id.
    :vartype client_application: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'cluster_application': {'key': 'clusterApplication', 'type': 'str'},
        'client_application': {'key': 'clientApplication', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        cluster_application: Optional[str] = None,
        client_application: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: Azure active directory tenant id.
        :paramtype tenant_id: str
        :keyword cluster_application: Azure active directory cluster application id.
        :paramtype cluster_application: str
        :keyword client_application: Azure active directory client application id.
        :paramtype client_application: str
        """
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.cluster_application = cluster_application
        self.client_application = client_application


class ClientCertificate(msrest.serialization.Model):
    """Client certificate definition.

    All required parameters must be populated in order to send to Azure.

    :ivar is_admin: Required. Indicates if the client certificate has admin access to the cluster.
     Non admin clients can perform only read only operations on the cluster.
    :vartype is_admin: bool
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar common_name: Certificate common name.
    :vartype common_name: str
    :ivar issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with
     CommonName.
    :vartype issuer_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'common_name': {'key': 'commonName', 'type': 'str'},
        'issuer_thumbprint': {'key': 'issuerThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_admin: bool,
        thumbprint: Optional[str] = None,
        common_name: Optional[str] = None,
        issuer_thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_admin: Required. Indicates if the client certificate has admin access to the
         cluster. Non admin clients can perform only read only operations on the cluster.
        :paramtype is_admin: bool
        :keyword thumbprint: Certificate thumbprint.
        :paramtype thumbprint: str
        :keyword common_name: Certificate common name.
        :paramtype common_name: str
        :keyword issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with
         CommonName.
        :paramtype issuer_thumbprint: str
        """
        super(ClientCertificate, self).__init__(**kwargs)
        self.is_admin = is_admin
        self.thumbprint = thumbprint
        self.common_name = common_name
        self.issuer_thumbprint = issuer_thumbprint


class EndpointRangeDescription(msrest.serialization.Model):
    """Port range details.

    All required parameters must be populated in order to send to Azure.

    :ivar start_port: Required. Starting port of a range of ports.
    :vartype start_port: int
    :ivar end_port: Required. End port of a range of ports.
    :vartype end_port: int
    """

    _validation = {
        'start_port': {'required': True},
        'end_port': {'required': True},
    }

    _attribute_map = {
        'start_port': {'key': 'startPort', 'type': 'int'},
        'end_port': {'key': 'endPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_port: int,
        end_port: int,
        **kwargs
    ):
        """
        :keyword start_port: Required. Starting port of a range of ports.
        :paramtype start_port: int
        :keyword end_port: Required. End port of a range of ports.
        :paramtype end_port: int
        """
        super(EndpointRangeDescription, self).__init__(**kwargs)
        self.start_port = start_port
        self.end_port = end_port


class ErrorModel(msrest.serialization.Model):
    """The structure of the error.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorModelError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorModelError'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorModelError"] = None,
        **kwargs
    ):
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorModelError
        """
        super(ErrorModel, self).__init__(**kwargs)
        self.error = error


class ErrorModelError(msrest.serialization.Model):
    """The error details.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super(ErrorModelError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class FrontendConfiguration(msrest.serialization.Model):
    """Describes the frontend configurations for the node type.

    :ivar ip_address_type: The IP address type of this frontend configuration. If omitted the
     default value is IPv4. Possible values include: "IPv4", "IPv6". Default value: "IPv4".
    :vartype ip_address_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.IPAddressType
    :ivar load_balancer_backend_address_pool_id: The resource Id of the Load Balancer backend
     address pool that the VM instances of the node type are associated with. The format of the
     resource Id is
     '/subscriptions/:code:`<subscriptionId>`/resourceGroups/:code:`<resourceGroupName>`/providers/Microsoft.Network/loadBalancers/:code:`<loadBalancerName>`/backendAddressPools/:code:`<backendAddressPoolName>`'.
    :vartype load_balancer_backend_address_pool_id: str
    :ivar load_balancer_inbound_nat_pool_id: The resource Id of the Load Balancer inbound NAT pool
     that the VM instances of the node type are associated with. The format of the resource Id is
     '/subscriptions/:code:`<subscriptionId>`/resourceGroups/:code:`<resourceGroupName>`/providers/Microsoft.Network/loadBalancers/:code:`<loadBalancerName>`/inboundNatPools/:code:`<inboundNatPoolName>`'.
    :vartype load_balancer_inbound_nat_pool_id: str
    """

    _attribute_map = {
        'ip_address_type': {'key': 'ipAddressType', 'type': 'str'},
        'load_balancer_backend_address_pool_id': {'key': 'loadBalancerBackendAddressPoolId', 'type': 'str'},
        'load_balancer_inbound_nat_pool_id': {'key': 'loadBalancerInboundNatPoolId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address_type: Optional[Union[str, "IPAddressType"]] = "IPv4",
        load_balancer_backend_address_pool_id: Optional[str] = None,
        load_balancer_inbound_nat_pool_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ip_address_type: The IP address type of this frontend configuration. If omitted the
         default value is IPv4. Possible values include: "IPv4", "IPv6". Default value: "IPv4".
        :paramtype ip_address_type: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.IPAddressType
        :keyword load_balancer_backend_address_pool_id: The resource Id of the Load Balancer backend
         address pool that the VM instances of the node type are associated with. The format of the
         resource Id is
         '/subscriptions/:code:`<subscriptionId>`/resourceGroups/:code:`<resourceGroupName>`/providers/Microsoft.Network/loadBalancers/:code:`<loadBalancerName>`/backendAddressPools/:code:`<backendAddressPoolName>`'.
        :paramtype load_balancer_backend_address_pool_id: str
        :keyword load_balancer_inbound_nat_pool_id: The resource Id of the Load Balancer inbound NAT
         pool that the VM instances of the node type are associated with. The format of the resource Id
         is
         '/subscriptions/:code:`<subscriptionId>`/resourceGroups/:code:`<resourceGroupName>`/providers/Microsoft.Network/loadBalancers/:code:`<loadBalancerName>`/inboundNatPools/:code:`<inboundNatPoolName>`'.
        :paramtype load_balancer_inbound_nat_pool_id: str
        """
        super(FrontendConfiguration, self).__init__(**kwargs)
        self.ip_address_type = ip_address_type
        self.load_balancer_backend_address_pool_id = load_balancer_backend_address_pool_id
        self.load_balancer_inbound_nat_pool_id = load_balancer_inbound_nat_pool_id


class IPTag(msrest.serialization.Model):
    """IPTag associated with the object.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_tag_type: Required. The IP tag type.
    :vartype ip_tag_type: str
    :ivar tag: Required. The value of the IP tag.
    :vartype tag: str
    """

    _validation = {
        'ip_tag_type': {'required': True},
        'tag': {'required': True},
    }

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_tag_type: str,
        tag: str,
        **kwargs
    ):
        """
        :keyword ip_tag_type: Required. The IP tag type.
        :paramtype ip_tag_type: str
        :keyword tag: Required. The value of the IP tag.
        :paramtype tag: str
        """
        super(IPTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class LoadBalancingRule(msrest.serialization.Model):
    """Describes a load balancing rule.

    All required parameters must be populated in order to send to Azure.

    :ivar frontend_port: Required. The port for the external endpoint. Port numbers for each rule
     must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :vartype frontend_port: int
    :ivar backend_port: Required. The port used for internal connections on the endpoint.
     Acceptable values are between 1 and 65535.
    :vartype backend_port: int
    :ivar protocol: Required. The reference to the transport protocol used by the load balancing
     rule. Possible values include: "tcp", "udp".
    :vartype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.Protocol
    :ivar probe_port: The prob port used by the load balancing rule. Acceptable values are between
     1 and 65535.
    :vartype probe_port: int
    :ivar probe_protocol: Required. the reference to the load balancer probe used by the load
     balancing rule. Possible values include: "tcp", "http", "https".
    :vartype probe_protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.ProbeProtocol
    :ivar probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
    :vartype probe_request_path: str
    :ivar load_distribution: The load distribution policy for this rule.
    :vartype load_distribution: str
    """

    _validation = {
        'frontend_port': {'required': True, 'maximum': 65534, 'minimum': 1},
        'backend_port': {'required': True, 'maximum': 65534, 'minimum': 1},
        'protocol': {'required': True},
        'probe_port': {'maximum': 65534, 'minimum': 1},
        'probe_protocol': {'required': True},
    }

    _attribute_map = {
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'probe_port': {'key': 'probePort', 'type': 'int'},
        'probe_protocol': {'key': 'probeProtocol', 'type': 'str'},
        'probe_request_path': {'key': 'probeRequestPath', 'type': 'str'},
        'load_distribution': {'key': 'loadDistribution', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        frontend_port: int,
        backend_port: int,
        protocol: Union[str, "Protocol"],
        probe_protocol: Union[str, "ProbeProtocol"],
        probe_port: Optional[int] = None,
        probe_request_path: Optional[str] = None,
        load_distribution: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword frontend_port: Required. The port for the external endpoint. Port numbers for each
         rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :paramtype frontend_port: int
        :keyword backend_port: Required. The port used for internal connections on the endpoint.
         Acceptable values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword protocol: Required. The reference to the transport protocol used by the load balancing
         rule. Possible values include: "tcp", "udp".
        :paramtype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.Protocol
        :keyword probe_port: The prob port used by the load balancing rule. Acceptable values are
         between 1 and 65535.
        :paramtype probe_port: int
        :keyword probe_protocol: Required. the reference to the load balancer probe used by the load
         balancing rule. Possible values include: "tcp", "http", "https".
        :paramtype probe_protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.ProbeProtocol
        :keyword probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
        :paramtype probe_request_path: str
        :keyword load_distribution: The load distribution policy for this rule.
        :paramtype load_distribution: str
        """
        super(LoadBalancingRule, self).__init__(**kwargs)
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.protocol = protocol
        self.probe_port = probe_port
        self.probe_protocol = probe_protocol
        self.probe_request_path = probe_request_path
        self.load_distribution = load_distribution


class LongRunningOperationResult(msrest.serialization.Model):
    """Long running operation result.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The completion percentage of the operation.
    :vartype percent_complete: float
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The operation error.
    :vartype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorModelError
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'float'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorModelError'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        status: Optional[str] = None,
        error: Optional["ErrorModelError"] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the operation.
        :paramtype name: str
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword percent_complete: The completion percentage of the operation.
        :paramtype percent_complete: float
        :keyword status: The status of the operation.
        :paramtype status: str
        :keyword error: The operation error.
        :paramtype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorModelError
        """
        super(LongRunningOperationResult, self).__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.percent_complete = percent_complete
        self.status = status
        self.error = error


class ManagedAzResiliencyStatus(msrest.serialization.Model):
    """Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base_resource_status: List of Managed VM Sizes for Service Fabric Managed Clusters.
    :vartype base_resource_status:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ResourceAzStatus]
    :ivar is_cluster_zone_resilient: URL to get the next set of Managed VM Sizes if there are any.
    :vartype is_cluster_zone_resilient: bool
    """

    _validation = {
        'is_cluster_zone_resilient': {'readonly': True},
    }

    _attribute_map = {
        'base_resource_status': {'key': 'baseResourceStatus', 'type': '[ResourceAzStatus]'},
        'is_cluster_zone_resilient': {'key': 'isClusterZoneResilient', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        base_resource_status: Optional[List["ResourceAzStatus"]] = None,
        **kwargs
    ):
        """
        :keyword base_resource_status: List of Managed VM Sizes for Service Fabric Managed Clusters.
        :paramtype base_resource_status:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ResourceAzStatus]
        """
        super(ManagedAzResiliencyStatus, self).__init__(**kwargs)
        self.base_resource_status = base_resource_status
        self.is_cluster_zone_resilient = None


class Resource(msrest.serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Azure resource location.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Azure resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.etag = None
        self.system_data = None


class ManagedCluster(Resource):
    """The manged cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Azure resource location.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar sku: The sku of the managed cluster.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.Sku
    :ivar dns_name: The cluster dns name.
    :vartype dns_name: str
    :ivar fqdn: The fully qualified domain name associated with the public load balancer of the
     cluster.
    :vartype fqdn: str
    :ivar ipv4_address: The IPv4 address associated with the public load balancer of the cluster.
    :vartype ipv4_address: str
    :ivar cluster_id: A service generated unique identifier for the cluster resource.
    :vartype cluster_id: str
    :ivar cluster_state: The current state of the cluster. Possible values include:
     "WaitingForNodes", "Deploying", "BaselineUpgrade", "Upgrading", "UpgradeFailed", "Ready".
    :vartype cluster_state: str or ~azure.mgmt.servicefabricmanagedclusters.models.ClusterState
    :ivar cluster_certificate_thumbprints: List of thumbprints of the cluster certificates.
    :vartype cluster_certificate_thumbprints: list[str]
    :ivar client_connection_port: The port used for client connections to the cluster.
    :vartype client_connection_port: int
    :ivar http_gateway_connection_port: The port used for HTTP connections to the cluster.
    :vartype http_gateway_connection_port: int
    :ivar admin_user_name: VM admin user name.
    :vartype admin_user_name: str
    :ivar admin_password: VM admin user password.
    :vartype admin_password: str
    :ivar load_balancing_rules: Load balancing rules that are applied to the public load balancer
     of the cluster.
    :vartype load_balancing_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.LoadBalancingRule]
    :ivar allow_rdp_access: Setting this to true enables RDP access to the VM. The default NSG rule
     opens RDP port to Internet which can be overridden with custom Network Security Rules. The
     default value for this setting is false.
    :vartype allow_rdp_access: bool
    :ivar network_security_rules: Custom Network Security Rules that are applied to the Virtual
     Network of the cluster.
    :vartype network_security_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
    :ivar clients: Client certificates that are allowed to manage the cluster.
    :vartype clients: list[~azure.mgmt.servicefabricmanagedclusters.models.ClientCertificate]
    :ivar azure_active_directory: The AAD authentication settings of the cluster.
    :vartype azure_active_directory:
     ~azure.mgmt.servicefabricmanagedclusters.models.AzureActiveDirectory
    :ivar fabric_settings: The list of custom fabric settings to configure the cluster.
    :vartype fabric_settings:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsSectionDescription]
    :ivar provisioning_state: The provisioning state of the managed cluster resource. Possible
     values include: "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled",
     "Deleting", "Deleted", "Other".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedResourceProvisioningState
    :ivar cluster_code_version: The Service Fabric runtime version of the cluster. This property is
     required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service
     Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To get the
     list of available version for existing clusters use **availableClusterVersions**.
    :vartype cluster_code_version: str
    :ivar cluster_upgrade_mode: The upgrade mode of the cluster when new Service Fabric runtime
     version is available. Possible values include: "Automatic", "Manual". Default value:
     "Automatic".
    :vartype cluster_upgrade_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeMode
    :ivar cluster_upgrade_cadence: Indicates when new cluster runtime version upgrades will be
     applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode**
     is set to 'Automatic'. Possible values include: "Wave0", "Wave1", "Wave2".
    :vartype cluster_upgrade_cadence: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeCadence
    :ivar addon_features: List of add-on features to enable on the cluster.
    :vartype addon_features: list[str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedClusterAddOnFeature]
    :ivar enable_auto_os_upgrade: Setting this to true enables automatic OS upgrade for the node
     types that are created using any platform OS image with version 'latest'. The default value for
     this setting is false.
    :vartype enable_auto_os_upgrade: bool
    :ivar zonal_resiliency: Indicates if the cluster has zone resiliency.
    :vartype zonal_resiliency: bool
    :ivar application_type_versions_cleanup_policy: The policy used to clean up unused versions.
    :vartype application_type_versions_cleanup_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionsCleanupPolicy
    :ivar enable_ipv6: Setting this to true creates IPv6 address space for the default VNet used by
     the cluster. This setting cannot be changed once the cluster is created. The default value for
     this setting is false.
    :vartype enable_ipv6: bool
    :ivar subnet_id: If specified, the node types for the cluster are created in this subnet
     instead of the default VNet. The **networkSecurityRules** specified for the cluster are also
     applied to this subnet. This setting cannot be changed once the cluster is created.
    :vartype subnet_id: str
    :ivar ip_tags: The list of IP tags associated with the default public IP address of the
     cluster.
    :vartype ip_tags: list[~azure.mgmt.servicefabricmanagedclusters.models.IPTag]
    :ivar ipv6_address: IPv6 address for the cluster if IPv6 is enabled.
    :vartype ipv6_address: str
    :ivar enable_service_public_ip: Setting this to true will link the IPv4 address as the
     ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the
     cluster.
    :vartype enable_service_public_ip: bool
    :ivar auxiliary_subnets: Auxiliary subnets for the cluster.
    :vartype auxiliary_subnets: list[~azure.mgmt.servicefabricmanagedclusters.models.Subnet]
    :ivar service_endpoints: Service endpoints for subnets in the cluster.
    :vartype service_endpoints:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceEndpoint]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'fqdn': {'readonly': True},
        'ipv4_address': {'readonly': True},
        'cluster_id': {'readonly': True},
        'cluster_state': {'readonly': True},
        'cluster_certificate_thumbprints': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'ipv6_address': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'dns_name': {'key': 'properties.dnsName', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'ipv4_address': {'key': 'properties.ipv4Address', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_state': {'key': 'properties.clusterState', 'type': 'str'},
        'cluster_certificate_thumbprints': {'key': 'properties.clusterCertificateThumbprints', 'type': '[str]'},
        'client_connection_port': {'key': 'properties.clientConnectionPort', 'type': 'int'},
        'http_gateway_connection_port': {'key': 'properties.httpGatewayConnectionPort', 'type': 'int'},
        'admin_user_name': {'key': 'properties.adminUserName', 'type': 'str'},
        'admin_password': {'key': 'properties.adminPassword', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'allow_rdp_access': {'key': 'properties.allowRdpAccess', 'type': 'bool'},
        'network_security_rules': {'key': 'properties.networkSecurityRules', 'type': '[NetworkSecurityRule]'},
        'clients': {'key': 'properties.clients', 'type': '[ClientCertificate]'},
        'azure_active_directory': {'key': 'properties.azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'fabric_settings': {'key': 'properties.fabricSettings', 'type': '[SettingsSectionDescription]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cluster_code_version': {'key': 'properties.clusterCodeVersion', 'type': 'str'},
        'cluster_upgrade_mode': {'key': 'properties.clusterUpgradeMode', 'type': 'str'},
        'cluster_upgrade_cadence': {'key': 'properties.clusterUpgradeCadence', 'type': 'str'},
        'addon_features': {'key': 'properties.addonFeatures', 'type': '[str]'},
        'enable_auto_os_upgrade': {'key': 'properties.enableAutoOSUpgrade', 'type': 'bool'},
        'zonal_resiliency': {'key': 'properties.zonalResiliency', 'type': 'bool'},
        'application_type_versions_cleanup_policy': {'key': 'properties.applicationTypeVersionsCleanupPolicy', 'type': 'ApplicationTypeVersionsCleanupPolicy'},
        'enable_ipv6': {'key': 'properties.enableIpv6', 'type': 'bool'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IPTag]'},
        'ipv6_address': {'key': 'properties.ipv6Address', 'type': 'str'},
        'enable_service_public_ip': {'key': 'properties.enableServicePublicIP', 'type': 'bool'},
        'auxiliary_subnets': {'key': 'properties.auxiliarySubnets', 'type': '[Subnet]'},
        'service_endpoints': {'key': 'properties.serviceEndpoints', 'type': '[ServiceEndpoint]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        dns_name: Optional[str] = None,
        client_connection_port: Optional[int] = 19000,
        http_gateway_connection_port: Optional[int] = 19080,
        admin_user_name: Optional[str] = None,
        admin_password: Optional[str] = None,
        load_balancing_rules: Optional[List["LoadBalancingRule"]] = None,
        allow_rdp_access: Optional[bool] = None,
        network_security_rules: Optional[List["NetworkSecurityRule"]] = None,
        clients: Optional[List["ClientCertificate"]] = None,
        azure_active_directory: Optional["AzureActiveDirectory"] = None,
        fabric_settings: Optional[List["SettingsSectionDescription"]] = None,
        cluster_code_version: Optional[str] = None,
        cluster_upgrade_mode: Optional[Union[str, "ClusterUpgradeMode"]] = "Automatic",
        cluster_upgrade_cadence: Optional[Union[str, "ClusterUpgradeCadence"]] = None,
        addon_features: Optional[List[Union[str, "ManagedClusterAddOnFeature"]]] = None,
        enable_auto_os_upgrade: Optional[bool] = None,
        zonal_resiliency: Optional[bool] = False,
        application_type_versions_cleanup_policy: Optional["ApplicationTypeVersionsCleanupPolicy"] = None,
        enable_ipv6: Optional[bool] = None,
        subnet_id: Optional[str] = None,
        ip_tags: Optional[List["IPTag"]] = None,
        enable_service_public_ip: Optional[bool] = None,
        auxiliary_subnets: Optional[List["Subnet"]] = None,
        service_endpoints: Optional[List["ServiceEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Azure resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the managed cluster.
        :paramtype sku: ~azure.mgmt.servicefabricmanagedclusters.models.Sku
        :keyword dns_name: The cluster dns name.
        :paramtype dns_name: str
        :keyword client_connection_port: The port used for client connections to the cluster.
        :paramtype client_connection_port: int
        :keyword http_gateway_connection_port: The port used for HTTP connections to the cluster.
        :paramtype http_gateway_connection_port: int
        :keyword admin_user_name: VM admin user name.
        :paramtype admin_user_name: str
        :keyword admin_password: VM admin user password.
        :paramtype admin_password: str
        :keyword load_balancing_rules: Load balancing rules that are applied to the public load
         balancer of the cluster.
        :paramtype load_balancing_rules:
         list[~azure.mgmt.servicefabricmanagedclusters.models.LoadBalancingRule]
        :keyword allow_rdp_access: Setting this to true enables RDP access to the VM. The default NSG
         rule opens RDP port to Internet which can be overridden with custom Network Security Rules. The
         default value for this setting is false.
        :paramtype allow_rdp_access: bool
        :keyword network_security_rules: Custom Network Security Rules that are applied to the Virtual
         Network of the cluster.
        :paramtype network_security_rules:
         list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
        :keyword clients: Client certificates that are allowed to manage the cluster.
        :paramtype clients: list[~azure.mgmt.servicefabricmanagedclusters.models.ClientCertificate]
        :keyword azure_active_directory: The AAD authentication settings of the cluster.
        :paramtype azure_active_directory:
         ~azure.mgmt.servicefabricmanagedclusters.models.AzureActiveDirectory
        :keyword fabric_settings: The list of custom fabric settings to configure the cluster.
        :paramtype fabric_settings:
         list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsSectionDescription]
        :keyword cluster_code_version: The Service Fabric runtime version of the cluster. This property
         is required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service
         Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To get the
         list of available version for existing clusters use **availableClusterVersions**.
        :paramtype cluster_code_version: str
        :keyword cluster_upgrade_mode: The upgrade mode of the cluster when new Service Fabric runtime
         version is available. Possible values include: "Automatic", "Manual". Default value:
         "Automatic".
        :paramtype cluster_upgrade_mode: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeMode
        :keyword cluster_upgrade_cadence: Indicates when new cluster runtime version upgrades will be
         applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode**
         is set to 'Automatic'. Possible values include: "Wave0", "Wave1", "Wave2".
        :paramtype cluster_upgrade_cadence: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeCadence
        :keyword addon_features: List of add-on features to enable on the cluster.
        :paramtype addon_features: list[str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ManagedClusterAddOnFeature]
        :keyword enable_auto_os_upgrade: Setting this to true enables automatic OS upgrade for the node
         types that are created using any platform OS image with version 'latest'. The default value for
         this setting is false.
        :paramtype enable_auto_os_upgrade: bool
        :keyword zonal_resiliency: Indicates if the cluster has zone resiliency.
        :paramtype zonal_resiliency: bool
        :keyword application_type_versions_cleanup_policy: The policy used to clean up unused versions.
        :paramtype application_type_versions_cleanup_policy:
         ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionsCleanupPolicy
        :keyword enable_ipv6: Setting this to true creates IPv6 address space for the default VNet used
         by the cluster. This setting cannot be changed once the cluster is created. The default value
         for this setting is false.
        :paramtype enable_ipv6: bool
        :keyword subnet_id: If specified, the node types for the cluster are created in this subnet
         instead of the default VNet. The **networkSecurityRules** specified for the cluster are also
         applied to this subnet. This setting cannot be changed once the cluster is created.
        :paramtype subnet_id: str
        :keyword ip_tags: The list of IP tags associated with the default public IP address of the
         cluster.
        :paramtype ip_tags: list[~azure.mgmt.servicefabricmanagedclusters.models.IPTag]
        :keyword enable_service_public_ip: Setting this to true will link the IPv4 address as the
         ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the
         cluster.
        :paramtype enable_service_public_ip: bool
        :keyword auxiliary_subnets: Auxiliary subnets for the cluster.
        :paramtype auxiliary_subnets: list[~azure.mgmt.servicefabricmanagedclusters.models.Subnet]
        :keyword service_endpoints: Service endpoints for subnets in the cluster.
        :paramtype service_endpoints:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceEndpoint]
        """
        super(ManagedCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.dns_name = dns_name
        self.fqdn = None
        self.ipv4_address = None
        self.cluster_id = None
        self.cluster_state = None
        self.cluster_certificate_thumbprints = None
        self.client_connection_port = client_connection_port
        self.http_gateway_connection_port = http_gateway_connection_port
        self.admin_user_name = admin_user_name
        self.admin_password = admin_password
        self.load_balancing_rules = load_balancing_rules
        self.allow_rdp_access = allow_rdp_access
        self.network_security_rules = network_security_rules
        self.clients = clients
        self.azure_active_directory = azure_active_directory
        self.fabric_settings = fabric_settings
        self.provisioning_state = None
        self.cluster_code_version = cluster_code_version
        self.cluster_upgrade_mode = cluster_upgrade_mode
        self.cluster_upgrade_cadence = cluster_upgrade_cadence
        self.addon_features = addon_features
        self.enable_auto_os_upgrade = enable_auto_os_upgrade
        self.zonal_resiliency = zonal_resiliency
        self.application_type_versions_cleanup_policy = application_type_versions_cleanup_policy
        self.enable_ipv6 = enable_ipv6
        self.subnet_id = subnet_id
        self.ip_tags = ip_tags
        self.ipv6_address = None
        self.enable_service_public_ip = enable_service_public_ip
        self.auxiliary_subnets = auxiliary_subnets
        self.service_endpoints = service_endpoints


class ManagedClusterCodeVersionResult(msrest.serialization.Model):
    """The result of the Service Fabric runtime versions.

    :ivar id: The identification of the result.
    :vartype id: str
    :ivar name: The name of the result.
    :vartype name: str
    :ivar type: The result resource type.
    :vartype type: str
    :ivar cluster_code_version: The Service Fabric runtime version of the cluster.
    :vartype cluster_code_version: str
    :ivar support_expiry_utc: The date of expiry of support of the version.
    :vartype support_expiry_utc: str
    :ivar os_type: Cluster operating system, the default will be Windows. Possible values include:
     "Windows".
    :vartype os_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.OsType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cluster_code_version': {'key': 'properties.clusterCodeVersion', 'type': 'str'},
        'support_expiry_utc': {'key': 'properties.supportExpiryUtc', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        cluster_code_version: Optional[str] = None,
        support_expiry_utc: Optional[str] = None,
        os_type: Optional[Union[str, "OsType"]] = None,
        **kwargs
    ):
        """
        :keyword id: The identification of the result.
        :paramtype id: str
        :keyword name: The name of the result.
        :paramtype name: str
        :keyword type: The result resource type.
        :paramtype type: str
        :keyword cluster_code_version: The Service Fabric runtime version of the cluster.
        :paramtype cluster_code_version: str
        :keyword support_expiry_utc: The date of expiry of support of the version.
        :paramtype support_expiry_utc: str
        :keyword os_type: Cluster operating system, the default will be Windows. Possible values
         include: "Windows".
        :paramtype os_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.OsType
        """
        super(ManagedClusterCodeVersionResult, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.cluster_code_version = cluster_code_version
        self.support_expiry_utc = support_expiry_utc
        self.os_type = os_type


class ManagedClusterListResult(msrest.serialization.Model):
    """Managed Cluster list results.

    :ivar value:
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ManagedCluster]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedCluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ManagedCluster]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(ManagedClusterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedClusterUpdateParameters(msrest.serialization.Model):
    """Managed cluster update request.

    :ivar tags: A set of tags. Managed cluster update parameters.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Managed cluster update parameters.
        :paramtype tags: dict[str, str]
        """
        super(ManagedClusterUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ManagedIdentity(msrest.serialization.Model):
    """Describes the managed identities for an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the managed identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the managed identity. This property will only be provided for
     a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity for the resource. Possible values include: "None",
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.servicefabricmanagedclusters.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ManagedIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of managed identity for the resource. Possible values include: "None",
         "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.servicefabricmanagedclusters.models.UserAssignedIdentity]
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedProxyResource(msrest.serialization.Model):
    """The resource model definition for proxy-only resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        """
        super(ManagedProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.system_data = None


class ManagedVMSize(msrest.serialization.Model):
    """Describes a VM Sizes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: VM Size properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.VMSize
    :ivar id: VM Size id.
    :vartype id: str
    :ivar name: VM Size name.
    :vartype name: str
    :ivar type: VM Size type.
    :vartype type: str
    """

    _validation = {
        'properties': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'VMSize'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ManagedVMSize, self).__init__(**kwargs)
        self.properties = None
        self.id = None
        self.name = None
        self.type = None


class ManagedVMSizesResult(msrest.serialization.Model):
    """Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Managed VM Sizes for Service Fabric Managed Clusters.
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ManagedVMSize]
    :ivar next_link: URL to get the next set of Managed VM Sizes if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedVMSize]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedVMSize"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of Managed VM Sizes for Service Fabric Managed Clusters.
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ManagedVMSize]
        """
        super(ManagedVMSizesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Partition(msrest.serialization.Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NamedPartitionScheme, SingletonPartitionScheme, UniformInt64RangePartitionScheme.

    All required parameters must be populated in order to send to Azure.

    :ivar partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server. Possible values include: "Singleton", "UniformInt64Range", "Named".
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    _subtype_map = {
        'partition_scheme': {'Named': 'NamedPartitionScheme', 'Singleton': 'SingletonPartitionScheme', 'UniformInt64Range': 'UniformInt64RangePartitionScheme'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Partition, self).__init__(**kwargs)
        self.partition_scheme = None  # type: Optional[str]


class NamedPartitionScheme(Partition):
    """Describes the named partition scheme of the service.

    All required parameters must be populated in order to send to Azure.

    :ivar partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server. Possible values include: "Singleton", "UniformInt64Range", "Named".
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PartitionScheme
    :ivar names: Required. Array for the names of the partitions.
    :vartype names: list[str]
    """

    _validation = {
        'partition_scheme': {'required': True},
        'names': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'names': {'key': 'names', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        names: List[str],
        **kwargs
    ):
        """
        :keyword names: Required. Array for the names of the partitions.
        :paramtype names: list[str]
        """
        super(NamedPartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'Named'  # type: str
        self.names = names


class NetworkSecurityRule(msrest.serialization.Model):
    """Describes a network security rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Network security rule name.
    :vartype name: str
    :ivar description: Network security rule description.
    :vartype description: str
    :ivar protocol: Required. Network protocol this rule applies to. Possible values include:
     "http", "https", "tcp", "udp", "icmp", "ah", "esp".
    :vartype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.NsgProtocol
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix. CIDR or destination IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: he destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar access: Required. The network traffic is allowed or denied. Possible values include:
     "allow", "deny".
    :vartype access: str or ~azure.mgmt.servicefabricmanagedclusters.models.Access
    :ivar priority: Required. The priority of the rule. The value can be in the range 1000 to 3000.
     Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The
     priority number must be unique for each rule in the collection. The lower the priority number,
     the higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Required. Network security rule direction. Possible values include: "inbound",
     "outbound".
    :vartype direction: str or ~azure.mgmt.servicefabricmanagedclusters.models.Direction
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'access': {'required': True},
        'priority': {'required': True, 'maximum': 3000, 'minimum': 1000},
        'direction': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "NsgProtocol"],
        access: Union[str, "Access"],
        priority: int,
        direction: Union[str, "Direction"],
        description: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Network security rule name.
        :paramtype name: str
        :keyword description: Network security rule description.
        :paramtype description: str
        :keyword protocol: Required. Network protocol this rule applies to. Possible values include:
         "http", "https", "tcp", "udp", "icmp", "ah", "esp".
        :paramtype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.NsgProtocol
        :keyword source_address_prefixes: The CIDR or source IP ranges.
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefixes: The destination address prefixes. CIDR or destination IP
         ranges.
        :paramtype destination_address_prefixes: list[str]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
         match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
         can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix. CIDR or destination IP
         range. Asterisk '*' can also be used to match all source IPs. Default tags such as
         'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :paramtype destination_address_prefix: str
        :keyword source_port_range: The source port or range. Integer or range between 0 and 65535.
         Asterisk '*' can also be used to match all ports.
        :paramtype source_port_range: str
        :keyword destination_port_range: he destination port or range. Integer or range between 0 and
         65535. Asterisk '*' can also be used to match all ports.
        :paramtype destination_port_range: str
        :keyword access: Required. The network traffic is allowed or denied. Possible values include:
         "allow", "deny".
        :paramtype access: str or ~azure.mgmt.servicefabricmanagedclusters.models.Access
        :keyword priority: Required. The priority of the rule. The value can be in the range 1000 to
         3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource
         Provider. The priority number must be unique for each rule in the collection. The lower the
         priority number, the higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Required. Network security rule direction. Possible values include:
         "inbound", "outbound".
        :paramtype direction: str or ~azure.mgmt.servicefabricmanagedclusters.models.Direction
        """
        super(NetworkSecurityRule, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocol = protocol
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.access = access
        self.priority = priority
        self.direction = direction


class NodeType(ManagedProxyResource):
    """Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar sku: The node type sku.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
    :ivar is_primary: Indicates the Service Fabric system services for the cluster will run on this
     node type. This setting cannot be changed once the node type is created.
    :vartype is_primary: bool
    :ivar vm_instance_count: The number of nodes in the node type. :code:`<br />`:code:`<br />`\
     **Values:** :code:`<br />`-1 - Use when auto scale rules are configured or sku.capacity is
     defined :code:`<br />` 0 - Not supported :code:`<br />` >0 - Use for manual scale.
    :vartype vm_instance_count: int
    :ivar data_disk_size_gb: Disk size for the managed disk attached to the vms on the node type in
     GBs.
    :vartype data_disk_size_gb: int
    :ivar data_disk_type: Managed data disk type. Specifies the storage account type for the
     managed disk. Possible values include: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS".
     Default value: "StandardSSD_LRS".
    :vartype data_disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
    :ivar data_disk_letter: Managed data disk letter. It can not use the reserved letter C or D and
     it can not change after created.
    :vartype data_disk_letter: str
    :ivar placement_properties: The placement tags applied to nodes in the node type, which can be
     used to indicate where certain services (workload) should run.
    :vartype placement_properties: dict[str, str]
    :ivar capacities: The capacity tags applied to the nodes in the node type, the cluster resource
     manager uses these tags to understand how much resource a node has.
    :vartype capacities: dict[str, str]
    :ivar application_ports: The range of ports from which cluster assigned port to Service Fabric
     applications.
    :vartype application_ports:
     ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
    :ivar ephemeral_ports: The range of ephemeral ports that nodes in this node type should be
     configured with.
    :vartype ephemeral_ports:
     ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
    :ivar vm_size: The size of virtual machines in the pool. All virtual machines in a pool are the
     same size. For example, Standard_D3.
    :vartype vm_size: str
    :ivar vm_image_publisher: The publisher of the Azure Virtual Machines Marketplace image. For
     example, Canonical or MicrosoftWindowsServer.
    :vartype vm_image_publisher: str
    :ivar vm_image_offer: The offer type of the Azure Virtual Machines Marketplace image. For
     example, UbuntuServer or WindowsServer.
    :vartype vm_image_offer: str
    :ivar vm_image_sku: The SKU of the Azure Virtual Machines Marketplace image. For example,
     14.04.0-LTS or 2012-R2-Datacenter.
    :vartype vm_image_sku: str
    :ivar vm_image_version: The version of the Azure Virtual Machines Marketplace image. A value of
     'latest' can be specified to select the latest version of an image. If omitted, the default is
     'latest'.
    :vartype vm_image_version: str
    :ivar vm_secrets: The secrets to install in the virtual machines.
    :vartype vm_secrets: list[~azure.mgmt.servicefabricmanagedclusters.models.VaultSecretGroup]
    :ivar vm_extensions: Set of extensions that should be installed onto the virtual machines.
    :vartype vm_extensions: list[~azure.mgmt.servicefabricmanagedclusters.models.VMSSExtension]
    :ivar vm_managed_identity: Identities to assign to the virtual machine scale set under the node
     type.
    :vartype vm_managed_identity: ~azure.mgmt.servicefabricmanagedclusters.models.VmManagedIdentity
    :ivar is_stateless: Indicates if the node type can only host Stateless workloads.
    :vartype is_stateless: bool
    :ivar multiple_placement_groups: Indicates if scale set associated with the node type can be
     composed of multiple placement groups.
    :vartype multiple_placement_groups: bool
    :ivar frontend_configurations: Indicates the node type uses its own frontend configurations
     instead of the default one for the cluster. This setting can only be specified for non-primary
     node types and can not be added or removed after the node type is created.
    :vartype frontend_configurations:
     list[~azure.mgmt.servicefabricmanagedclusters.models.FrontendConfiguration]
    :ivar network_security_rules: The Network Security Rules for this node type. This setting can
     only be specified for node types that are configured with frontend configurations.
    :vartype network_security_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
    :ivar additional_data_disks: Additional managed data disks.
    :vartype additional_data_disks:
     list[~azure.mgmt.servicefabricmanagedclusters.models.VmssDataDisk]
    :ivar enable_encryption_at_host: Enable or disable the Host Encryption for the virtual machines
     on the node type. This will enable the encryption for all the disks including Resource/Temp
     disk at host itself. Default: The Encryption at host will be disabled unless this property is
     set to true for the resource.
    :vartype enable_encryption_at_host: bool
    :ivar provisioning_state: The provisioning state of the node type resource. Possible values
     include: "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled",
     "Deleting", "Deleted", "Other".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedResourceProvisioningState
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar use_default_public_load_balancer: Specifies whether the use public load balancer. If not
     specified and the node type doesn't have its own frontend configuration, it will be attached to
     the default load balancer. If the node type uses its own Load balancer and
     useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If
     the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set,
     then the custom load balancer must include a public load balancer to provide outbound
     connectivity.
    :vartype use_default_public_load_balancer: bool
    :ivar use_temp_data_disk: Specifies whether to use the temporary disk for the service fabric
     data root, in which case no managed data disk will be attached and the temporary disk will be
     used. It is only allowed for stateless node types.
    :vartype use_temp_data_disk: bool
    :ivar enable_over_provisioning: Specifies whether the node type should be overprovisioned. It
     is only allowed for stateless node types.
    :vartype enable_over_provisioning: bool
    :ivar zones: Specifies the availability zones where the node type would span across. If the
     cluster is not spanning across availability zones, initiates az migration for the cluster.
    :vartype zones: list[str]
    :ivar is_spot_vm: Indicates whether the node type will be Spot Virtual Machines. Azure will
     allocate the VMs if there is capacity available and the VMs can be evicted at any time.
    :vartype is_spot_vm: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'vm_instance_count': {'maximum': 2147483647, 'minimum': -1},
        'data_disk_letter': {'pattern': r'^[a-zA-Z]{1}$'},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'NodeTypeSku'},
        'is_primary': {'key': 'properties.isPrimary', 'type': 'bool'},
        'vm_instance_count': {'key': 'properties.vmInstanceCount', 'type': 'int'},
        'data_disk_size_gb': {'key': 'properties.dataDiskSizeGB', 'type': 'int'},
        'data_disk_type': {'key': 'properties.dataDiskType', 'type': 'str'},
        'data_disk_letter': {'key': 'properties.dataDiskLetter', 'type': 'str'},
        'placement_properties': {'key': 'properties.placementProperties', 'type': '{str}'},
        'capacities': {'key': 'properties.capacities', 'type': '{str}'},
        'application_ports': {'key': 'properties.applicationPorts', 'type': 'EndpointRangeDescription'},
        'ephemeral_ports': {'key': 'properties.ephemeralPorts', 'type': 'EndpointRangeDescription'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'vm_image_publisher': {'key': 'properties.vmImagePublisher', 'type': 'str'},
        'vm_image_offer': {'key': 'properties.vmImageOffer', 'type': 'str'},
        'vm_image_sku': {'key': 'properties.vmImageSku', 'type': 'str'},
        'vm_image_version': {'key': 'properties.vmImageVersion', 'type': 'str'},
        'vm_secrets': {'key': 'properties.vmSecrets', 'type': '[VaultSecretGroup]'},
        'vm_extensions': {'key': 'properties.vmExtensions', 'type': '[VMSSExtension]'},
        'vm_managed_identity': {'key': 'properties.vmManagedIdentity', 'type': 'VmManagedIdentity'},
        'is_stateless': {'key': 'properties.isStateless', 'type': 'bool'},
        'multiple_placement_groups': {'key': 'properties.multiplePlacementGroups', 'type': 'bool'},
        'frontend_configurations': {'key': 'properties.frontendConfigurations', 'type': '[FrontendConfiguration]'},
        'network_security_rules': {'key': 'properties.networkSecurityRules', 'type': '[NetworkSecurityRule]'},
        'additional_data_disks': {'key': 'properties.additionalDataDisks', 'type': '[VmssDataDisk]'},
        'enable_encryption_at_host': {'key': 'properties.enableEncryptionAtHost', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'use_default_public_load_balancer': {'key': 'properties.useDefaultPublicLoadBalancer', 'type': 'bool'},
        'use_temp_data_disk': {'key': 'properties.useTempDataDisk', 'type': 'bool'},
        'enable_over_provisioning': {'key': 'properties.enableOverProvisioning', 'type': 'bool'},
        'zones': {'key': 'properties.zones', 'type': '[str]'},
        'is_spot_vm': {'key': 'properties.isSpotVM', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["NodeTypeSku"] = None,
        is_primary: Optional[bool] = None,
        vm_instance_count: Optional[int] = None,
        data_disk_size_gb: Optional[int] = None,
        data_disk_type: Optional[Union[str, "DiskType"]] = "StandardSSD_LRS",
        data_disk_letter: Optional[str] = None,
        placement_properties: Optional[Dict[str, str]] = None,
        capacities: Optional[Dict[str, str]] = None,
        application_ports: Optional["EndpointRangeDescription"] = None,
        ephemeral_ports: Optional["EndpointRangeDescription"] = None,
        vm_size: Optional[str] = None,
        vm_image_publisher: Optional[str] = None,
        vm_image_offer: Optional[str] = None,
        vm_image_sku: Optional[str] = None,
        vm_image_version: Optional[str] = None,
        vm_secrets: Optional[List["VaultSecretGroup"]] = None,
        vm_extensions: Optional[List["VMSSExtension"]] = None,
        vm_managed_identity: Optional["VmManagedIdentity"] = None,
        is_stateless: Optional[bool] = False,
        multiple_placement_groups: Optional[bool] = False,
        frontend_configurations: Optional[List["FrontendConfiguration"]] = None,
        network_security_rules: Optional[List["NetworkSecurityRule"]] = None,
        additional_data_disks: Optional[List["VmssDataDisk"]] = None,
        enable_encryption_at_host: Optional[bool] = False,
        enable_accelerated_networking: Optional[bool] = None,
        use_default_public_load_balancer: Optional[bool] = None,
        use_temp_data_disk: Optional[bool] = None,
        enable_over_provisioning: Optional[bool] = None,
        zones: Optional[List[str]] = None,
        is_spot_vm: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The node type sku.
        :paramtype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
        :keyword is_primary: Indicates the Service Fabric system services for the cluster will run on
         this node type. This setting cannot be changed once the node type is created.
        :paramtype is_primary: bool
        :keyword vm_instance_count: The number of nodes in the node type. :code:`<br />`:code:`<br />`\
         **Values:** :code:`<br />`-1 - Use when auto scale rules are configured or sku.capacity is
         defined :code:`<br />` 0 - Not supported :code:`<br />` >0 - Use for manual scale.
        :paramtype vm_instance_count: int
        :keyword data_disk_size_gb: Disk size for the managed disk attached to the vms on the node type
         in GBs.
        :paramtype data_disk_size_gb: int
        :keyword data_disk_type: Managed data disk type. Specifies the storage account type for the
         managed disk. Possible values include: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS".
         Default value: "StandardSSD_LRS".
        :paramtype data_disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
        :keyword data_disk_letter: Managed data disk letter. It can not use the reserved letter C or D
         and it can not change after created.
        :paramtype data_disk_letter: str
        :keyword placement_properties: The placement tags applied to nodes in the node type, which can
         be used to indicate where certain services (workload) should run.
        :paramtype placement_properties: dict[str, str]
        :keyword capacities: The capacity tags applied to the nodes in the node type, the cluster
         resource manager uses these tags to understand how much resource a node has.
        :paramtype capacities: dict[str, str]
        :keyword application_ports: The range of ports from which cluster assigned port to Service
         Fabric applications.
        :paramtype application_ports:
         ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
        :keyword ephemeral_ports: The range of ephemeral ports that nodes in this node type should be
         configured with.
        :paramtype ephemeral_ports:
         ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
        :keyword vm_size: The size of virtual machines in the pool. All virtual machines in a pool are
         the same size. For example, Standard_D3.
        :paramtype vm_size: str
        :keyword vm_image_publisher: The publisher of the Azure Virtual Machines Marketplace image. For
         example, Canonical or MicrosoftWindowsServer.
        :paramtype vm_image_publisher: str
        :keyword vm_image_offer: The offer type of the Azure Virtual Machines Marketplace image. For
         example, UbuntuServer or WindowsServer.
        :paramtype vm_image_offer: str
        :keyword vm_image_sku: The SKU of the Azure Virtual Machines Marketplace image. For example,
         14.04.0-LTS or 2012-R2-Datacenter.
        :paramtype vm_image_sku: str
        :keyword vm_image_version: The version of the Azure Virtual Machines Marketplace image. A value
         of 'latest' can be specified to select the latest version of an image. If omitted, the default
         is 'latest'.
        :paramtype vm_image_version: str
        :keyword vm_secrets: The secrets to install in the virtual machines.
        :paramtype vm_secrets: list[~azure.mgmt.servicefabricmanagedclusters.models.VaultSecretGroup]
        :keyword vm_extensions: Set of extensions that should be installed onto the virtual machines.
        :paramtype vm_extensions: list[~azure.mgmt.servicefabricmanagedclusters.models.VMSSExtension]
        :keyword vm_managed_identity: Identities to assign to the virtual machine scale set under the
         node type.
        :paramtype vm_managed_identity:
         ~azure.mgmt.servicefabricmanagedclusters.models.VmManagedIdentity
        :keyword is_stateless: Indicates if the node type can only host Stateless workloads.
        :paramtype is_stateless: bool
        :keyword multiple_placement_groups: Indicates if scale set associated with the node type can be
         composed of multiple placement groups.
        :paramtype multiple_placement_groups: bool
        :keyword frontend_configurations: Indicates the node type uses its own frontend configurations
         instead of the default one for the cluster. This setting can only be specified for non-primary
         node types and can not be added or removed after the node type is created.
        :paramtype frontend_configurations:
         list[~azure.mgmt.servicefabricmanagedclusters.models.FrontendConfiguration]
        :keyword network_security_rules: The Network Security Rules for this node type. This setting
         can only be specified for node types that are configured with frontend configurations.
        :paramtype network_security_rules:
         list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
        :keyword additional_data_disks: Additional managed data disks.
        :paramtype additional_data_disks:
         list[~azure.mgmt.servicefabricmanagedclusters.models.VmssDataDisk]
        :keyword enable_encryption_at_host: Enable or disable the Host Encryption for the virtual
         machines on the node type. This will enable the encryption for all the disks including
         Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this
         property is set to true for the resource.
        :paramtype enable_encryption_at_host: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword use_default_public_load_balancer: Specifies whether the use public load balancer. If
         not specified and the node type doesn't have its own frontend configuration, it will be
         attached to the default load balancer. If the node type uses its own Load balancer and
         useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If
         the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set,
         then the custom load balancer must include a public load balancer to provide outbound
         connectivity.
        :paramtype use_default_public_load_balancer: bool
        :keyword use_temp_data_disk: Specifies whether to use the temporary disk for the service fabric
         data root, in which case no managed data disk will be attached and the temporary disk will be
         used. It is only allowed for stateless node types.
        :paramtype use_temp_data_disk: bool
        :keyword enable_over_provisioning: Specifies whether the node type should be overprovisioned.
         It is only allowed for stateless node types.
        :paramtype enable_over_provisioning: bool
        :keyword zones: Specifies the availability zones where the node type would span across. If the
         cluster is not spanning across availability zones, initiates az migration for the cluster.
        :paramtype zones: list[str]
        :keyword is_spot_vm: Indicates whether the node type will be Spot Virtual Machines. Azure will
         allocate the VMs if there is capacity available and the VMs can be evicted at any time.
        :paramtype is_spot_vm: bool
        """
        super(NodeType, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.is_primary = is_primary
        self.vm_instance_count = vm_instance_count
        self.data_disk_size_gb = data_disk_size_gb
        self.data_disk_type = data_disk_type
        self.data_disk_letter = data_disk_letter
        self.placement_properties = placement_properties
        self.capacities = capacities
        self.application_ports = application_ports
        self.ephemeral_ports = ephemeral_ports
        self.vm_size = vm_size
        self.vm_image_publisher = vm_image_publisher
        self.vm_image_offer = vm_image_offer
        self.vm_image_sku = vm_image_sku
        self.vm_image_version = vm_image_version
        self.vm_secrets = vm_secrets
        self.vm_extensions = vm_extensions
        self.vm_managed_identity = vm_managed_identity
        self.is_stateless = is_stateless
        self.multiple_placement_groups = multiple_placement_groups
        self.frontend_configurations = frontend_configurations
        self.network_security_rules = network_security_rules
        self.additional_data_disks = additional_data_disks
        self.enable_encryption_at_host = enable_encryption_at_host
        self.provisioning_state = None
        self.enable_accelerated_networking = enable_accelerated_networking
        self.use_default_public_load_balancer = use_default_public_load_balancer
        self.use_temp_data_disk = use_temp_data_disk
        self.enable_over_provisioning = enable_over_provisioning
        self.zones = zones
        self.is_spot_vm = is_spot_vm


class NodeTypeActionParameters(msrest.serialization.Model):
    """Parameters for Node type action.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes: Required. List of node names from the node type.
    :vartype nodes: list[str]
    :ivar force: Force the action to go through.
    :vartype force: bool
    """

    _validation = {
        'nodes': {'required': True},
    }

    _attribute_map = {
        'nodes': {'key': 'nodes', 'type': '[str]'},
        'force': {'key': 'force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        nodes: List[str],
        force: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword nodes: Required. List of node names from the node type.
        :paramtype nodes: list[str]
        :keyword force: Force the action to go through.
        :paramtype force: bool
        """
        super(NodeTypeActionParameters, self).__init__(**kwargs)
        self.nodes = nodes
        self.force = force


class NodeTypeAvailableSku(msrest.serialization.Model):
    """Defines the type of sku available for a node type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.  :code:`<br />`:code:`<br
     />`Value: Microsoft.ServiceFabric/managedClusters/nodeTypes.
    :vartype resource_type: str
    :ivar sku: The supported SKU for a for node type.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSupportedSku
    :ivar capacity: Provides information about how the node count can be scaled.
    :vartype capacity: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'NodeTypeSupportedSku'},
        'capacity': {'key': 'capacity', 'type': 'NodeTypeSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NodeTypeAvailableSku, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class NodeTypeListResult(msrest.serialization.Model):
    """Node type list results.

    :ivar value: The list of node types.
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.NodeType]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NodeType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NodeType"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of node types.
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.NodeType]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(NodeTypeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NodeTypeListSkuResult(msrest.serialization.Model):
    """Node type available sku list results.

    :ivar value: The list of available node type SKUs.
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeAvailableSku]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NodeTypeAvailableSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NodeTypeAvailableSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of available node type SKUs.
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeAvailableSku]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(NodeTypeListSkuResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NodeTypeSku(msrest.serialization.Model):
    """Describes a node type sku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The sku name. :code:`<br />`:code:`<br />`Name is internally generated and is used
     in auto-scale scenarios.:code:`<br />` Property does not allow to be changed to other values
     than generated.:code:`<br />` To avoid deployment errors please omit the property.
    :vartype name: str
    :ivar tier: Specifies the tier of the node type. :code:`<br />`:code:`<br />` Possible
     Values::code:`<br />` **Standard**.
    :vartype tier: str
    :ivar capacity: Required. The number of nodes in the node type.:code:`<br />`:code:`<br />`If
     present in request it will override properties.vmInstanceCount.
    :vartype capacity: int
    """

    _validation = {
        'capacity': {'required': True, 'maximum': 2147483647, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        capacity: int,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The sku name. :code:`<br />`:code:`<br />`Name is internally generated and is
         used in auto-scale scenarios.:code:`<br />` Property does not allow to be changed to other
         values than generated.:code:`<br />` To avoid deployment errors please omit the property.
        :paramtype name: str
        :keyword tier: Specifies the tier of the node type. :code:`<br />`:code:`<br />` Possible
         Values::code:`<br />` **Standard**.
        :paramtype tier: str
        :keyword capacity: Required. The number of nodes in the node type.:code:`<br />`:code:`<br
         />`If present in request it will override properties.vmInstanceCount.
        :paramtype capacity: int
        """
        super(NodeTypeSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class NodeTypeSkuCapacity(msrest.serialization.Model):
    """Provides information about how node type can be scaled.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: Lowest permitted node count in a node type.
    :vartype minimum: int
    :ivar maximum: Highest permitted node count in a node type.
    :vartype maximum: int
    :ivar default: Default node count in a node type.
    :vartype default: int
    :ivar scale_type: Node type capacity scale type. Possible values include: "None", "Manual",
     "Automatic". Default value: "None".
    :vartype scale_type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSkuScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NodeTypeSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class NodeTypeSupportedSku(msrest.serialization.Model):
    """Describes a node type supported sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of the node type. :code:`<br />`:code:`<br />` Possible
     Values::code:`<br />` **Standard**.
    :vartype tier: str
    """

    _validation = {
        'name': {'readonly': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NodeTypeSupportedSku, self).__init__(**kwargs)
        self.name = None
        self.tier = None


class NodeTypeUpdateParameters(msrest.serialization.Model):
    """Node type update request.

    :ivar tags: A set of tags. Node type update parameters.
    :vartype tags: dict[str, str]
    :ivar sku: The node type sku.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'NodeTypeSku'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["NodeTypeSku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Node type update parameters.
        :paramtype tags: dict[str, str]
        :keyword sku: The node type sku.
        :paramtype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
        """
        super(NodeTypeUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class OperationListResult(msrest.serialization.Model):
    """Describes the result of the request to list Service Fabric resource provider operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the Service Fabric resource provider.
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationResult"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of operations supported by the Service Fabric resource provider.
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.OperationResult]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OperationResult(msrest.serialization.Model):
    """Available operation list result.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.servicefabricmanagedclusters.models.AvailableOperationDisplay
    :ivar origin: Origin result.
    :vartype origin: str
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'AvailableOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["AvailableOperationDisplay"] = None,
        origin: Optional[str] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.servicefabricmanagedclusters.models.AvailableOperationDisplay
        :keyword origin: Origin result.
        :paramtype origin: str
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(OperationResult, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.next_link = next_link


class PartitionInstanceCountScaleMechanism(ScalingMechanism):
    """Represents a scaling mechanism for adding or removing instances of stateless service partition.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server. Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingMechanismKind
    :ivar min_instance_count: Required. Minimum number of instances of the partition.
    :vartype min_instance_count: int
    :ivar max_instance_count: Required. Maximum number of instances of the partition.
    :vartype max_instance_count: int
    :ivar scale_increment: Required. The number of instances to add or remove during a scaling
     operation.
    :vartype scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_instance_count': {'required': True},
        'max_instance_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
        'scale_increment': {'key': 'scaleIncrement', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_instance_count: int,
        max_instance_count: int,
        scale_increment: int,
        **kwargs
    ):
        """
        :keyword min_instance_count: Required. Minimum number of instances of the partition.
        :paramtype min_instance_count: int
        :keyword max_instance_count: Required. Maximum number of instances of the partition.
        :paramtype max_instance_count: int
        :keyword scale_increment: Required. The number of instances to add or remove during a scaling
         operation.
        :paramtype scale_increment: int
        """
        super(PartitionInstanceCountScaleMechanism, self).__init__(**kwargs)
        self.kind = 'ScalePartitionInstanceCount'  # type: str
        self.min_instance_count = min_instance_count
        self.max_instance_count = max_instance_count
        self.scale_increment = scale_increment


class ResourceAzStatus(msrest.serialization.Model):
    """Describes Az Resiliency status of Base resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_name: VM Size properties.
    :vartype resource_name: str
    :ivar resource_type: VM Size id.
    :vartype resource_type: str
    :ivar is_zone_resilient: VM Size name.
    :vartype is_zone_resilient: bool
    """

    _validation = {
        'resource_name': {'readonly': True},
        'resource_type': {'readonly': True},
        'is_zone_resilient': {'readonly': True},
    }

    _attribute_map = {
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'is_zone_resilient': {'key': 'isZoneResilient', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceAzStatus, self).__init__(**kwargs)
        self.resource_name = None
        self.resource_type = None
        self.is_zone_resilient = None


class RollingUpgradeMonitoringPolicy(msrest.serialization.Model):
    """The policy used for monitoring the application upgrade.

    All required parameters must be populated in order to send to Azure.

    :ivar failure_action: Required. The compensating action to perform when a Monitored upgrade
     encounters monitoring policy or health policy violations. Invalid indicates the failure action
     is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual
     indicates that the upgrade will switch to UnmonitoredManual upgrade mode. Possible values
     include: "Rollback", "Manual".
    :vartype failure_action: str or ~azure.mgmt.servicefabricmanagedclusters.models.FailureAction
    :ivar health_check_wait_duration: Required. The amount of time to wait after completing an
     upgrade domain before applying health policies. It is interpreted as a string representing an
     ISO 8601 duration with following format "hh:mm:ss.fff".
    :vartype health_check_wait_duration: str
    :ivar health_check_stable_duration: Required. The amount of time that the application or
     cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is
     interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :vartype health_check_stable_duration: str
    :ivar health_check_retry_timeout: Required. The amount of time to retry health evaluation when
     the application or cluster is unhealthy before FailureAction is executed. It is interpreted as
     a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :vartype health_check_retry_timeout: str
    :ivar upgrade_timeout: Required. The amount of time the overall upgrade has to complete before
     FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :vartype upgrade_timeout: str
    :ivar upgrade_domain_timeout: Required. The amount of time each upgrade domain has to complete
     before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :vartype upgrade_domain_timeout: str
    """

    _validation = {
        'failure_action': {'required': True},
        'health_check_wait_duration': {'required': True},
        'health_check_stable_duration': {'required': True},
        'health_check_retry_timeout': {'required': True},
        'upgrade_timeout': {'required': True},
        'upgrade_domain_timeout': {'required': True},
    }

    _attribute_map = {
        'failure_action': {'key': 'failureAction', 'type': 'str'},
        'health_check_wait_duration': {'key': 'healthCheckWaitDuration', 'type': 'str'},
        'health_check_stable_duration': {'key': 'healthCheckStableDuration', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'healthCheckRetryTimeout', 'type': 'str'},
        'upgrade_timeout': {'key': 'upgradeTimeout', 'type': 'str'},
        'upgrade_domain_timeout': {'key': 'upgradeDomainTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failure_action: Union[str, "FailureAction"],
        health_check_wait_duration: str,
        health_check_stable_duration: str,
        health_check_retry_timeout: str,
        upgrade_timeout: str,
        upgrade_domain_timeout: str,
        **kwargs
    ):
        """
        :keyword failure_action: Required. The compensating action to perform when a Monitored upgrade
         encounters monitoring policy or health policy violations. Invalid indicates the failure action
         is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual
         indicates that the upgrade will switch to UnmonitoredManual upgrade mode. Possible values
         include: "Rollback", "Manual".
        :paramtype failure_action: str or ~azure.mgmt.servicefabricmanagedclusters.models.FailureAction
        :keyword health_check_wait_duration: Required. The amount of time to wait after completing an
         upgrade domain before applying health policies. It is interpreted as a string representing an
         ISO 8601 duration with following format "hh:mm:ss.fff".
        :paramtype health_check_wait_duration: str
        :keyword health_check_stable_duration: Required. The amount of time that the application or
         cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is
         interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :paramtype health_check_stable_duration: str
        :keyword health_check_retry_timeout: Required. The amount of time to retry health evaluation
         when the application or cluster is unhealthy before FailureAction is executed. It is
         interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :paramtype health_check_retry_timeout: str
        :keyword upgrade_timeout: Required. The amount of time the overall upgrade has to complete
         before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
         representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :paramtype upgrade_timeout: str
        :keyword upgrade_domain_timeout: Required. The amount of time each upgrade domain has to
         complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as
         a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
        :paramtype upgrade_domain_timeout: str
        """
        super(RollingUpgradeMonitoringPolicy, self).__init__(**kwargs)
        self.failure_action = failure_action
        self.health_check_wait_duration = health_check_wait_duration
        self.health_check_stable_duration = health_check_stable_duration
        self.health_check_retry_timeout = health_check_retry_timeout
        self.upgrade_timeout = upgrade_timeout
        self.upgrade_domain_timeout = upgrade_domain_timeout


class ScalingPolicy(msrest.serialization.Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :ivar scaling_mechanism: Required. Specifies the mechanism associated with this scaling policy.
    :vartype scaling_mechanism: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingMechanism
    :ivar scaling_trigger: Required. Specifies the trigger associated with this scaling policy.
    :vartype scaling_trigger: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingTrigger
    """

    _validation = {
        'scaling_mechanism': {'required': True},
        'scaling_trigger': {'required': True},
    }

    _attribute_map = {
        'scaling_mechanism': {'key': 'scalingMechanism', 'type': 'ScalingMechanism'},
        'scaling_trigger': {'key': 'scalingTrigger', 'type': 'ScalingTrigger'},
    }

    def __init__(
        self,
        *,
        scaling_mechanism: "ScalingMechanism",
        scaling_trigger: "ScalingTrigger",
        **kwargs
    ):
        """
        :keyword scaling_mechanism: Required. Specifies the mechanism associated with this scaling
         policy.
        :paramtype scaling_mechanism: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingMechanism
        :keyword scaling_trigger: Required. Specifies the trigger associated with this scaling policy.
        :paramtype scaling_trigger: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingTrigger
        """
        super(ScalingPolicy, self).__init__(**kwargs)
        self.scaling_mechanism = scaling_mechanism
        self.scaling_trigger = scaling_trigger


class ServiceCorrelation(msrest.serialization.Model):
    """Creates a particular correlation between services.

    All required parameters must be populated in order to send to Azure.

    :ivar scheme: Required. The ServiceCorrelationScheme which describes the relationship between
     this service and the service specified via ServiceName. Possible values include:
     "AlignedAffinity", "NonAlignedAffinity".
    :vartype scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelationScheme
    :ivar service_name: Required. The Arm Resource ID of the service that the correlation
     relationship is established with.
    :vartype service_name: str
    """

    _validation = {
        'scheme': {'required': True},
        'service_name': {'required': True},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scheme: Union[str, "ServiceCorrelationScheme"],
        service_name: str,
        **kwargs
    ):
        """
        :keyword scheme: Required. The ServiceCorrelationScheme which describes the relationship
         between this service and the service specified via ServiceName. Possible values include:
         "AlignedAffinity", "NonAlignedAffinity".
        :paramtype scheme: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelationScheme
        :keyword service_name: Required. The Arm Resource ID of the service that the correlation
         relationship is established with.
        :paramtype service_name: str
        """
        super(ServiceCorrelation, self).__init__(**kwargs)
        self.scheme = scheme
        self.service_name = service_name


class ServiceEndpoint(msrest.serialization.Model):
    """The service endpoint properties.

    All required parameters must be populated in order to send to Azure.

    :ivar service: Required. The type of the endpoint service.
    :vartype service: str
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    """

    _validation = {
        'service': {'required': True},
    }

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        service: str,
        locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword service: Required. The type of the endpoint service.
        :paramtype service: str
        :keyword locations: A list of locations.
        :paramtype locations: list[str]
        """
        super(ServiceEndpoint, self).__init__(**kwargs)
        self.service = service
        self.locations = locations


class ServiceLoadMetric(msrest.serialization.Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the metric. If the service chooses to report load during
     runtime, the load metric name should match the name that is specified in Name exactly. Note
     that metric names are case sensitive.
    :vartype name: str
    :ivar weight: The service load metric relative weight, compared to other metrics configured for
     this service, as a number. Possible values include: "Zero", "Low", "Medium", "High".
    :vartype weight: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetricWeight
    :ivar primary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Primary replica.
    :vartype primary_default_load: int
    :ivar secondary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Secondary replica.
    :vartype secondary_default_load: int
    :ivar default_load: Used only for Stateless services. The default amount of load, as a number,
     that this service creates for this metric.
    :vartype default_load: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'str'},
        'primary_default_load': {'key': 'primaryDefaultLoad', 'type': 'int'},
        'secondary_default_load': {'key': 'secondaryDefaultLoad', 'type': 'int'},
        'default_load': {'key': 'defaultLoad', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        weight: Optional[Union[str, "ServiceLoadMetricWeight"]] = None,
        primary_default_load: Optional[int] = None,
        secondary_default_load: Optional[int] = None,
        default_load: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the metric. If the service chooses to report load during
         runtime, the load metric name should match the name that is specified in Name exactly. Note
         that metric names are case sensitive.
        :paramtype name: str
        :keyword weight: The service load metric relative weight, compared to other metrics configured
         for this service, as a number. Possible values include: "Zero", "Low", "Medium", "High".
        :paramtype weight: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetricWeight
        :keyword primary_default_load: Used only for Stateful services. The default amount of load, as
         a number, that this service creates for this metric when it is a Primary replica.
        :paramtype primary_default_load: int
        :keyword secondary_default_load: Used only for Stateful services. The default amount of load,
         as a number, that this service creates for this metric when it is a Secondary replica.
        :paramtype secondary_default_load: int
        :keyword default_load: Used only for Stateless services. The default amount of load, as a
         number, that this service creates for this metric.
        :paramtype default_load: int
        """
        super(ServiceLoadMetric, self).__init__(**kwargs)
        self.name = name
        self.weight = weight
        self.primary_default_load = primary_default_load
        self.secondary_default_load = secondary_default_load
        self.default_load = default_load


class ServicePlacementPolicy(msrest.serialization.Model):
    """Describes the policy to be used for placement of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServicePlacementInvalidDomainPolicy, ServicePlacementNonPartiallyPlaceServicePolicy, ServicePlacementPreferPrimaryDomainPolicy, ServicePlacementRequiredDomainPolicy, ServicePlacementRequireDomainDistributionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'InvalidDomain': 'ServicePlacementInvalidDomainPolicy', 'NonPartiallyPlaceService': 'ServicePlacementNonPartiallyPlaceServicePolicy', 'PreferredPrimaryDomain': 'ServicePlacementPreferPrimaryDomainPolicy', 'RequiredDomain': 'ServicePlacementRequiredDomainPolicy', 'RequiredDomainDistribution': 'ServicePlacementRequireDomainDistributionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServicePlacementPolicy, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ServicePlacementInvalidDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    :ivar domain_name: Required. The name of the domain that should not be used for placement.
    :vartype domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        """
        :keyword domain_name: Required. The name of the domain that should not be used for placement.
        :paramtype domain_name: str
        """
        super(ServicePlacementInvalidDomainPolicy, self).__init__(**kwargs)
        self.type = 'InvalidDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementNonPartiallyPlaceServicePolicy(ServicePlacementPolicy):
    """ServicePlacementNonPartiallyPlaceServicePolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServicePlacementNonPartiallyPlaceServicePolicy, self).__init__(**kwargs)
        self.type = 'NonPartiallyPlaceService'  # type: str


class ServicePlacementPreferPrimaryDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where the service's 
Primary replicas should optimally be placed in a particular domain.

This placement policy is usually used with fault domains in scenarios where the Service Fabric
cluster is geographically distributed in order to indicate that a service's primary replica should
be located in a particular fault domain, which in geo-distributed scenarios usually aligns with regional
or datacenter boundaries. Note that since this is an optimization it is possible that the Primary replica
may not end up located in this domain due to failures, capacity limits, or other constraints.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    :ivar domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :vartype domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        """
        :keyword domain_name: Required. The name of the domain that should used for placement as per
         this policy.
        :paramtype domain_name: str
        """
        super(ServicePlacementPreferPrimaryDomainPolicy, self).__init__(**kwargs)
        self.type = 'PreferredPrimaryDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementRequiredDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where the instances or replicas of that service must be placed in a particular domain.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    :ivar domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :vartype domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        """
        :keyword domain_name: Required. The name of the domain that should used for placement as per
         this policy.
        :paramtype domain_name: str
        """
        super(ServicePlacementRequiredDomainPolicy, self).__init__(**kwargs)
        self.type = 'RequiredDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementRequireDomainDistributionPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where two replicas
from the same partition should never be placed in the same fault or upgrade domain.

While this is not common it can expose the service to an increased risk of concurrent failures
due to unplanned outages or other cases of subsequent/concurrent failures. As an example, consider
a case where replicas are deployed across different data center, with one replica per location.
In the event that one of the datacenters goes offline, normally the replica that was placed in that
datacenter will be packed into one of the remaining datacenters. If this is not desirable then this
policy should be set.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server. Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    :ivar domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :vartype domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        """
        :keyword domain_name: Required. The name of the domain that should used for placement as per
         this policy.
        :paramtype domain_name: str
        """
        super(ServicePlacementRequireDomainDistributionPolicy, self).__init__(**kwargs)
        self.type = 'RequiredDomainDistribution'  # type: str
        self.domain_name = domain_name


class ServiceResource(ProxyResource):
    """The service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location depends on the parent resource.
    :vartype location: str
    :ivar tags: A set of tags. Azure resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The service resource properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.ServiceResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ServiceResourceProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ServiceResourceProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location depends on the parent resource.
        :paramtype location: str
        :keyword tags: A set of tags. Azure resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The service resource properties.
        :paramtype properties:
         ~azure.mgmt.servicefabricmanagedclusters.models.ServiceResourceProperties
        """
        super(ServiceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ServiceResourceList(msrest.serialization.Model):
    """The list of service resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceResource]
    :ivar next_link: URL to get the next set of service list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServiceResource"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceResource]
        """
        super(ServiceResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceResourcePropertiesBase(msrest.serialization.Model):
    """The common service resource properties.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    """

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
    }

    def __init__(
        self,
        *,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword placement_constraints: The placement constraints as a string. Placement constraints
         are boolean expressions on node properties and allow for restricting a service to particular
         nodes based on the service requirements. For example, to place a service on nodes where
         NodeType is blue specify the following: "NodeColor == blue)".
        :paramtype placement_constraints: str
        :keyword correlation_scheme: A list that describes the correlation of the service with other
         services.
        :paramtype correlation_scheme:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
        :keyword service_load_metrics: The service load metrics is given as an array of
         ServiceLoadMetric objects.
        :paramtype service_load_metrics:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
        :keyword service_placement_policies: A list that describes the correlation of the service with
         other services.
        :paramtype service_placement_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
        :keyword default_move_cost: Specifies the move cost for the service. Possible values include:
         "Zero", "Low", "Medium", "High".
        :paramtype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
        :keyword scaling_policies: Scaling policies for this service.
        :paramtype scaling_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
        """
        super(ServiceResourcePropertiesBase, self).__init__(**kwargs)
        self.placement_constraints = placement_constraints
        self.correlation_scheme = correlation_scheme
        self.service_load_metrics = service_load_metrics
        self.service_placement_policies = service_placement_policies
        self.default_move_cost = default_move_cost
        self.scaling_policies = scaling_policies


class ServiceResourceProperties(ServiceResourcePropertiesBase):
    """The service resource properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceProperties, StatelessServiceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server. Possible values include: "Stateless", "Stateful".
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceKind
    :ivar service_type_name: Required. The name of the service type.
    :vartype service_type_name: str
    :ivar partition_description: Required. Describes how the service is partitioned.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceProperties', 'Stateless': 'StatelessServiceProperties'}
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        **kwargs
    ):
        """
        :keyword placement_constraints: The placement constraints as a string. Placement constraints
         are boolean expressions on node properties and allow for restricting a service to particular
         nodes based on the service requirements. For example, to place a service on nodes where
         NodeType is blue specify the following: "NodeColor == blue)".
        :paramtype placement_constraints: str
        :keyword correlation_scheme: A list that describes the correlation of the service with other
         services.
        :paramtype correlation_scheme:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
        :keyword service_load_metrics: The service load metrics is given as an array of
         ServiceLoadMetric objects.
        :paramtype service_load_metrics:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
        :keyword service_placement_policies: A list that describes the correlation of the service with
         other services.
        :paramtype service_placement_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
        :keyword default_move_cost: Specifies the move cost for the service. Possible values include:
         "Zero", "Low", "Medium", "High".
        :paramtype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
        :keyword scaling_policies: Scaling policies for this service.
        :paramtype scaling_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
        :keyword service_type_name: Required. The name of the service type.
        :paramtype service_type_name: str
        :keyword partition_description: Required. Describes how the service is partitioned.
        :paramtype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
        :keyword service_package_activation_mode: The activation Mode of the service package. Possible
         values include: "SharedProcess", "ExclusiveProcess".
        :paramtype service_package_activation_mode: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
        """
        super(ServiceResourceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, **kwargs)
        self.provisioning_state = None
        self.service_kind = 'ServiceResourceProperties'  # type: str
        self.service_type_name = service_type_name
        self.partition_description = partition_description
        self.service_package_activation_mode = service_package_activation_mode


class ServiceTypeHealthPolicy(msrest.serialization.Model):
    """Represents the health policy used to evaluate the health of services belonging to a service type.

    All required parameters must be populated in order to send to Azure.

    :ivar max_percent_unhealthy_services: Required. The maximum allowed percentage of unhealthy
     services.
    
     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services.
    :vartype max_percent_unhealthy_services: int
    :ivar max_percent_unhealthy_partitions_per_service: Required. The maximum allowed percentage of
     unhealthy partitions per service.
    
     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions.
    :vartype max_percent_unhealthy_partitions_per_service: int
    :ivar max_percent_unhealthy_replicas_per_partition: Required. The maximum allowed percentage of
     unhealthy replicas per partition.
    
     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total
     number of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas.
    :vartype max_percent_unhealthy_replicas_per_partition: int
    """

    _validation = {
        'max_percent_unhealthy_services': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_partitions_per_service': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_replicas_per_partition': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_unhealthy_services': {'key': 'maxPercentUnhealthyServices', 'type': 'int'},
        'max_percent_unhealthy_partitions_per_service': {'key': 'maxPercentUnhealthyPartitionsPerService', 'type': 'int'},
        'max_percent_unhealthy_replicas_per_partition': {'key': 'maxPercentUnhealthyReplicasPerPartition', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_percent_unhealthy_services: int,
        max_percent_unhealthy_partitions_per_service: int,
        max_percent_unhealthy_replicas_per_partition: int,
        **kwargs
    ):
        """
        :keyword max_percent_unhealthy_services: Required. The maximum allowed percentage of unhealthy
         services.
        
         The percentage represents the maximum tolerated percentage of services that can be unhealthy
         before the application is considered in error.
         If the percentage is respected but there is at least one unhealthy service, the health is
         evaluated as Warning.
         This is calculated by dividing the number of unhealthy services of the specific service type
         over the total number of services of the specific service type.
         The computation rounds up to tolerate one failure on small numbers of services.
        :paramtype max_percent_unhealthy_services: int
        :keyword max_percent_unhealthy_partitions_per_service: Required. The maximum allowed percentage
         of unhealthy partitions per service.
        
         The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
         before the service is considered in error.
         If the percentage is respected but there is at least one unhealthy partition, the health is
         evaluated as Warning.
         The percentage is calculated by dividing the number of unhealthy partitions over the total
         number of partitions in the service.
         The computation rounds up to tolerate one failure on small numbers of partitions.
        :paramtype max_percent_unhealthy_partitions_per_service: int
        :keyword max_percent_unhealthy_replicas_per_partition: Required. The maximum allowed percentage
         of unhealthy replicas per partition.
        
         The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
         before the partition is considered in error.
         If the percentage is respected but there is at least one unhealthy replica, the health is
         evaluated as Warning.
         The percentage is calculated by dividing the number of unhealthy replicas over the total
         number of replicas in the partition.
         The computation rounds up to tolerate one failure on small numbers of replicas.
        :paramtype max_percent_unhealthy_replicas_per_partition: int
        """
        super(ServiceTypeHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_services = max_percent_unhealthy_services
        self.max_percent_unhealthy_partitions_per_service = max_percent_unhealthy_partitions_per_service
        self.max_percent_unhealthy_replicas_per_partition = max_percent_unhealthy_replicas_per_partition


class ServiceUpdateParameters(msrest.serialization.Model):
    """Service update request.

    :ivar tags: A set of tags. Service update parameters.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Service update parameters.
        :paramtype tags: dict[str, str]
        """
        super(ServiceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class SettingsParameterDescription(msrest.serialization.Model):
    """Describes a parameter in fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The parameter name of fabric setting.
    :vartype name: str
    :ivar value: Required. The parameter value of fabric setting.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. The parameter name of fabric setting.
        :paramtype name: str
        :keyword value: Required. The parameter value of fabric setting.
        :paramtype value: str
        """
        super(SettingsParameterDescription, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SettingsSectionDescription(msrest.serialization.Model):
    """Describes a section in the fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The section name of the fabric settings.
    :vartype name: str
    :ivar parameters: Required. The collection of parameters in the section.
    :vartype parameters:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsParameterDescription]
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[SettingsParameterDescription]'},
    }

    def __init__(
        self,
        *,
        name: str,
        parameters: List["SettingsParameterDescription"],
        **kwargs
    ):
        """
        :keyword name: Required. The section name of the fabric settings.
        :paramtype name: str
        :keyword parameters: Required. The collection of parameters in the section.
        :paramtype parameters:
         list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsParameterDescription]
        """
        super(SettingsSectionDescription, self).__init__(**kwargs)
        self.name = name
        self.parameters = parameters


class SingletonPartitionScheme(Partition):
    """SingletonPartitionScheme.

    All required parameters must be populated in order to send to Azure.

    :ivar partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server. Possible values include: "Singleton", "UniformInt64Range", "Named".
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SingletonPartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'Singleton'  # type: str


class Sku(msrest.serialization.Model):
    """Service Fabric managed cluster Sku definition.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Sku Name. Possible values include: "Basic", "Standard".
    :vartype name: str or ~azure.mgmt.servicefabricmanagedclusters.models.SkuName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        **kwargs
    ):
        """
        :keyword name: Required. Sku Name. Possible values include: "Basic", "Standard".
        :paramtype name: str or ~azure.mgmt.servicefabricmanagedclusters.models.SkuName
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name


class StatefulServiceProperties(ServiceResourceProperties):
    """The properties of a stateful service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server. Possible values include: "Stateless", "Stateful".
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceKind
    :ivar service_type_name: Required. The name of the service type.
    :vartype service_type_name: str
    :ivar partition_description: Required. Describes how the service is partitioned.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    :ivar has_persisted_state: A flag indicating whether this is a persistent service which stores
     states on the local disk. If it is then the value of this property is true, if not it is false.
    :vartype has_persisted_state: bool
    :ivar target_replica_set_size: The target replica set size as a number.
    :vartype target_replica_set_size: int
    :ivar min_replica_set_size: The minimum replica set size as a number.
    :vartype min_replica_set_size: int
    :ivar replica_restart_wait_duration: The duration between when a replica goes down and when a
     new replica is created, represented in ISO 8601 format "hh:mm:ss".
    :vartype replica_restart_wait_duration: str
    :ivar quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be in
     a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
    :vartype quorum_loss_wait_duration: str
    :ivar stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
     maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
    :vartype stand_by_replica_keep_duration: str
    :ivar service_placement_time_limit: The duration for which replicas can stay InBuild before
     reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
    :vartype service_placement_time_limit: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'target_replica_set_size': {'minimum': 1},
        'min_replica_set_size': {'minimum': 1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'has_persisted_state': {'key': 'hasPersistedState', 'type': 'bool'},
        'target_replica_set_size': {'key': 'targetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'minReplicaSetSize', 'type': 'int'},
        'replica_restart_wait_duration': {'key': 'replicaRestartWaitDuration', 'type': 'str'},
        'quorum_loss_wait_duration': {'key': 'quorumLossWaitDuration', 'type': 'str'},
        'stand_by_replica_keep_duration': {'key': 'standByReplicaKeepDuration', 'type': 'str'},
        'service_placement_time_limit': {'key': 'servicePlacementTimeLimit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        has_persisted_state: Optional[bool] = None,
        target_replica_set_size: Optional[int] = None,
        min_replica_set_size: Optional[int] = None,
        replica_restart_wait_duration: Optional[str] = None,
        quorum_loss_wait_duration: Optional[str] = None,
        stand_by_replica_keep_duration: Optional[str] = None,
        service_placement_time_limit: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword placement_constraints: The placement constraints as a string. Placement constraints
         are boolean expressions on node properties and allow for restricting a service to particular
         nodes based on the service requirements. For example, to place a service on nodes where
         NodeType is blue specify the following: "NodeColor == blue)".
        :paramtype placement_constraints: str
        :keyword correlation_scheme: A list that describes the correlation of the service with other
         services.
        :paramtype correlation_scheme:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
        :keyword service_load_metrics: The service load metrics is given as an array of
         ServiceLoadMetric objects.
        :paramtype service_load_metrics:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
        :keyword service_placement_policies: A list that describes the correlation of the service with
         other services.
        :paramtype service_placement_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
        :keyword default_move_cost: Specifies the move cost for the service. Possible values include:
         "Zero", "Low", "Medium", "High".
        :paramtype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
        :keyword scaling_policies: Scaling policies for this service.
        :paramtype scaling_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
        :keyword service_type_name: Required. The name of the service type.
        :paramtype service_type_name: str
        :keyword partition_description: Required. Describes how the service is partitioned.
        :paramtype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
        :keyword service_package_activation_mode: The activation Mode of the service package. Possible
         values include: "SharedProcess", "ExclusiveProcess".
        :paramtype service_package_activation_mode: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
        :keyword has_persisted_state: A flag indicating whether this is a persistent service which
         stores states on the local disk. If it is then the value of this property is true, if not it is
         false.
        :paramtype has_persisted_state: bool
        :keyword target_replica_set_size: The target replica set size as a number.
        :paramtype target_replica_set_size: int
        :keyword min_replica_set_size: The minimum replica set size as a number.
        :paramtype min_replica_set_size: int
        :keyword replica_restart_wait_duration: The duration between when a replica goes down and when
         a new replica is created, represented in ISO 8601 format "hh:mm:ss".
        :paramtype replica_restart_wait_duration: str
        :keyword quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be
         in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
        :paramtype quorum_loss_wait_duration: str
        :keyword stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
         maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
        :paramtype stand_by_replica_keep_duration: str
        :keyword service_placement_time_limit: The duration for which replicas can stay InBuild before
         reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
        :paramtype service_placement_time_limit: str
        """
        super(StatefulServiceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, service_type_name=service_type_name, partition_description=partition_description, service_package_activation_mode=service_package_activation_mode, **kwargs)
        self.service_kind = 'Stateful'  # type: str
        self.has_persisted_state = has_persisted_state
        self.target_replica_set_size = target_replica_set_size
        self.min_replica_set_size = min_replica_set_size
        self.replica_restart_wait_duration = replica_restart_wait_duration
        self.quorum_loss_wait_duration = quorum_loss_wait_duration
        self.stand_by_replica_keep_duration = stand_by_replica_keep_duration
        self.service_placement_time_limit = service_placement_time_limit


class StatelessServiceProperties(ServiceResourceProperties):
    """The properties of a stateless service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server. Possible values include: "Stateless", "Stateful".
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceKind
    :ivar service_type_name: Required. The name of the service type.
    :vartype service_type_name: str
    :ivar partition_description: Required. Describes how the service is partitioned.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    :ivar instance_count: Required. The instance count.
    :vartype instance_count: int
    :ivar min_instance_count: MinInstanceCount is the minimum number of instances that must be up
     to meet the EnsureAvailability safety check during operations like upgrade or deactivate node.
     The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 *
     InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1
     is first converted into the number of nodes on which the instances are allowed to be placed
     according to the placement constraints on the service.
    :vartype min_instance_count: int
    :ivar min_instance_percentage: MinInstancePercentage is the minimum percentage of InstanceCount
     that must be up to meet the EnsureAvailability safety check during operations like upgrade or
     deactivate node. The actual number that is used is max( MinInstanceCount, ceil(
     MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during
     MinInstancePercentage computation, -1 is first converted into the number of nodes on which the
     instances are allowed to be placed according to the placement constraints on the service.
    :vartype min_instance_percentage: int
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'instance_count': {'required': True, 'minimum': -1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'min_instance_percentage': {'key': 'minInstancePercentage', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        instance_count: int,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        min_instance_count: Optional[int] = None,
        min_instance_percentage: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword placement_constraints: The placement constraints as a string. Placement constraints
         are boolean expressions on node properties and allow for restricting a service to particular
         nodes based on the service requirements. For example, to place a service on nodes where
         NodeType is blue specify the following: "NodeColor == blue)".
        :paramtype placement_constraints: str
        :keyword correlation_scheme: A list that describes the correlation of the service with other
         services.
        :paramtype correlation_scheme:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
        :keyword service_load_metrics: The service load metrics is given as an array of
         ServiceLoadMetric objects.
        :paramtype service_load_metrics:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
        :keyword service_placement_policies: A list that describes the correlation of the service with
         other services.
        :paramtype service_placement_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
        :keyword default_move_cost: Specifies the move cost for the service. Possible values include:
         "Zero", "Low", "Medium", "High".
        :paramtype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
        :keyword scaling_policies: Scaling policies for this service.
        :paramtype scaling_policies:
         list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
        :keyword service_type_name: Required. The name of the service type.
        :paramtype service_type_name: str
        :keyword partition_description: Required. Describes how the service is partitioned.
        :paramtype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
        :keyword service_package_activation_mode: The activation Mode of the service package. Possible
         values include: "SharedProcess", "ExclusiveProcess".
        :paramtype service_package_activation_mode: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
        :keyword instance_count: Required. The instance count.
        :paramtype instance_count: int
        :keyword min_instance_count: MinInstanceCount is the minimum number of instances that must be
         up to meet the EnsureAvailability safety check during operations like upgrade or deactivate
         node. The actual number that is used is max( MinInstanceCount, ceil(
         MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during
         MinInstanceCount computation -1 is first converted into the number of nodes on which the
         instances are allowed to be placed according to the placement constraints on the service.
        :paramtype min_instance_count: int
        :keyword min_instance_percentage: MinInstancePercentage is the minimum percentage of
         InstanceCount that must be up to meet the EnsureAvailability safety check during operations
         like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil(
         MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during
         MinInstancePercentage computation, -1 is first converted into the number of nodes on which the
         instances are allowed to be placed according to the placement constraints on the service.
        :paramtype min_instance_percentage: int
        """
        super(StatelessServiceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, service_type_name=service_type_name, partition_description=partition_description, service_package_activation_mode=service_package_activation_mode, **kwargs)
        self.service_kind = 'Stateless'  # type: str
        self.instance_count = instance_count
        self.min_instance_count = min_instance_count
        self.min_instance_percentage = min_instance_percentage


class Subnet(msrest.serialization.Model):
    """Describes a Subnet.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Subnet name.
    :vartype name: str
    :ivar enable_ipv6: Indicates wether to enable Ipv6 or not. If not provided, it will take the
     same configuration as the cluster.
    :vartype enable_ipv6: bool
    :ivar private_endpoint_network_policies: Enable or Disable apply network policies on private
     end point in the subnet. Possible values include: "enabled", "disabled".
    :vartype private_endpoint_network_policies: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PrivateEndpointNetworkPolicies
    :ivar private_link_service_network_policies: Enable or Disable apply network policies on
     private link service in the subnet. Possible values include: "enabled", "disabled".
    :vartype private_link_service_network_policies: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PrivateLinkServiceNetworkPolicies
    :ivar network_security_group_id: Full resource id for the network security group.
    :vartype network_security_group_id: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enable_ipv6': {'key': 'enableIpv6', 'type': 'bool'},
        'private_endpoint_network_policies': {'key': 'privateEndpointNetworkPolicies', 'type': 'str'},
        'private_link_service_network_policies': {'key': 'privateLinkServiceNetworkPolicies', 'type': 'str'},
        'network_security_group_id': {'key': 'networkSecurityGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        enable_ipv6: Optional[bool] = None,
        private_endpoint_network_policies: Optional[Union[str, "PrivateEndpointNetworkPolicies"]] = None,
        private_link_service_network_policies: Optional[Union[str, "PrivateLinkServiceNetworkPolicies"]] = None,
        network_security_group_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Subnet name.
        :paramtype name: str
        :keyword enable_ipv6: Indicates wether to enable Ipv6 or not. If not provided, it will take the
         same configuration as the cluster.
        :paramtype enable_ipv6: bool
        :keyword private_endpoint_network_policies: Enable or Disable apply network policies on private
         end point in the subnet. Possible values include: "enabled", "disabled".
        :paramtype private_endpoint_network_policies: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.PrivateEndpointNetworkPolicies
        :keyword private_link_service_network_policies: Enable or Disable apply network policies on
         private link service in the subnet. Possible values include: "enabled", "disabled".
        :paramtype private_link_service_network_policies: str or
         ~azure.mgmt.servicefabricmanagedclusters.models.PrivateLinkServiceNetworkPolicies
        :keyword network_security_group_id: Full resource id for the network security group.
        :paramtype network_security_group_id: str
        """
        super(Subnet, self).__init__(**kwargs)
        self.name = name
        self.enable_ipv6 = enable_ipv6
        self.private_endpoint_network_policies = private_endpoint_network_policies
        self.private_link_service_network_policies = private_link_service_network_policies
        self.network_security_group_id = network_security_group_id


class SubResource(msrest.serialization.Model):
    """Azure resource identifier.

    :ivar id: Azure resource identifier.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Azure resource identifier.
        :paramtype id: str
        """
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource.
    :vartype created_by_type: str
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource.
        :paramtype created_by_type: str
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UniformInt64RangePartitionScheme(Partition):
    """Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.

    All required parameters must be populated in order to send to Azure.

    :ivar partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server. Possible values include: "Singleton", "UniformInt64Range", "Named".
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PartitionScheme
    :ivar count: Required. The number of partitions.
    :vartype count: int
    :ivar low_key: Required. The lower bound of the partition key range that
     should be split between the partition ‘Count’.
    :vartype low_key: long
    :ivar high_key: Required. The upper bound of the partition key range that
     should be split between the partition ‘Count’.
    :vartype high_key: long
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'low_key': {'key': 'lowKey', 'type': 'long'},
        'high_key': {'key': 'highKey', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        count: int,
        low_key: int,
        high_key: int,
        **kwargs
    ):
        """
        :keyword count: Required. The number of partitions.
        :paramtype count: int
        :keyword low_key: Required. The lower bound of the partition key range that
         should be split between the partition ‘Count’.
        :paramtype low_key: long
        :keyword high_key: Required. The upper bound of the partition key range that
         should be split between the partition ‘Count’.
        :paramtype high_key: long
        """
        super(UniformInt64RangePartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'UniformInt64Range'  # type: str
        self.count = count
        self.low_key = low_key
        self.high_key = high_key


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_url: Required. This is the URL of a certificate that has been uploaded to Key
     Vault as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key
     vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case,
     your certificate needs to be It is the Base64 encoding of the following JSON Object which is
     encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`}.
    :vartype certificate_url: str
    :ivar certificate_store: Required. For Windows VMs, specifies the certificate store on the
     Virtual Machine to which the certificate should be added. The specified certificate store is
     implicitly in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate
     file is placed under the /var/lib/waagent directory, with the file name
     :code:`<UppercaseThumbprint>`.crt for the X509 certificate file and
     :code:`<UppercaseThumbprint>`.prv for private key. Both of these files are .pem formatted.
    :vartype certificate_store: str
    """

    _validation = {
        'certificate_url': {'required': True},
        'certificate_store': {'required': True},
    }

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_url: str,
        certificate_store: str,
        **kwargs
    ):
        """
        :keyword certificate_url: Required. This is the URL of a certificate that has been uploaded to
         Key Vault as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the
         key vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this
         case, your certificate needs to be It is the Base64 encoding of the following JSON Object which
         is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`}.
        :paramtype certificate_url: str
        :keyword certificate_store: Required. For Windows VMs, specifies the certificate store on the
         Virtual Machine to which the certificate should be added. The specified certificate store is
         implicitly in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate
         file is placed under the /var/lib/waagent directory, with the file name
         :code:`<UppercaseThumbprint>`.crt for the X509 certificate file and
         :code:`<UppercaseThumbprint>`.prv for private key. Both of these files are .pem formatted.
        :paramtype certificate_store: str
        """
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(msrest.serialization.Model):
    """Specifies set of certificates that should be installed onto the virtual machines.

    All required parameters must be populated in order to send to Azure.

    :ivar source_vault: Required. The relative URL of the Key Vault containing all of the
     certificates in VaultCertificates.
    :vartype source_vault: ~azure.mgmt.servicefabricmanagedclusters.models.SubResource
    :ivar vault_certificates: Required. The list of key vault references in SourceVault which
     contain certificates.
    :vartype vault_certificates:
     list[~azure.mgmt.servicefabricmanagedclusters.models.VaultCertificate]
    """

    _validation = {
        'source_vault': {'required': True},
        'vault_certificates': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(
        self,
        *,
        source_vault: "SubResource",
        vault_certificates: List["VaultCertificate"],
        **kwargs
    ):
        """
        :keyword source_vault: Required. The relative URL of the Key Vault containing all of the
         certificates in VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.servicefabricmanagedclusters.models.SubResource
        :keyword vault_certificates: Required. The list of key vault references in SourceVault which
         contain certificates.
        :paramtype vault_certificates:
         list[~azure.mgmt.servicefabricmanagedclusters.models.VaultCertificate]
        """
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VmManagedIdentity(msrest.serialization.Model):
    """Identities for the virtual machine scale set under the node type.

    :ivar user_assigned_identities: The list of user identities associated with the virtual machine
     scale set under the node type. Each entry will be an ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: list[str]
    """

    _attribute_map = {
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        user_assigned_identities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword user_assigned_identities: The list of user identities associated with the virtual
         machine scale set under the node type. Each entry will be an ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: list[str]
        """
        super(VmManagedIdentity, self).__init__(**kwargs)
        self.user_assigned_identities = user_assigned_identities


class VMSize(msrest.serialization.Model):
    """VM Sizes properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size: VM Size name.
    :vartype size: str
    """

    _validation = {
        'size': {'readonly': True},
    }

    _attribute_map = {
        'size': {'key': 'size', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(VMSize, self).__init__(**kwargs)
        self.size = None


class VmssDataDisk(msrest.serialization.Model):
    """Managed data disk description.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM. Lun 0 is reserved for the service fabric data disk.
    :vartype lun: int
    :ivar disk_size_gb: Required. Disk size for each vm in the node type in GBs.
    :vartype disk_size_gb: int
    :ivar disk_type: Required. Managed data disk type. Specifies the storage account type for the
     managed disk. Possible values include: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS".
     Default value: "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
    :ivar disk_letter: Required. Managed data disk letter. It can not use the reserved letter C or
     D and it can not change after created.
    :vartype disk_letter: str
    """

    _validation = {
        'lun': {'required': True, 'minimum': 1},
        'disk_size_gb': {'required': True},
        'disk_type': {'required': True},
        'disk_letter': {'required': True, 'pattern': r'^[a-zA-Z]{1}$'},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_letter': {'key': 'diskLetter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: int,
        disk_size_gb: int,
        disk_type: Union[str, "DiskType"] = "StandardSSD_LRS",
        disk_letter: str,
        **kwargs
    ):
        """
        :keyword lun: Required. Specifies the logical unit number of the data disk. This value is used
         to identify data disks within the VM and therefore must be unique for each data disk attached
         to a VM. Lun 0 is reserved for the service fabric data disk.
        :paramtype lun: int
        :keyword disk_size_gb: Required. Disk size for each vm in the node type in GBs.
        :paramtype disk_size_gb: int
        :keyword disk_type: Required. Managed data disk type. Specifies the storage account type for
         the managed disk. Possible values include: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS".
         Default value: "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
        :keyword disk_letter: Required. Managed data disk letter. It can not use the reserved letter C
         or D and it can not change after created.
        :paramtype disk_letter: str
        """
        super(VmssDataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.disk_size_gb = disk_size_gb
        self.disk_type = disk_type
        self.disk_letter = disk_letter


class VMSSExtension(msrest.serialization.Model):
    """Specifies set of extensions that should be installed onto the virtual machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the extension.
    :vartype name: str
    :ivar publisher: Required. The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Required. Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Required. Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: any
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: any
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'type': {'required': True},
        'type_handler_version': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: str,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        force_update_tag: Optional[str] = None,
        provision_after_extensions: Optional[List[str]] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the extension.
        :paramtype name: str
        :keyword publisher: Required. The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Required. Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Required. Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: any
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: any
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        """
        super(VMSSExtension, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.force_update_tag = force_update_tag
        self.provision_after_extensions = provision_after_extensions
        self.provisioning_state = None
        self.enable_automatic_upgrade = enable_automatic_upgrade
