/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import java.util.Date;
import org.brunel.data.Data;
import org.brunel.data.util.DateFormat;
import org.brunel.translator.JSTranslation;

public class Range
implements Comparable<Range> {
    public final Object high;
    public final Object mid;
    public final Object low;
    private final String name;

    @JSTranslation(ignore=true)
    public static Range make(Double low, Double high) {
        return Range.make(low, high, null);
    }

    public static Range make(Double low, Double high, DateFormat dateFormat) {
        if (low == null || high == null) {
            return null;
        }
        return dateFormat == null ? Range.makeNumeric(low, high, false) : Range.makeDate(low, high, false, dateFormat);
    }

    public static Range makeNumeric(double low, double high, boolean nameAtMid) {
        double mid = (high + low) / 2.0;
        double ext = 2.0 * (high - low) + 1.0;
        String name = nameAtMid ? Range.formatV(mid, ext) : Range.formatV(low, ext) + "\u2026" + Range.formatV(high, ext);
        return new Range(low, high, mid, name);
    }

    private static String formatV(double v, double ext) {
        if (ext > 2000000.0) {
            return Data.formatNumeric(v / 1000000.0, null, false) + "M";
        }
        return Data.formatNumeric(v, null, true);
    }

    public static Range makeDate(double low, double high, boolean nameAtMid, DateFormat df) {
        Date lowDate = Data.asDate(low);
        Date highDate = Data.asDate(high);
        Date midDate = Data.asDate((high + low) / 2.0);
        String name = nameAtMid ? df.format(midDate) : df.format(lowDate) + "\u2026" + df.format(highDate);
        return new Range(lowDate, highDate, midDate, name);
    }

    private Range(Object low, Object high, Object mid, String name) {
        this.low = low;
        this.high = high;
        this.mid = mid;
        this.name = name;
    }

    @Override
    public int compareTo(Range o) {
        return Data.compare(this.asNumeric(), o.asNumeric());
    }

    public Double asNumeric() {
        return (Data.asNumeric(this.low) + Data.asNumeric(this.high)) / 2.0;
    }

    private double extent() {
        return Data.asNumeric(this.high) - Data.asNumeric(this.low);
    }

    @JSTranslation(js={"return this.name;"})
    public int hashCode() {
        return this.low.hashCode() + 31 * this.high.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Range && ((Range)obj).low == this.low && ((Range)obj).high == this.high;
    }

    public String toString() {
        return this.name;
    }
}

