/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.brunel.translator.JSTranslation;

public enum DateUnit {
    century(36500.0, 10),
    decade(3650.0, 10),
    year(365.0, 10),
    quarter(91.25, 4),
    month(30.0, 4),
    week(7.0, 4),
    day(1.0, 7),
    hour(0.041666666666666664, 24),
    minute(6.944444444444444E-4, 60),
    second(1.1574074074074073E-5, 60);

    public final double approxDaysPerUnit;
    public final int base;

    @JSTranslation(js={"if (u == $$CLASS$$.day) {", "\treturn new Date(Date.UTC(d.getUTCFullYear(), d.getUTCMonth(), $$CLASS$$.floorNumeric(d.getUTCDate(), multiple, 1)));", "} else if (u == $$CLASS$$.week) {", "\treturn new Date(Date.UTC(d.getUTCFullYear(), d.getUTCMonth(), $$CLASS$$.floorNumeric(d.getUTCDate(), multiple*7, 1)));", "} else if (u == $$CLASS$$.month) {", "\treturn new Date(Date.UTC(d.getUTCFullYear(), $$CLASS$$.floorNumeric(d.getUTCMonth(), multiple, 0)));", "} else if (u == $$CLASS$$.quarter) {", "\treturn new Date(Date.UTC(d.getUTCFullYear(), $$CLASS$$.floorNumeric(d.getUTCMonth(), multiple*3, 0)));", "} else if (u == $$CLASS$$.year) {", "\treturn new Date(Date.UTC($$CLASS$$.floorNumeric(d.getUTCFullYear(), multiple, 0), 0));", "} else if (u == $$CLASS$$.decade) {", "\treturn new Date(Date.UTC($$CLASS$$.floorNumeric(d.getUTCFullYear(), multiple*10, 0), 0));", "} else if (u == $$CLASS$$.century) {", "\treturn new Date(Date.UTC($$CLASS$$.floorNumeric(d.getUTCFullYear(), multiple*100, 0), 0));", "}", "var c = new Date(d.getTime());", "if (u == $$CLASS$$.second) {", "\tc.setUTCSeconds($$CLASS$$.floorNumeric(d.getUTCSeconds(), multiple, 0));", "} else if (u == $$CLASS$$.minute) {", "\tc.setUTCSeconds(0);", "\tc.setUTCMinutes($$CLASS$$.floorNumeric(d.getUTCMinutes(), multiple, 0));", "} else if (u == $$CLASS$$.hour) {", "\tc.setUTCSeconds(0); c.setUTCMinutes(0);", "\tc.setUTCHours($$CLASS$$.floorNumeric(d.getUTCHours(), multiple, 0));", "} else if (u == $$CLASS$$.hour) {", "\tc.setUTCSeconds(0); c.setUTCMinutes(0);", "\tc.setUTCHours($$CLASS$$.floorNumeric(d.getUTCHours(), multiple, 0));", "} else", "\tthrow 'Invalid date unit ' + u;", "return c;"})
    public static Date floor(Date d, DateUnit u, int multiple) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTime(d);
        if (u.ordinal() < second.ordinal()) {
            c.set(13, 0);
        }
        if (u.ordinal() < minute.ordinal()) {
            c.set(12, 0);
        }
        if (u.ordinal() < hour.ordinal()) {
            c.set(11, 0);
        }
        if (u.ordinal() < week.ordinal()) {
            c.set(5, 1);
        }
        if (u.ordinal() < quarter.ordinal()) {
            c.set(2, 0);
        }
        if (u == second) {
            DateUnit.setCalendarField(c, 13, multiple, 0);
        } else if (u == minute) {
            DateUnit.setCalendarField(c, 12, multiple, 0);
        } else if (u == hour) {
            DateUnit.setCalendarField(c, 11, multiple, 0);
        } else if (u == day) {
            DateUnit.setCalendarField(c, 5, multiple, 1);
        } else if (u == week) {
            DateUnit.setCalendarField(c, 5, multiple * 7, 1);
        } else if (u == month) {
            DateUnit.setCalendarField(c, 2, multiple, 0);
        } else if (u == quarter) {
            DateUnit.setCalendarField(c, 2, multiple * 3, 0);
        } else if (u == year) {
            DateUnit.setCalendarField(c, 1, multiple, 0);
        } else if (u == decade) {
            DateUnit.setCalendarField(c, 1, multiple * 10, 0);
        } else if (u == century) {
            DateUnit.setCalendarField(c, 1, multiple * 100, 0);
        } else {
            throw new IllegalStateException("Strange date unit: " + (Object)((Object)u));
        }
        return c.getTime();
    }

    @JSTranslation(ignore=true)
    private static void setCalendarField(Calendar c, int field, int multiple, int min) {
        int v = c.get(field);
        c.set(field, (int)DateUnit.floorNumeric(v, multiple, min));
    }

    private static double floorNumeric(int value, int multiple, int offset) {
        return (double)multiple * Math.floor((value - offset) / multiple) + (double)offset;
    }

    @JSTranslation(js={"var c = new Date(d.getTime());", "if (u == $$CLASS$$.second) c.setUTCSeconds(c.getUTCSeconds()+delta);", "else if (u == $$CLASS$$.minute) c.setUTCMinutes(c.getUTCMinutes()+delta);", "else if (u == $$CLASS$$.hour) c.setUTCHours(c.getUTCHours()+delta);", "else if (u == $$CLASS$$.day) c.setUTCDate(c.getUTCDate()+delta);", "else if (u == $$CLASS$$.week) c.setUTCDate(c.getUTCDate()+7*delta);", "else if (u == $$CLASS$$.month) c.setUTCMonth(c.getUTCMonth()+delta);", "else if (u == $$CLASS$$.quarter) c.setUTCMonth(c.getUTCMonth()+3*delta);", "else if (u == $$CLASS$$.year) c.setUTCFullYear(c.getUTCFullYear()+delta);", "else if (u == $$CLASS$$.decade) c.setUTCFullYear(c.getUTCFullYear()+10*delta);", "else if (u == $$CLASS$$.century) c.setUTCFullYear(c.getUTCFullYear()+100*delta);", "return c; "})
    public static Date increment(Date d, DateUnit u, int delta) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTime(d);
        if (u == second) {
            c.add(13, delta);
        } else if (u == minute) {
            c.add(12, delta);
        } else if (u == hour) {
            c.add(11, delta);
        } else if (u == day) {
            c.add(5, delta);
        } else if (u == week) {
            c.add(5, delta * 7);
        } else if (u == month) {
            c.add(2, delta);
        } else if (u == quarter) {
            c.add(2, delta * 3);
        } else if (u == year) {
            c.add(1, delta);
        } else if (u == decade) {
            c.add(1, delta * 10);
        } else if (u == century) {
            c.add(1, delta * 100);
        } else {
            throw new IllegalStateException("Strange date unit: " + (Object)((Object)u));
        }
        return c.getTime();
    }

    private DateUnit(double days, int base) {
        this.approxDaysPerUnit = days;
        this.base = base;
    }
}

