/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brunel.data.Data;
import org.brunel.data.Field;

public abstract class Fit {
    private final Field fx;
    private final Field fy;
    private final Map<Object, Double> xCatMap;
    private final Map<Object, Double> yCatMap;
    protected final double[] x;
    protected final double[] y;
    protected final double mx;
    protected final double my;

    public Fit(Field fy, Field fx, List<Integer> rows) {
        this.fx = fx;
        this.fy = fy;
        this.xCatMap = this.makeCatMap(fx);
        this.yCatMap = this.makeCatMap(fy);
        ArrayList<Double> xList = new ArrayList<Double>();
        ArrayList<Double> yList = new ArrayList<Double>();
        for (int i : rows) {
            Double xv = this.vx(fx.value(i));
            Double yv = this.vy(fy.value(i));
            if (xv == null || yv == null) continue;
            xList.add(xv);
            yList.add(yv);
        }
        int n = xList.size();
        Integer[] order = Data.order(xList.toArray(new Double[n]), true);
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = (Double)xList.get(order[i]);
            this.y[i] = (Double)yList.get(order[i]);
        }
        this.my = Fit.mean(this.y);
        this.mx = Fit.mean(this.x);
    }

    private Map<Object, Double> makeCatMap(Field f) {
        if (f.isNumeric()) {
            return null;
        }
        HashMap<Object, Double> map = new HashMap<Object, Double>();
        Object[] categories = f.categories();
        for (int i = 0; i < categories.length; ++i) {
            map.put(categories[i], Double.valueOf(i));
        }
        return map;
    }

    public abstract Object get(Object var1);

    protected Double vx(Object o) {
        return this.xCatMap == null ? Data.asNumeric(o) : this.xCatMap.get(o);
    }

    private static double mean(double[] values) {
        double s = 0.0;
        for (double value : values) {
            s += value;
        }
        return s / (double)values.length;
    }

    protected Double vy(Object o) {
        return this.yCatMap == null ? Data.asNumeric(o) : this.yCatMap.get(o);
    }

    protected Object reverseY(double v) {
        if (this.yCatMap == null) {
            return v;
        }
        int n = (int)Math.round(v);
        Object[] categories = this.fy.categories();
        if (n < 0 || n >= categories.length) {
            return null;
        }
        return categories[n];
    }
}

