/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.AllCombinations;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.summary.FieldRowComparison;

public class Stack
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        if (command.isEmpty()) {
            return base;
        }
        String[] p = Stack.strings(command, ';');
        String yField = p[0];
        String[] x = Stack.strings(p[1], ',');
        String[] aesthetics = Stack.strings(p[2], ',');
        boolean full = p[3].equalsIgnoreCase("true");
        Field[] keyFields = Stack.getFields(base.fields, x, aesthetics, {yField});
        Field[] allFields = Stack.makeStackOrderedFields(base, keyFields, x.length);
        if (full) {
            allFields = new AllCombinations(allFields, x.length, aesthetics.length).make();
        }
        Field[] fields = Stack.makeStackedValues(allFields, Stack.getField(allFields, yField), Stack.getFields(allFields, new String[][]{x}), full);
        return base.replaceFields(fields);
    }

    public static Field getField(Field[] fields, String name) {
        for (Field f : fields) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        throw new IllegalArgumentException("Could not find field: " + name);
    }

    public static Field[] getFields(Field[] fields, String[] ... namesList) {
        ArrayList<Field> result = new ArrayList<Field>();
        HashSet<Field> found = new HashSet<Field>();
        String[][] arr$ = namesList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] s;
            for (String fName : s = arr$[i$]) {
                Field field;
                if ((fName = fName.trim()).isEmpty() || !found.add(field = Stack.getField(fields, fName))) continue;
                result.add(field);
            }
        }
        return result.toArray(new Field[result.size()]);
    }

    private static Field[] makeStackedValues(Field[] allFields, Field y, Field[] x, boolean full) {
        int N = y.rowCount();
        Object[][] bounds = new Object[2][N];
        double lastPositive = 0.0;
        double lastNegative = 0.0;
        FieldRowComparison rowComparison = new FieldRowComparison(x, null, false);
        for (int i = 0; i < N; ++i) {
            Double v = Data.asNumeric(y.value(i));
            if (v == null) {
                if (!full) continue;
                v = 0.0;
            }
            if (i > 0 && rowComparison.compare(i, i - 1) != 0) {
                lastPositive = 0.0;
                lastNegative = 0.0;
            }
            if (v < 0.0) {
                bounds[0][i] = lastNegative;
                bounds[1][i] = lastNegative += v.doubleValue();
                continue;
            }
            bounds[0][i] = lastPositive;
            bounds[1][i] = lastPositive += v.doubleValue();
        }
        int n = allFields.length;
        Object[] fields = new Field[n + 2];
        for (int i = 0; i < n; ++i) {
            fields[i] = allFields[i];
        }
        fields[n] = Fields.makeColumnField(y.name + "$lower", y.label, bounds[0]);
        fields[n + 1] = Fields.makeColumnField(y.name + "$upper", y.label, bounds[1]);
        Fields.copyBaseProperties(y, fields[n]);
        Fields.copyBaseProperties(y, fields[n + 1]);
        Arrays.sort(fields);
        return fields;
    }

    private static Field[] makeStackOrderedFields(Dataset base, Field[] keyFields, int xFieldCount) {
        Field[] baseFields = Stack.orderFields(base, keyFields);
        Integer[] rowOrder = Stack.makeStackDataOrder(baseFields, keyFields.length, xFieldCount);
        Field[] fields = new Field[baseFields.length];
        for (int i = 0; i < baseFields.length; ++i) {
            fields[i] = Fields.permute(baseFields[i], Data.toPrimitive(rowOrder), true);
        }
        return fields;
    }

    public static Integer[] makeStackDataOrder(Field[] fields, int keyFieldCount, int xFieldCount) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        int n = fields[0].rowCount();
        for (int i = 0; i < n; ++i) {
            boolean valid = true;
            for (int j = 0; j < keyFieldCount; ++j) {
                if (fields[j].value(i) != null) continue;
                valid = false;
            }
            if (!valid) continue;
            items.add(i);
        }
        boolean[] ascending = new boolean[keyFieldCount];
        for (int i = 0; i < ascending.length; ++i) {
            ascending[i] = i < xFieldCount;
        }
        FieldRowComparison comparison = new FieldRowComparison(fields, ascending, true);
        Collections.sort(items, comparison);
        return items.toArray(new Integer[items.size()]);
    }

    private static Field[] orderFields(Dataset base, Field[] keyFields) {
        Field[] baseFields = new Field[base.fields.length];
        HashSet<Field> used = new HashSet<Field>();
        for (int i = 0; i < keyFields.length; ++i) {
            baseFields[i] = keyFields[i];
            used.add(keyFields[i]);
        }
        int at = keyFields.length;
        for (Field f : base.fields) {
            if (used.contains(f)) continue;
            baseFields[at++] = f;
        }
        return baseFields;
    }
}

