/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.diagram.Node;

public class Hierarchical {
    public final Node root;

    public static Hierarchical makeByNestingFields(Dataset data, String sizeField, String ... fields) {
        return new Hierarchical(data, sizeField, fields);
    }

    public static int compare(Node a, Node b) {
        int d = Data.compare(a.meanRow(), b.meanRow());
        return d != 0 ? d : Data.compare(a.key, b.key);
    }

    public static int compareReverse(Node a, Node b) {
        return Hierarchical.compare(b, a);
    }

    private Hierarchical(Dataset data, String sizeFieldName, String[] fieldNames) {
        Field size = sizeFieldName == null ? null : data.field(sizeFieldName);
        Field[] fields = this.toFields(data, fieldNames);
        this.root = this.makeInternalNode("");
        this.makeNodesUsingCollections(data, size, fields);
        this.replaceCollections(this.root, null);
    }

    private Node makeInternalNode(String label) {
        Node node = new Node(null, 0.0, label, new ArrayList());
        node.temp = new HashMap();
        return node;
    }

    private void makeNodesUsingCollections(Dataset data, Field size, Field[] fields) {
        for (int row = 0; row < data.rowCount(); ++row) {
            Double d = size == null ? 1.0 : Data.asNumeric(size.value(row));
            if (!(d > 0.0)) continue;
            Node current = this.root;
            for (Field field : fields) {
                Map map = (Map)current.temp;
                List children = (List)current.children;
                Object v = field.value(row);
                current = (Node)map.get(v);
                if (current != null) continue;
                current = this.makeInternalNode(field.valueFormatted(row));
                children.add(current);
                map.put(v, current);
            }
            ((List)current.children).add(new Node(row, d, null, null));
        }
    }

    private void replaceCollections(Node current, Object parentKey) {
        List array = (List)current.children;
        if (array != null) {
            current.children = array.toArray(new Node[array.size()]);
            current.temp = null;
            current.key = parentKey == null ? current.innerNodeName : parentKey + "-" + current.innerNodeName;
            for (Node child : array) {
                this.replaceCollections(child, current.key);
            }
        }
    }

    private Field[] toFields(Dataset data, String[] fieldNames) {
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = data.field(fieldNames[i]);
        }
        return fields;
    }
}

