/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import org.brunel.build.Builder;

public class LocalOutputFiles {
    private static final List<String> RESOURCES = Arrays.asList("BrunelD3.js", "BrunelData.js", "Brunel.css", "BrunelEventHandlers.js", "BrunelJQueryControlFactory.js", "sumoselect/jquery.sumoselect.min.js", "sumoselect/sumoselect.css");
    private final File home = this.getHomeDirectory();
    private final File out = this.ensureWritable(new File(this.home, "out"));
    private static final LocalOutputFiles INSTANCE = new LocalOutputFiles();

    public static void install() {
        for (String s : RESOURCES) {
            INSTANCE.ensureResourceExists(s);
        }
    }

    public static File makeDirectory(String dirName) {
        return INSTANCE.ensureWritable(new File(LocalOutputFiles.INSTANCE.home, dirName));
    }

    private LocalOutputFiles() {
        new File(this.out, "/sumoselect").mkdirs();
    }

    public static Writer makeFileWriter(String fileName) {
        File f = new File(LocalOutputFiles.INSTANCE.home, fileName);
        try {
            f.getParentFile().mkdirs();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating file to write to: " + f.getAbsolutePath());
        }
    }

    public static void showInBrowser(String location) {
        File file = new File(LocalOutputFiles.INSTANCE.home, location);
        try {
            Desktop.getDesktop().browse(file.toURI());
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to show file in browser: " + file, ex);
        }
    }

    private File ensureWritable(File f) {
        f.mkdirs();
        if (!f.canWrite()) {
            throw new IllegalArgumentException("Cannot write to the directory: " + f.getAbsolutePath());
        }
        return f;
    }

    private File getHomeDirectory() {
        String brunelDir = System.getProperty("brunel.home");
        File home = brunelDir != null ? new File(brunelDir) : new File(System.getProperty("user.home"), "brunel");
        return this.ensureWritable(home);
    }

    private void ensureResourceExists(String resourceName) {
        try {
            InputStream is = Builder.class.getResourceAsStream("/javascript/" + resourceName);
            if (is == null) {
                is = Builder.class.getResourceAsStream("/translated/" + resourceName);
            }
            if (is == null) {
                File file = new File("data/build/translated/");
                if (!file.exists()) {
                    file = new File("../data/build/translated/");
                }
                is = new FileInputStream(new File(file, resourceName));
            }
            Files.copy(is, new File(this.out, resourceName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy required " + resourceName + " to output folder: " + this.out, e);
        }
    }
}

