/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model.style;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.brunel.model.style.AnySelector;
import org.brunel.model.style.BasicSelector;
import org.brunel.model.style.MultiComponentSelector;
import org.brunel.model.style.StyleSelector;
import org.brunel.model.style.StyleSheet;

public class StyleFactory {
    private static final StyleFactory INSTANCE = new StyleFactory(400);
    final int maxEntries;
    final LinkedHashMap<String, StyleSelector> selectors = new LinkedHashMap<String, StyleSelector>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, StyleSelector> eldest) {
            return this.size() > StyleFactory.this.maxEntries;
        }
    };

    public static StyleFactory instance() {
        return INSTANCE;
    }

    private StyleFactory(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public StyleSheet makeStyleSheet(String text) {
        StyleSheet sheet = new StyleSheet();
        for (String s : text.split("\\}")) {
            String[] parts = s.split("\\{");
            if (parts.length != 2) continue;
            StyleSelector[] selectors = this.makeSelectors(parts[0]);
            Map<String, String> options = this.makeOptions(parts[1]);
            for (StyleSelector sel : selectors) {
                sheet.addEntry(sel, options);
            }
        }
        return sheet;
    }

    public StyleSelector[] makeSelectors(String text) {
        String[] parts = text.split(",");
        StyleSelector[] result = new StyleSelector[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = this.makeSingleSelector(parts[i].trim());
        }
        return result;
    }

    private Map<String, String> makeOptions(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : text.split(";")) {
            String[] keyValue = item.split(":");
            if (keyValue.length != 2) continue;
            String a = keyValue[0].trim();
            String b = keyValue[1].trim();
            if (a.isEmpty() || b.isEmpty()) continue;
            map.put(a, b);
        }
        return map;
    }

    StyleSelector makeSingleSelector(String text) {
        StyleSelector s = this.selectors.get(text);
        if (s == null) {
            String[] parts = text.split("[ \t]+");
            if (parts.length == 1) {
                s = this.makeSingleComponentSelector(parts[0]);
            } else {
                StyleSelector[] components = new StyleSelector[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    components[i] = this.makeSingleComponentSelector(parts[i].trim());
                }
                s = new MultiComponentSelector(components);
            }
            this.selectors.put(text, s);
        }
        return s;
    }

    private StyleSelector makeSingleComponentSelector(String text) {
        if (text.equals("*")) {
            return new AnySelector();
        }
        String[] parts = text.split("\\.");
        if (parts.length == 1) {
            return new BasicSelector(parts[0], new String[0]);
        }
        if (parts.length == 2) {
            return new BasicSelector(parts[0], new String[]{parts[1]});
        }
        String[] classes = new String[parts.length - 1];
        System.arraycopy(parts, 1, classes, 0, parts.length - 1);
        return new BasicSelector(parts[0], classes);
    }
}

