/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import org.brunel.data.Dataset;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class VisComposition
extends VisItem {
    public final VisTypes.Composition method;
    private final VisItem[] items;

    public static VisComposition inside(VisItem ... items) {
        return new VisComposition(VisTypes.Composition.inside, items);
    }

    public static VisComposition nested(VisItem ... items) {
        return new VisComposition(VisTypes.Composition.nested, items);
    }

    public static VisComposition overlay(VisItem ... items) {
        return new VisComposition(VisTypes.Composition.overlay, items);
    }

    public static VisComposition tile(VisItem ... items) {
        return new VisComposition(VisTypes.Composition.tile, items);
    }

    private VisComposition(VisTypes.Composition method, VisItem ... items) {
        this.method = method;
        this.items = items;
    }

    @Override
    public VisSingle getSingle() {
        return this.items[0].getSingle();
    }

    @Override
    public VisItem[] children() {
        return this.items;
    }

    @Override
    public String validate() {
        String error = null;
        for (VisItem i : this.items) {
            String e = i.validate();
            if (e == null) continue;
            error = error == null ? e : error + "; " + e;
        }
        return error;
    }

    @Override
    public Dataset[] getDataSets() {
        LinkedHashSet<Dataset> datas = new LinkedHashSet<Dataset>();
        for (VisItem v : this.items) {
            if (v instanceof VisSingle) {
                datas.add(((VisSingle)v).getDataset());
                continue;
            }
            Collections.addAll(datas, v.getDataSets());
        }
        return datas.toArray(new Dataset[datas.size()]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.items.length; ++i) {
            if (i > 1) {
                b.append((Object)this.method);
            }
            b.append(this.items[i]).toString();
        }
        return b.toString();
    }
}

