/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.match.ActionParameterChoice;

class BestActionParameterSet {
    private ArrayList<ActionParameterChoice> actionChoices;
    private final int numChoices;
    private static final double REALLY_BAD = 1.0E-6;

    public BestActionParameterSet(Dataset originalData, Dataset newData, Param[] originalParams, int actionParameterIndex, int numChoices) {
        this.numChoices = numChoices;
        Param p = originalParams[actionParameterIndex];
        if (!(this.addNonFieldChoice(p) || this.addSyntheticFieldChoice(originalData, p) || this.addDualEncodedFieldChoice(originalParams, actionParameterIndex))) {
            this.addFieldChoices(originalData, newData, p);
        }
    }

    public ActionParameterChoice pullNextActionParameterChoice(List<String> restrictedFields) {
        if (this.actionChoices.size() == 1) {
            return this.actionChoices.get(0);
        }
        for (ActionParameterChoice c : this.actionChoices) {
            if (this.containsRestrictedField(c, restrictedFields)) continue;
            this.actionChoices.remove(c);
            return c;
        }
        ActionParameterChoice c = this.actionChoices.get(0);
        this.actionChoices.remove(c);
        return c;
    }

    public int size() {
        return this.actionChoices.size();
    }

    private boolean containsRestrictedField(ActionParameterChoice c, List<String> restrictedFields) {
        for (String f : restrictedFields) {
            if (!f.equals(c.getActionParameter().asField())) continue;
            return true;
        }
        return false;
    }

    private void leaveAsIs(ActionParameterChoice choice) {
        this.actionChoices = new ArrayList(1);
        this.actionChoices.add(choice);
    }

    private boolean addSyntheticFieldChoice(Dataset originalData, Param parm) {
        String s = parm.asField();
        if (s.equals("#all") || s.equals("#series") || s.equals("#values") || parm.isField() && originalData.field(s, true).isSynthetic()) {
            this.leaveAsIs(new ActionParameterChoice(parm, 1.0));
            return true;
        }
        return false;
    }

    private boolean addNonFieldChoice(Param parm) {
        if (!parm.isField()) {
            this.leaveAsIs(new ActionParameterChoice(parm, 1.0));
            return true;
        }
        return false;
    }

    private boolean addDualEncodedFieldChoice(Param[] originalParams, int actionParameterIndex) {
        Param parm = originalParams[actionParameterIndex];
        if (!parm.isField()) {
            return false;
        }
        for (int i = 0; i < actionParameterIndex; ++i) {
            Param p = originalParams[i];
            if (!p.isField() || !parm.asField().equals(p.asField())) continue;
            this.leaveAsIs(new ActionParameterChoice(i, parm));
            return true;
        }
        return false;
    }

    private void addFieldChoices(Dataset originalData, Dataset newData, Param parm) {
        if (!parm.isField()) {
            return;
        }
        Field[] fields = newData.fields;
        Field originalField = originalData.field(parm.asField(), true);
        this.actionChoices = new ArrayList(fields.length);
        for (Field f : fields) {
            if (f.isSynthetic()) continue;
            double scoreName = this.scoreFieldByNameCloseness(originalField.label, f.label);
            double scoreFieldValueCloseness = this.scoreFieldByValueCloseness(originalField, f, this.declaredNominal(parm));
            double score = Math.sqrt(scoreName * scoreFieldValueCloseness);
            Param newParam = Param.makeField(f.name).addModifiers(parm.modifiers());
            this.actionChoices.add(new ActionParameterChoice(newParam, score));
        }
        Collections.sort(this.actionChoices);
        if (this.actionChoices.size() > this.numChoices) {
            this.actionChoices.subList(this.numChoices, this.actionChoices.size()).clear();
        }
    }

    private boolean declaredNominal(Param p) {
        Param[] modifiers;
        for (Param m : modifiers = p.modifiers()) {
            String o;
            if (m.type() != Param.Type.option || !(o = m.asString()).equals("nominal")) continue;
            return true;
        }
        return false;
    }

    private double scoreFieldByNameCloseness(String origName, String newName) {
        int lcs = this.getLongestCommonSubstringLength(origName, newName);
        double score = (double)lcs / (double)origName.length();
        return score >= 0.75 ? score : 0.1;
    }

    private int getLongestCommonSubstringLength(String a, String b) {
        if (a.length() == 0 || b.length() == 0) {
            return 0;
        }
        int maxLen = 0;
        int lenA = a.length();
        int lenB = b.length();
        int[][] table = new int[lenA + 1][lenB + 1];
        for (int i = 1; i <= lenA; ++i) {
            for (int j = 1; j <= lenB; ++j) {
                if (a.charAt(i - 1) != b.charAt(j - 1)) continue;
                table[i][j] = i == 1 || j == 1 ? 1 : table[i - 1][j - 1] + 1;
                if (table[i][j] <= maxLen) continue;
                maxLen = table[i][j];
            }
        }
        return maxLen;
    }

    private double scoreFieldByValueCloseness(Field origField, Field newField, boolean originalDeclaredNominal) {
        boolean originalLooksLikeKey;
        boolean bl = originalLooksLikeKey = (double)origField.uniqueValuesCount() > 0.7 * (double)origField.rowCount() && origField.preferCategorical();
        if (originalLooksLikeKey) {
            double keyLikeScore = (double)newField.uniqueValuesCount() / (double)newField.rowCount();
            if (newField.preferCategorical()) {
                return 0.1 * keyLikeScore;
            }
            return keyLikeScore;
        }
        double scoreSimilarCounts = this.fractionDifferent(origField.uniqueValuesCount(), newField.uniqueValuesCount());
        if (originalDeclaredNominal) {
            return scoreSimilarCounts;
        }
        if (origField.preferCategorical() != newField.preferCategorical()) {
            return 0.1 * scoreSimilarCounts;
        }
        if (origField.preferCategorical()) {
            return scoreSimilarCounts;
        }
        if (origField.isDate() && newField.isDate()) {
            double meanSimilarity = this.propertyDiffScore("mean", origField, newField);
            return 0.9 + 0.1 * meanSimilarity;
        }
        double typeMatch = origField.isDate() == newField.isDate() ? 1.0 : 0.3;
        return typeMatch * (0.5 + 0.5 * this.scoreByDistributionCloseness(origField, newField));
    }

    private double fractionDifferent(double v1, double v2) {
        double av1 = Math.abs(v1);
        double av2 = Math.abs(v2);
        double max = Math.max(av1, av2);
        return 1.0 - Math.abs(av1 - av2) / max;
    }

    private double propertyDiffScore(String numericProperty, Field f1, Field f2) {
        Double p1 = f1.numProperty(numericProperty);
        Double p2 = f2.numProperty(numericProperty);
        if (p1 == null || p2 == null) {
            return Double.NaN;
        }
        return this.fractionDifferent(p1, p2);
    }

    private double scoreByDistributionCloseness(Field origField, Field newField) {
        double skewScore = this.propertyDiffScore("skew", origField, newField);
        double kurtosisScore = this.propertyDiffScore("kurtosis", origField, newField);
        double geoMean = this.geoMeanNoMissing(skewScore, kurtosisScore);
        return Double.isNaN(geoMean) ? 1.0E-6 : geoMean;
    }

    private double geoMeanNoMissing(double ... vals) {
        double count = 0.0;
        double sum = 1.0;
        for (double val : vals) {
            if (Double.isNaN(val)) continue;
            sum *= val;
            count += 1.0;
        }
        return count > 0.0 ? Math.pow(sum, 1.0 / count) : Double.NaN;
    }
}

