/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.projection.Albers;
import org.brunel.maps.projection.AlbersUSA;
import org.brunel.maps.projection.Mercator;
import org.brunel.maps.projection.Projection;
import org.brunel.maps.projection.WinkelTripel;

public class ProjectionBuilder {
    public static final Projection MERCATOR = new Mercator();
    public static final Projection WINKEL3 = new WinkelTripel();
    public static final Projection ALBERS_USA = new AlbersUSA();

    public static Projection makeProjection(Rect bounds) {
        if (bounds.left < -100.0 && bounds.top > 17.0 && bounds.bottom > 35.0 && bounds.bottom < 73.0) {
            if (bounds.left < -120.0) {
                return ALBERS_USA;
            }
            return MERCATOR;
        }
        if (ProjectionBuilder.getMercatorDistortion(bounds) <= 1.8) {
            return MERCATOR;
        }
        if (bounds.right - bounds.left > 180.0 && bounds.bottom - bounds.top > 90.0) {
            return WINKEL3;
        }
        return ProjectionBuilder.makeAlbers(bounds);
    }

    private static double getMercatorDistortion(Rect bounds) {
        double b;
        if (bounds.top < -89.0 || bounds.bottom > 89.0) {
            return 100.0;
        }
        double a = MERCATOR.getTissotArea(new Point(bounds.cx(), bounds.top));
        return a < (b = MERCATOR.getTissotArea(new Point(bounds.cx(), bounds.bottom))) / 100.0 || b < a / 100.0 ? 100.0 : Math.max(b / a, a / b);
    }

    public static Albers makeAlbers(Rect b) {
        double parallelA = (b.top + b.bottom * 5.0) / 6.0;
        double parallelB = (b.top * 5.0 + b.bottom) / 6.0;
        double angle = -b.cx();
        return new Albers(parallelA, parallelB, angle);
    }
}

