/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.projection.Projection;

class Albers
extends Projection {
    private final double parallelA;
    private final double parallelB;
    private final double n;
    private final double C;
    private final double r1;
    private final double rotation;

    Albers(double parallelA, double parallelB, double rotation) {
        this.parallelA = parallelA;
        this.parallelB = parallelB;
        this.rotation = rotation;
        double s1 = Math.toRadians(parallelA);
        double s2 = Math.toRadians(parallelB);
        double sin1 = Math.sin(s1);
        double sin2 = Math.sin(s2);
        this.n = (sin1 + sin2) / 2.0;
        this.C = 1.0 + sin1 * (2.0 * this.n - sin1);
        this.r1 = Math.sqrt(this.C) / this.n;
    }

    @Override
    public String d3Definition(Rect bounds) {
        String parallels = ".parallels([" + F.format(this.parallelA) + "," + F.format(this.parallelB) + "])";
        String rotate = ".rotate([" + F.format(this.rotation) + ",0,0])";
        Rect ext = this.transform(bounds);
        Point c = this.inverse(ext.center());
        String center = ".center([0, " + F.format(c.y) + "])";
        return "d3.geoAlbers()\n\t\t" + this.translateDefinition() + "\n\t\t" + center + "\n\t\t" + parallels + "\n\t\t" + this.scaleDefinition(ext) + "\n\t\t" + rotate;
    }

    @Override
    public Point transform(Point p) {
        double a = Math.toRadians(p.x + this.rotation);
        double b = Math.toRadians(p.y);
        double r = Math.sqrt(this.C - 2.0 * this.n * Math.sin(b)) / this.n;
        return new Point(r * Math.sin(a * this.n), this.r1 - r * Math.cos(a * this.n));
    }

    @Override
    public Point inverse(Point p) {
        double r1y = this.r1 - p.y;
        double lon = Math.atan2(p.x, r1y) / this.n;
        double v = (this.C - (p.x * p.x + r1y * r1y) * this.n * this.n) / (2.0 * this.n);
        double lat = Math.asin(Math.min(1.0, Math.max(-1.0, v)));
        return new Point(Math.toDegrees(lon) - this.rotation, Math.toDegrees(lat));
    }
}

