/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.brunel.geom.Rect;
import org.brunel.maps.GeoFile;
import org.brunel.util.MappedLists;

class GeoFileGroup {
    private static final int MAX_FILES = 3;
    public final Set<GeoFile> files;
    private final MappedLists<GeoFile, Object> itemsMap;
    private final int requiredContentCount;
    private final Set<Object> content;
    private Rect totalBounds;

    public static GeoFileGroup makeEmpty(MappedLists<GeoFile, Object> containedItems) {
        HashSet all = new HashSet();
        for (List f : containedItems.values()) {
            all.addAll(f);
        }
        return new GeoFileGroup(all.size(), containedItems, Collections.emptySet(), Collections.emptySet());
    }

    private GeoFileGroup(int requiredCount, MappedLists<GeoFile, Object> itemsMap, Collection<GeoFile> files, Collection<?> features) {
        this.requiredContentCount = requiredCount;
        this.itemsMap = itemsMap;
        this.files = new LinkedHashSet<GeoFile>(files);
        this.content = new HashSet(features);
    }

    public GeoFileGroup add(GeoFile file) {
        if (this.files.contains(file)) {
            return null;
        }
        HashSet<Object> combinedFeatures = new HashSet<Object>(this.content);
        if (!combinedFeatures.addAll((Collection<Object>)this.itemsMap.get(file))) {
            return null;
        }
        HashSet<GeoFile> combinedFiles = new HashSet<GeoFile>(this.files);
        combinedFiles.add(file);
        return new GeoFileGroup(this.requiredContentCount, this.itemsMap, combinedFiles, combinedFeatures);
    }

    public boolean cannotImprove(GeoFileGroup best, int maxFeaturesPerFile) {
        if (this.content.size() == this.requiredContentCount) {
            return true;
        }
        if (this.files.size() == 3) {
            return true;
        }
        int upperFeatureBound = this.content.size() + (3 - this.files.size()) * maxFeaturesPerFile;
        return upperFeatureBound < best.content.size();
    }

    public boolean isBetter(GeoFileGroup o) {
        if (o == this) {
            return false;
        }
        int d = this.content.size() - o.content.size();
        if (d < 0) {
            return false;
        }
        if (d > 0) {
            return true;
        }
        d = this.files.size() - o.files.size();
        if (d < 0) {
            return true;
        }
        if (d > 0) {
            return false;
        }
        return this.area() < o.area();
    }

    private double area() {
        if (this.files.isEmpty()) {
            return 0.0;
        }
        if (this.totalBounds == null) {
            for (GeoFile f : this.files) {
                this.totalBounds = Rect.union(f.bounds, this.totalBounds);
            }
        }
        return this.totalBounds == null ? 0.0 : this.totalBounds.area();
    }

    public String toString() {
        return this.files + ":" + this.content.size() + "/" + this.requiredContentCount;
    }
}

