/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.color;

import java.awt.Color;
import org.brunel.color.Palette;
import org.brunel.data.Field;

public class ColorMapping {
    public final Object[] values;
    public final String[] colors;

    public ColorMapping(Object[] values, String[] colors) {
        this.values = values;
        this.colors = colors;
    }

    public ColorMapping fitColorsToCategories(Field f) {
        Object[] newValues = f.categories();
        int n = newValues.length;
        String[] newColors = new String[n];
        for (int i = 0; i < n; ++i) {
            newColors[i] = this.interpolateMapping((double)i / ((double)n - 1.0));
        }
        return new ColorMapping(newValues, newColors);
    }

    private String interpolateMapping(double v) {
        int n = this.colors.length - 1;
        int a = (int)Math.floor(v * (double)n);
        int b = (int)Math.ceil(v * (double)n);
        double r = v * (double)n - (double)a;
        return Palette.mid(this.colors[a], this.colors[b], r);
    }

    public ColorMapping mute(int muted) {
        float amount = (float)Math.pow(0.7, muted);
        String[] newColors = new String[this.colors.length];
        for (int i = 0; i < this.colors.length; ++i) {
            newColors[i] = this.mute(this.colors[i], amount);
        }
        return new ColorMapping(this.values, newColors);
    }

    private String mute(String color, float r) {
        Color base = Color.decode(color);
        float[] hsv = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), new float[3]);
        Color a = Color.getHSBColor(hsv[0], r * hsv[1], 1.0f - r + r * hsv[2]);
        return String.format("#%02X%02X%02X", a.getRed(), a.getGreen(), a.getBlue());
    }
}

