/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.util.ModelUtil;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ChartCoordinates {
    public final VisTypes.Coordinates coords;
    public final Field[] allXFields;
    public final Field[] allYFields;
    public final Field[] allXClusterFields;
    public final String xTransform;
    public final String yTransform;
    public final boolean xCategorical;
    public final boolean yCategorical;
    public final Double[] xExtent;
    public final Double[] yExtent;
    public final boolean xReversed;
    public final boolean yReversed;
    private final Map<VisSingle, Field[]> x = new HashMap<VisSingle, Field[]>();
    private final Map<VisSingle, Field[]> y = new HashMap<VisSingle, Field[]>();

    public ChartCoordinates(VisSingle[] elements, Dataset[] elementData, VisTypes.Diagram diagram) {
        boolean reverseY;
        this.coords = this.makeCombinedCoords(elements, diagram);
        String xTransform = null;
        String yTransform = null;
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        ArrayList<Field> allX = new ArrayList<Field>();
        ArrayList allY = new ArrayList();
        ArrayList<Field> allCluster = new ArrayList<Field>();
        for (int i = 0; i < elements.length; ++i) {
            VisSingle vis = elements[i];
            Field[] visXFields = this.getXFields(vis, elementData[i]);
            Field[] visYFields = this.getYFields(vis, elementData[i]);
            if (xTransform == null) {
                xTransform = this.getDefinedXTransform(vis);
            }
            if (yTransform == null) {
                yTransform = this.getDefinedYTransform(vis);
            }
            this.x.put(vis, visXFields);
            this.y.put(vis, visYFields);
            xMin = Math.min(xMin, this.getDefinedExtent(vis.fX, true));
            yMin = Math.min(yMin, this.getDefinedExtent(vis.fY, true));
            xMax = Math.max(xMax, this.getDefinedExtent(vis.fX, false));
            yMax = Math.max(yMax, this.getDefinedExtent(vis.fY, false));
            if (visXFields.length > 0) {
                allX.add(visXFields[0]);
            }
            if (visXFields.length > 1) {
                allCluster.add(visXFields[1]);
            }
            Collections.addAll(allY, visYFields);
        }
        this.xExtent = Double.isInfinite(xMin) && Double.isInfinite(xMax) ? null : new Double[]{Double.isInfinite(xMin) ? null : Double.valueOf(xMin), Double.isInfinite(xMax) ? null : Double.valueOf(xMax)};
        this.yExtent = Double.isInfinite(yMin) && Double.isInfinite(yMax) ? null : new Double[]{Double.isInfinite(yMin) ? null : Double.valueOf(yMin), Double.isInfinite(yMax) ? null : Double.valueOf(yMax)};
        this.allXFields = allX.toArray(new Field[allX.size()]);
        this.allYFields = allY.toArray(new Field[allY.size()]);
        this.allXClusterFields = allCluster.toArray(new Field[allCluster.size()]);
        this.xCategorical = ModelUtil.combinationIsCategorical(this.allXFields, true);
        this.yCategorical = ModelUtil.combinationIsCategorical(this.allYFields, true);
        this.xTransform = xTransform == null ? (this.xCategorical ? "linear" : this.chooseTransform(this.allXFields)) : xTransform;
        this.yTransform = yTransform == null ? (this.yCategorical ? "linear" : this.chooseTransform(this.allYFields)) : yTransform;
        boolean reverseX = this.isTransposed() ? this.xCategorical : false;
        boolean bl = reverseY = this.isTransposed() ? false : this.yCategorical;
        if (this.needsReverse(elements, true)) {
            boolean bl2 = reverseX = !reverseX;
        }
        if (this.needsReverse(elements, false)) {
            reverseY = !reverseY;
        }
        this.xReversed = reverseX;
        this.yReversed = reverseY;
    }

    private boolean needsReverse(VisSingle[] elements, boolean forX) {
        for (VisSingle element : elements) {
            List<Param> pp = forX ? element.fX : (element.fRange == null ? element.fY : Arrays.asList(element.fRange));
            for (Param p : pp) {
                for (Param m : p.modifiers()) {
                    if (!m.asString().equals("reverse")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPolar() {
        return this.coords == VisTypes.Coordinates.polar;
    }

    public boolean isTransposed() {
        return this.coords == VisTypes.Coordinates.transposed;
    }

    private VisTypes.Coordinates makeCombinedCoords(VisSingle[] elements, VisTypes.Diagram diagram) {
        if (diagram == VisTypes.Diagram.chord || diagram == VisTypes.Diagram.cloud) {
            return VisTypes.Coordinates.polar;
        }
        VisTypes.Coordinates result = elements[0].coords;
        for (VisSingle e : elements) {
            if (e.coords.compareTo(result) <= 0) continue;
            result = e.coords;
        }
        return result;
    }

    private double getDefinedExtent(List<Param> items, boolean min) {
        for (Param p : items) {
            if (!p.isField() || !p.hasModifiers()) continue;
            for (Param q : p.modifiers()) {
                List<Param> extent;
                if (q.type() != Param.Type.list || (extent = q.asList()).size() != 2) continue;
                Param e = extent.get(min ? 0 : 1);
                try {
                    return e.asDouble();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return min ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    private Field[] getXFields(VisSingle vis, Dataset data) {
        Field[] result = new Field[vis.fX.size()];
        for (int i = 0; i < vis.fX.size(); ++i) {
            result[i] = data.field(vis.fX.get(i).asField());
        }
        return result;
    }

    private Field[] getYFields(VisSingle vis, Dataset data) {
        if (vis.fRange != null) {
            return new Field[]{data.field(vis.fRange[0].asField(data)), data.field(vis.fRange[1].asField(data))};
        }
        if (vis.fY.isEmpty()) {
            return new Field[0];
        }
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                return data.fieldArray(new String[]{"#values$lower", "#values$upper"});
            }
            return data.fieldArray(new String[]{"#values"});
        }
        String s = vis.fY.get(0).asField();
        if (vis.stacked) {
            return data.fieldArray(new String[]{s + "$lower", s + "$upper"});
        }
        return data.fieldArray(new String[]{s});
    }

    private String getDefinedXTransform(VisSingle v) {
        for (Param p : v.fX) {
            String type;
            if (!p.isField() || !p.hasModifiers() || (type = this.extractTransform(p)) == null) continue;
            return type;
        }
        return null;
    }

    private String extractTransform(Param p) {
        for (Param q : p.modifiers()) {
            String type = q.asString();
            if (!type.equals("log") && !type.equals("linear") && !type.equals("root")) continue;
            return type;
        }
        return null;
    }

    private String getDefinedYTransform(VisSingle v) {
        for (Param p : v.fY) {
            String s;
            if (!p.isField() || !p.hasModifiers() || (s = this.extractTransform(p)) == null) continue;
            return s;
        }
        if (v.fRange != null) {
            String s;
            if (v.fRange[0].isField() && v.fRange[0].hasModifiers() && (s = this.extractTransform(v.fRange[0])) != null) {
                return s;
            }
            if (v.fRange[1].isField() && v.fRange[1].hasModifiers() && (s = this.extractTransform(v.fRange[1])) != null) {
                return s;
            }
        }
        return null;
    }

    private String chooseTransform(Field[] fields) {
        if (fields.length == 0) {
            return "linear";
        }
        String best = "linear";
        double min = Double.MAX_VALUE;
        for (Field f : fields) {
            if (f.min() == null) continue;
            Auto.setTransform((Field)f);
            String s = f.strProperty("transform");
            if ("log".equals(s)) {
                best = "log";
            } else if ("root".equals(s) && !best.equals("log")) {
                best = "root";
            }
            if (!f.isNumeric()) continue;
            min = Math.min(min, f.min());
        }
        if ("log".equals(best) && min <= 0.0) {
            return "linear";
        }
        return best;
    }

    public Field[] getX(VisSingle vis) {
        return this.x.get(vis);
    }

    public Field[] getY(VisSingle vis) {
        return this.y.get(vis);
    }
}

