/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.data.DataModifier;
import org.brunel.build.data.DataTransformParameters;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;

public class DataBuilder {
    private final DataModifier modifier;
    private final VisSingle vis;

    public DataBuilder(VisSingle vis) {
        this(vis, null);
    }

    public DataBuilder(VisSingle vis, DataModifier modifier) {
        this.vis = vis;
        this.modifier = modifier;
    }

    public Dataset build() {
        String constantsCommand = this.makeConstantsCommand();
        String filterCommand = this.makeFilterCommands();
        String eachCommand = this.makeEachCommands();
        String binCommand = this.makeTransformCommands();
        String summaryCommand = this.buildSummaryCommands();
        String sortCommand = this.makeFieldCommands();
        String seriesYFields = this.makeSeriesCommand();
        String usedFields = this.required();
        DataTransformParameters params = new DataTransformParameters(constantsCommand, filterCommand, eachCommand, binCommand, summaryCommand, "", sortCommand, "", seriesYFields, usedFields);
        if (this.modifier != null) {
            params = this.modifier.modifyParameters(params, this.vis);
        }
        Dataset data = this.vis.getDataset();
        data = data.addConstants(params.constantsCommand);
        data = data.each(params.eachCommand);
        data = data.filter(params.filterCommand);
        data = data.transform(params.transformCommand);
        data = data.summarize(params.summaryCommand);
        data = data.series(params.seriesCommand);
        data = data.sort(params.sortCommand);
        data = data.sortRows(params.sortRowsCommand);
        data = data.stack(params.stackCommand);
        data.set("parameters", (Object)params);
        return data;
    }

    public static Dataset getTransformedData(VisSingle vis) {
        return new DataBuilder(vis.makeCanonical()).build();
    }

    private int getParameterIntValue(Param param, int defaultValue) {
        if (param == null) {
            return defaultValue;
        }
        if (param.isField()) {
            return this.getParameterIntValue(param.firstModifier(), defaultValue);
        }
        return (int)param.asDouble();
    }

    String buildSummaryCommands() {
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        LinkedHashSet<String> fields = new LinkedHashSet<String>(Arrays.asList(this.vis.usedFields(false)));
        fields.remove("#series");
        fields.remove("#values");
        fields.remove("#all");
        for (Map.Entry<Param, String> entry : this.vis.fSummarize.entrySet()) {
            Param p = entry.getKey();
            String name = p.asField();
            String measure = entry.getValue();
            if (p.hasModifiers()) {
                measure = measure + ":" + p.firstModifier().asString();
            }
            spec.put(name, name + ":" + measure);
            fields.remove(name);
        }
        if (fields.contains("#count")) {
            spec.put("#count", "#count:sum");
            fields.remove("#count");
        }
        if (spec.isEmpty()) {
            return "";
        }
        for (Param param : this.vis.fX) {
            String field = param.asField();
            if (!fields.contains(field)) continue;
            spec.put(field, field + ":base");
            fields.remove(field);
        }
        for (String string : fields) {
            spec.put(string, string);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry e : spec.entrySet()) {
            result.add((String)e.getKey() + "=" + (String)e.getValue());
        }
        return Data.join(result, (String)"; ");
    }

    private String getParameterFieldValue(Param param) {
        String s;
        if (param != null && param.isField()) {
            return param.asField();
        }
        if (this.vis.fY.size() == 1 && !(s = this.vis.fY.get(0).asField()).startsWith("'") && !s.startsWith("#")) {
            return s;
        }
        if (this.vis.aestheticFields().length > 0) {
            return this.vis.aestheticFields()[0];
        }
        return "#row";
    }

    private String makeConstantsCommand() {
        ArrayList<String> toAdd = new ArrayList<String>();
        for (String f : this.vis.usedFields(false)) {
            if (f.startsWith("#") || this.vis.getDataset().field(f) != null) continue;
            toAdd.add(f);
        }
        return Data.join(toAdd, (String)"; ");
    }

    private String makeFieldCommands() {
        List<Param> params = this.vis.fSort;
        Object[] commands = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Param p = params.get(i);
            String s = p.asField();
            commands[i] = p.hasModifiers() ? s + ":" + p.firstModifier().asString() : s;
        }
        return Data.join((Object[])commands, (String)"; ");
    }

    private String makeFilterCommands() {
        String[] pos;
        ArrayList<String> commands = new ArrayList<String>();
        for (String s : pos = this.vis.positionFields()) {
            Field f = this.vis.getDataset().field(s);
            if (f == null || !(f.numProperty("valid") < (double)f.rowCount())) continue;
            commands.add(s + " valid");
        }
        for (Map.Entry<Param, String> e : this.vis.fTransform.entrySet()) {
            int N;
            String operation = e.getValue();
            Param key = e.getKey();
            String name = this.getParameterFieldValue(key);
            Field f = this.vis.getDataset().field(name);
            if (f == null) {
                N = this.vis.getDataset().rowCount();
            } else {
                name = f.name;
                N = f.valid();
            }
            if (name.equals("#row")) {
                if (operation.equals("top")) {
                    operation = "bottom";
                } else if (operation.equals("bottom")) {
                    operation = "top";
                }
            }
            int n = this.getParameterIntValue(key, 10);
            if (operation.equals("top")) {
                commands.add(name + " ranked 1," + n);
                continue;
            }
            if (operation.equals("bottom")) {
                commands.add(name + " ranked " + (N - n) + "," + N);
                continue;
            }
            if (operation.equals("inner")) {
                commands.add(name + " ranked " + n + "," + (N - n));
                continue;
            }
            if (!operation.equals("outer")) continue;
            commands.add(name + " !ranked " + n + "," + (N - n));
        }
        return Data.join(commands, (String)"; ");
    }

    private String makeEachCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (Map.Entry<Param, String> e : this.vis.fTransform.entrySet()) {
            String operation = e.getValue();
            Param key = e.getKey();
            String name = this.getParameterFieldValue(key);
            Field f = this.vis.getDataset().field(name);
            if (!operation.equals("each")) continue;
            commands.add(f.name);
        }
        return Data.join(commands, (String)"; ");
    }

    private String makeSeriesCommand() {
        if (this.vis.fY.size() < 2) {
            return "";
        }
        LinkedHashSet<String> keep = new LinkedHashSet<String>();
        for (Param p : this.vis.fX) {
            keep.add(p.asField());
        }
        Collections.addAll(keep, this.vis.nonPositionFields());
        keep.remove("#series");
        keep.remove("#values");
        StringBuilder b = new StringBuilder();
        for (Param p : this.vis.fY) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(p.asField());
        }
        b.append(";").append(Data.join(keep));
        return b.toString();
    }

    private String makeTransformCommands() {
        if (this.vis.fTransform.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Param, String> e : this.vis.fTransform.entrySet()) {
            Param p = e.getKey();
            String name = p.asField();
            String measure = e.getValue();
            if (!measure.equals("bin") && !measure.equals("rank")) continue;
            if (p.hasModifiers()) {
                measure = measure + ":" + p.firstModifier().asString();
            }
            if (b.length() > 0) {
                b.append("; ");
            }
            b.append(name).append("=").append(measure);
        }
        return b.toString();
    }

    private String required() {
        String[] fields = this.vis.usedFields(true);
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, fields);
        if (!result.contains("#row")) {
            result.add("#row");
        }
        if (!result.contains("#count")) {
            result.add("#count");
        }
        return Data.join(result, (String)"; ");
    }
}

