/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.titles;

import org.brunel.action.Param;
import org.brunel.build.d3.titles.TitleBuilder;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleTarget;

public class ChartTitleBuilder
extends TitleBuilder {
    private final String location;

    public ChartTitleBuilder(ChartStructure structure, String location) {
        super(ChartTitleBuilder.findTitleElement(structure), StyleTarget.makeTopLevelTarget(null, "title", location));
        this.location = location;
    }

    private static VisSingle findTitleElement(ChartStructure structure) {
        for (VisSingle vis : structure.elements) {
            if (vis.itemsTitle.isEmpty()) continue;
            return vis;
        }
        return structure.elements[0];
    }

    @Override
    protected void defineVerticalLocation(ScriptWriter out) {
        if ("header".equals(this.location)) {
            out.addChained("attr('y'," + this.padding.top + ").attr('dy','0.8em')");
        } else {
            out.addChained("attr('y','100%').attr('dy', -" + (this.padding.bottom + this.fontSize * 4 / 10) + ")");
        }
    }

    @Override
    protected String makeText() {
        if (this.vis == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (Param p : this.vis.itemsTitle) {
            String pType = "header";
            if (p.hasModifiers()) {
                pType = p.modifiers()[0].asString();
            }
            if (!pType.equals(this.location)) continue;
            if (p.isField()) {
                Dataset data = this.vis.getDataset();
                Field f = data.field(p.asField(data));
                if (f == null) {
                    throw new IllegalStateException("Unknown field: " + p.asString());
                }
                s.append(f.label);
                continue;
            }
            s.append(p.asString());
        }
        return s.toString();
    }
}

