/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.util.ModelUtil;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleTarget;

public class ElementDimension {
    public final ModelUtil.Size sizeStyle;
    public final String sizeFunction;
    public GeomAttribute center;
    public GeomAttribute left;
    public GeomAttribute right;
    public GeomAttribute size;
    public GeomAttribute clusterSize;

    public ElementDimension(VisSingle vis, String sizeName, ElementRepresentation representation, String[] classes) {
        StyleTarget target = StyleTarget.makeElementTarget(representation.getMark(), classes);
        this.sizeStyle = ModelUtil.getSize(vis, target, sizeName);
        this.sizeFunction = vis.fSize.isEmpty() ? null : (vis.fSize.size() == 1 ? "size(d)" : sizeName + "(d)");
    }

    public boolean defineUsingExtent() {
        if (this.center == null) {
            return true;
        }
        if (this.left == null || this.right == null) {
            return false;
        }
        return this.sizeStyle == null && this.sizeFunction == null;
    }
}

