/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class Tree
extends D3Diagram {
    private final Method method;
    private final int labelSize;
    private final int pad = 10;
    private final boolean usesSize;

    public Tree(VisSingle vis, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
        this.method = vis.coords == VisTypes.Coordinates.polar ? Method.polar : Method.leftRight;
        this.labelSize = this.labelBuilder.estimateLabelLength() * 6;
        this.usesSize = !vis.fSize.isEmpty();
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define tree (hierarchy) data structures");
        this.makeHierarchicalTree();
        this.out.add("var treeLayout = d3.tree()");
        if (this.method == Method.polar) {
            this.out.addChained("size([2*Math.PI, geom.inner_radius-" + (10 + this.labelSize) + "])").addChained("separation(function(a,b) { return (a.parent == b.parent ? 1 : 2) / a.depth })");
        } else {
            this.out.addChained("size([geom.inner_height-20, geom.inner_width-" + (20 + this.labelSize) + "])");
        }
        this.out.endStatement();
        this.out.add("var treeNodes = treeLayout(tree).descendants()").endStatement();
        if (this.method != Method.polar) {
            this.out.add("treeNodes.forEach( function(d) { d.x += 10; d.y += 10} )").endStatement();
        }
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        if (this.usesSize) {
            this.out.add("size = function(d) { return scale_size(d.value) }").endStatement();
        }
        ElementRepresentation rep = this.method == Method.leftRight ? ElementRepresentation.pointLikeCircle : ElementRepresentation.largeCircle;
        return ElementDetails.makeForDiagram(this.vis, rep, "point", "treeNodes");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('class', function(d) { return (d.children ? 'element L' + d.depth : 'leaf element " + this.element.name() + "') })");
        if (this.method == Method.leftRight) {
            this.out.addChained("attr('cx', function(d) { return scale_x(d.y) })").addChained("attr('cy', function(d) { return scale_y(d.x) })");
        } else if (this.method == Method.topBottom) {
            this.out.addChained("attr('cx', function(d) { return scale_x(d.x) })").addChained("attr('cy', function(d) { return scale_y(d.y) })");
        } else if (this.method == Method.polar) {
            this.out.addChained("attr('cx', function(d) { return scale_x(d.y * Math.cos(d.x)) })").addChained("attr('cy', function(d) { return scale_y(d.y * Math.sin(d.x)) })");
        }
        this.out.addChained("attr('r', " + details.overallSize.halved() + ")");
        this.addAestheticsAndTooltips(details);
        this.out.onNewLine().ln().comment("Add in the arcs on the outside for the groups");
        this.out.add("diagramExtras.attr('class', 'diagram tree edge')").endStatement();
        this.out.add("var edgeGroup = diagramExtras.selectAll('path').data(tree.links())").endStatement();
        this.out.add("var added = edgeGroup.enter().append('path').attr('class', 'edge')").endStatement();
        this.out.add("BrunelD3.transition(edgeGroup.merge(added), transitionMillis)").addChained("attr('d', function(d) {").indentMore().indentMore().onNewLine();
        if (this.method == Method.polar) {
            this.out.add("var r1 = d.source.y, a1 = d.source.x, r2 = d.target.y, a2 = d.target.x, r = (r1+r2)/2").endStatement().add("return 'M' + scale_x(r1*Math.cos(a1)) + ',' + scale_y(r1*Math.sin(a1)) ").continueOnNextLine(new String[0]).add(" + 'Q' +  scale_x(r*Math.cos(a2)) + ',' + scale_y(r*Math.sin(a2))").continueOnNextLine(new String[0]).add(" + ' ' +  scale_x(r2*Math.cos(a2)) + ',' + scale_y(r2*Math.sin(a2))").endStatement();
        } else {
            this.out.add("var x1 =  scale_x(d.source.y), y1 = scale_y(d.source.x), x2 = scale_x(d.target.y), y2 = scale_y(d.target.x)").endStatement().add("return 'M' + x1 + ',' + y1 ").continueOnNextLine(new String[0]).add(" + 'C' + (x1+x2)/2 + ',' + y1").continueOnNextLine(new String[0]).add(" + ' ' + (x1+x2)/2 + ',' + y2").continueOnNextLine(new String[0]).add(" + ' ' + x2 + ',' + y2").endStatement();
        }
        this.out.indentLess().indentLess().add("})").endStatement();
        this.labelBuilder.addTreeInternalLabelsOutsideNode(this.method == Method.leftRight || !this.usesSize ? "bottom" : "center");
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }

    @Override
    public boolean needsDiagramLabels() {
        return true;
    }

    private static enum Method {
        leftRight,
        topBottom,
        polar;

    }
}

