/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleTarget;

public class D3LabelBuilder {
    private final VisSingle vis;
    private final ScriptWriter out;
    private final Dataset data;

    public D3LabelBuilder(VisSingle vis, ScriptWriter out, Dataset data) {
        this.vis = vis;
        this.out = out;
        this.data = data;
    }

    public void addElementLabeling() {
        if (this.vis.itemsLabel.isEmpty()) {
            return;
        }
        if (this.vis.tDiagram == VisTypes.Diagram.network) {
            this.out.add("BrunelD3.label(merged, labels, labeling, 0, geom)").endStatement();
            return;
        }
        if (this.vis.tElement != VisTypes.Element.text) {
            this.out.add("BrunelD3.label(merged, labels, labeling, transitionMillis, geom)").endStatement();
        }
    }

    public static void addFontSizeAttribute(VisSingle vis, ScriptWriter out) {
        if (!vis.fSize.isEmpty()) {
            StyleTarget target = StyleTarget.makeElementTarget("text", "label");
            ModelUtil.Size parts = ModelUtil.getSize(vis, target, "font-size");
            if (parts == null) {
                out.addChained("style('font-size', function(d) { return (100*size(d)) + '%' })");
            } else {
                out.addChained("style('font-size', function(d) { return (", parts.value(12.0), "* size(d)) +'" + parts.suffix() + "' })");
            }
        }
    }

    public void addTooltips(ElementDetails details) {
        if (this.vis.itemsTooltip.isEmpty()) {
            return;
        }
        this.out.onNewLine().ln();
        this.defineLabeling(this.prettify(this.vis.itemsTooltip, true), details.representation.getTooltipTextMethod(), true, true, null, 0.0, 0);
        this.out.add("BrunelD3.addTooltip(merged, tooltipLabeling, geom)").endStatement();
    }

    public void defineLabeling(List<Param> items, String textMethod, boolean forTooltip, boolean fitsShape, String alignment, double padding, int hitDetectGranularity) {
        if (this.vis.tElement != VisTypes.Element.text && items.isEmpty()) {
            return;
        }
        String name = forTooltip ? "tooltipLabeling" : "labeling";
        this.out.add("var", name, "= {").ln().indentMore();
        boolean fit = true;
        if (textMethod.equals("geo")) {
            String func = "function(box,text,d) {var p = projection([d.geo_properties.c, d.geo_properties.d]); return {box:box, x:p[0], y:p[1]}}";
            this.out.onNewLine().add("where:", func, ",");
        } else {
            HashSet<String> parts = new HashSet<String>(Arrays.asList(textMethod.split("-")));
            boolean inside = this.isInside(parts, fitsShape);
            String method = this.getMethod(parts);
            String location = this.getLocation(parts);
            String align = alignment != null ? alignment : this.getAlignment(parts, inside);
            double offset = this.getOffset(parts, inside);
            fit = inside && fitsShape;
            this.out.onNewLine().add("method:", Data.quote((String)method)).add(", location:", location).add(", inside:", inside).add(", align:", Data.quote((String)align)).add(", pad:", padding).add(", dy:", offset, ",");
        }
        this.out.onNewLine().add("fit:", fit, ", granularity:", hitDetectGranularity, ",");
        if (textMethod.equals("path") || textMethod.equals("wedge")) {
            this.out.onNewLine().add("path: path,");
        }
        this.out.onNewLine().add("content: function(d) {").indentMore();
        if (this.needsData(items)) {
            this.out.onNewLine().add("return d.row == null ? null : ");
        } else {
            this.out.onNewLine().add("return ");
        }
        this.writeContent(items, forTooltip);
        this.out.indentLess().onNewLine().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    public int estimateLabelLength() {
        int size = 0;
        for (Param p : this.vis.itemsLabel) {
            if (p.isField()) {
                Field f = this.data.field(p.asField());
                if (f.isDate()) {
                    size += 8;
                    continue;
                }
                if (f.preferCategorical()) {
                    size += this.maxLength(f.categories()) + 1;
                    continue;
                }
                size += 6;
                continue;
            }
            size += p.asString().length() + 1;
        }
        return size;
    }

    private int maxLength(Object[] categories) {
        int max = 0;
        for (Object o : categories) {
            max = Math.max(max, o.toString().length());
        }
        return max;
    }

    private boolean needsData(List<Param> items) {
        for (Param p : this.prettify(items, false)) {
            if (!p.isField()) continue;
            return true;
        }
        return false;
    }

    private double getOffset(HashSet<String> parts, boolean inside) {
        if (parts.contains("top")) {
            return inside ? 0.7 : -0.25;
        }
        if (parts.contains("bottom")) {
            return inside ? -0.25 : 0.7;
        }
        return 0.3;
    }

    private String getAlignment(HashSet<String> parts, boolean inside) {
        if (parts.contains("left")) {
            return inside ? "start" : "end";
        }
        if (parts.contains("right")) {
            return inside ? "end" : "start";
        }
        return "middle";
    }

    private boolean isInside(HashSet<String> parts, boolean fitsShape) {
        if (parts.contains("inside")) {
            return true;
        }
        if (parts.contains("outside")) {
            return false;
        }
        return fitsShape;
    }

    private String getMethod(HashSet<String> parts) {
        for (String s : parts) {
            if (!s.equals("path") && !s.equals("wedge") && !s.equals("area") && !s.equals("poly") && !s.equals("geo")) continue;
            return s;
        }
        return "box";
    }

    private String getLocation(HashSet<String> parts) {
        String h = "center";
        String v = "center";
        if (parts.contains("left")) {
            h = "left";
        }
        if (parts.contains("right")) {
            h = "right";
        }
        if (parts.contains("top")) {
            v = "top";
        }
        if (parts.contains("bottom")) {
            v = "bottom";
        }
        return "['" + h + "', '" + v + "']";
    }

    private List<Param> prettify(List<Param> items, boolean longForm) {
        if (items.size() < 2) {
            return items;
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < items.size(); ++i) {
            Param p = items.get(i);
            if (!p.isField()) {
                return items;
            }
            Field f = this.data.field(p.asField());
            if (i > 0) {
                result.add(Param.makeString(longForm ? "<br/>" : ", "));
            }
            if (longForm) {
                result.add(Param.makeString("<span class=\"title\">" + f.label + ": </span>"));
            }
            result.add(p);
        }
        return result;
    }

    public void writeContent(List<Param> items, boolean forTooltip) {
        if (items.isEmpty()) {
            if (this.vis.tDiagram != null) {
                items = Param.makeFields(this.vis.positionFields());
            }
            if (items.isEmpty()) {
                items = Collections.singletonList(Param.makeField("#row"));
            }
        }
        boolean first = true;
        for (Param p : this.prettify(items, false)) {
            if (!first) {
                this.out.add("\n\t\t\t+ ");
            }
            if (p.isField()) {
                Field f = this.data.field(p.asField());
                if (forTooltip) {
                    this.out.add("'<span class=\"field\">' + ");
                }
                if (p.hasModifiers()) {
                    this.out.add("BrunelD3.shorten(");
                }
                this.out.add("data." + D3Util.baseFieldID(f) + "_f(d)");
                if (p.hasModifiers()) {
                    this.out.add(",", (int)p.firstModifier().asDouble(), ")");
                }
                if (forTooltip) {
                    this.out.add(" + '</span>'");
                }
            } else {
                String o = p.asString();
                if (forTooltip) {
                    o = o.replaceAll("\\\\n", "&#10;");
                }
                this.out.add(Data.quote((String)o));
            }
            first = false;
        }
    }

    public void addTreeInternalLabelsInsideNode() {
        this.out.add("diagramLabels.attr('class', 'axis diagram treemap hierarchy')").endStatement().add("var treeLabeling = { method:'inner-left', fit:true, dy:0.83, align:'start', ").indentMore().onNewLine().add("content:  function(d) { return d.data.innerNodeName },").onNewLine().add("cssClass: function(d) { return 'axis label L' + d.depth + ' H' + d.height }, ").onNewLine().add("where :   function(box) { return {'x': box.x + 2, 'y': box.y, 'box': box} }").indentLess().onNewLine().add("}").endStatement();
        this.out.add("BrunelD3.label(merged.filter(function(d) {return d.height}), diagramLabels, treeLabeling, transitionMillis, geom)").endStatement();
    }

    public void addTreeInternalLabelsOutsideNode(String vertical) {
        String dy = vertical.equals("bottom") ? "0.75" : "0.25";
        this.out.add("diagramLabels.attr('class', 'axis diagram tree hierarchy')").endStatement().add("var treeLabeling = { location:['center', '" + vertical + "'], fit:false, dy:" + dy + ", align:'middle', granularity:1, ").indentMore().onNewLine().add("content:  function(d) { return d.data.innerNodeName },").onNewLine().add("cssClass: function(d) { return 'axis label L' + d.depth + ' H' + d.height } ").indentLess().onNewLine().add("}").endStatement();
        this.out.add("BrunelD3.label(merged.filter(function(d) {return d.height}), diagramLabels, treeLabeling, transitionMillis, geom)").endStatement();
    }
}

