/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.brunel.build.d3.titles.AxisTitleBuilder;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.Padding;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.util.Range;
import org.brunel.model.VisSingle;
import org.brunel.model.style.StyleTarget;

public class AxisDetails {
    public final String title;
    public final String scale;
    public final boolean hasGrid;
    public final StyleTarget styleTarget;
    public boolean rotatedTicks;
    public Object[] tickValues;
    public Integer tickCount;
    public int size;
    public int leftGutter;
    public int rightGutter;
    public int topGutter;
    public int bottomGutter;
    public int fontSize;
    public Padding tickPadding;
    public int markSize;
    private final Field[] fields;
    public final boolean categorical;
    private final boolean inMillions;
    private AxisTitleBuilder titleBuilder;

    public AxisDetails(String dimension, Field[] definedFields, boolean categorical, String userTitle, int tickCount, boolean grid) {
        this.scale = "scale_" + dimension;
        this.fields = definedFields;
        this.categorical = categorical;
        Integer n = this.tickCount = tickCount < 100 ? Integer.valueOf(tickCount) : null;
        this.title = userTitle != null ? (userTitle.isEmpty() ? null : userTitle) : AxisDetails.title(this.fields);
        this.inMillions = !categorical && this.isInMillions(definedFields);
        this.hasGrid = grid;
        this.styleTarget = StyleTarget.makeTopLevelTarget("g", "axis", this.isX() ? "x" : "y");
    }

    public boolean isX() {
        return this.scale.endsWith("x");
    }

    public void setAdditionalHAxisOffset(double additionalHAxisOffset) {
        if (this.exists()) {
            this.titleBuilder.bottomOffset = additionalHAxisOffset;
        }
    }

    public void setTextDetails(ChartStructure structure, boolean isHorizontal) {
        if (!this.exists()) {
            return;
        }
        VisSingle vis = this.findLikelyElement(structure);
        this.titleBuilder = new AxisTitleBuilder(vis, this, isHorizontal);
        StyleTarget tick = StyleTarget.makeTarget("g", this.styleTarget, "tick");
        StyleTarget mark = StyleTarget.makeTarget("line", tick, new String[0]);
        StyleTarget text = StyleTarget.makeTarget("text", tick, new String[0]);
        this.tickPadding = ModelUtil.getPadding(vis, text, 3);
        this.fontSize = (int)ModelUtil.getFontSize(vis, text, 12);
        this.markSize = (int)ModelUtil.getSize(vis, mark, "size", 3.0);
    }

    private VisSingle findLikelyElement(ChartStructure structure) {
        for (VisSingle vis : structure.elements) {
            if (vis.fAxes.isEmpty()) continue;
            return vis;
        }
        for (VisSingle vis : structure.elements) {
            if (vis.styles == null) continue;
            return vis;
        }
        return structure.elements[0];
    }

    public void writeTitle(String group, ScriptWriter out) {
        this.titleBuilder.writeContent(group, out);
    }

    private boolean isInMillions(Field[] definedFields) {
        for (Field f : definedFields) {
            if (f.isDate() || f.max() == null || !(f.max() - f.min() > 2000000.0)) continue;
            return true;
        }
        return false;
    }

    private static String title(Field[] fields) {
        ArrayList<Field> real = new ArrayList<Field>();
        for (Field f : fields) {
            if (f.isSynthetic() || f.name.startsWith("'")) continue;
            real.add(f);
        }
        LinkedHashSet<String> titles = new LinkedHashSet<String>();
        LinkedHashSet<String> originalTitles = new LinkedHashSet<String>();
        for (Field f : real) {
            titles.add(f.label);
            String originalLabel = (String)f.property("originalLabel");
            originalTitles.add(originalLabel == null ? f.label : originalLabel);
        }
        if (originalTitles.size() < titles.size()) {
            titles = originalTitles;
        }
        return titles.isEmpty() ? null : Data.join(titles);
    }

    public boolean inMillions() {
        return this.inMillions;
    }

    public boolean isLog() {
        return this.fields.length > 0 && "log".equals(this.fields[0].property("transform"));
    }

    public void layoutHorizontally(double availableSpace, boolean fillToEdge) {
        if (!this.exists()) {
            return;
        }
        int tickWidth = this.maxCategoryWidth() + 5;
        if ((double)tickWidth > availableSpace * 0.5) {
            tickWidth = (int)(availableSpace * 0.5);
        }
        int tickCount = this.countTicks(this.fields);
        if (!this.categorical) {
            fillToEdge = true;
        }
        if (fillToEdge) {
            availableSpace -= (double)tickWidth;
        }
        int spaceForOneTick = (int)(availableSpace / (double)tickCount);
        if (this.categorical && availableSpace < (double)(tickWidth * tickCount)) {
            this.rotatedTicks = true;
            this.tickValues = this.makeSkippingTickValues(availableSpace, tickCount);
            int tickHeight = (int)((double)tickWidth / Math.sqrt(2.0));
            this.size = tickHeight + this.fontSize + this.spaceForMarks() + this.estimatedTitleHeight();
            if (fillToEdge) {
                this.rightGutter = 10;
                this.leftGutter = tickHeight - 8;
            } else {
                this.rightGutter = Math.max(0, 10 - spaceForOneTick / 2);
                this.leftGutter = Math.max(0, tickHeight - 8 - spaceForOneTick / 2);
            }
        } else {
            this.size = this.estimatedSimpleSizeWhenHorizontal();
            this.leftGutter = fillToEdge ? tickWidth / 2 : Math.max(0, tickWidth / 2 - spaceForOneTick / 2);
            this.rightGutter = this.leftGutter;
            if (availableSpace < (double)(tickWidth * tickCount) && this.tickCount == null) {
                this.tickCount = (int)(availableSpace / (double)(tickWidth + 5));
            }
        }
    }

    public boolean exists() {
        return this.fields.length > 0;
    }

    public int maxCategoryWidth() {
        if (this.fields.length == 0) {
            return 0;
        }
        int maxCharCount = 1;
        for (Field f : this.fields) {
            Double[] sampleTicks;
            if (this.categorical) {
                for (Object s : f.categories()) {
                    int length = f.format(s).length();
                    if (s instanceof Range) {
                        ++length;
                    }
                    maxCharCount = Math.max(maxCharCount, length);
                }
                continue;
            }
            for (Double s : sampleTicks = Auto.makeNumericScale((Field)f, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.0, (int)5, (boolean)false).divisions) {
                maxCharCount = Math.max(maxCharCount, f.format((Object)s).length());
            }
            maxCharCount = Math.max(maxCharCount, 3);
        }
        return this.estimatedTickLength(maxCharCount);
    }

    private int countTicks(Field[] fields) {
        if (!this.categorical) {
            return 10;
        }
        if (fields.length == 0) {
            return 1;
        }
        int n = 0;
        for (Field f : fields) {
            n += f.categories().length;
        }
        return n;
    }

    private Object[] makeSkippingTickValues(double width, int count) {
        if (!this.categorical) {
            return null;
        }
        double spacePerTick = width / (double)count;
        int skipFrequency = (int)Math.round((double)(this.fontSize * 3 / 2 + this.tickPadding.vertical()) / spacePerTick);
        if (skipFrequency < 2) {
            return null;
        }
        ArrayList<Object> useThese = new ArrayList<Object>();
        int at = 0;
        for (Field f : this.fields) {
            for (Object s : f.categories()) {
                if (at++ % skipFrequency != 0) continue;
                useThese.add(s);
            }
        }
        return useThese.toArray(new Object[useThese.size()]);
    }

    private int estimatedTitleHeight() {
        return (int)this.titleBuilder.verticalSpace();
    }

    public int estimatedSimpleSizeWhenHorizontal() {
        return this.exists() ? this.fontSize + this.tickPadding.vertical() + this.spaceForMarks() + this.estimatedTitleHeight() : 0;
    }

    private int spaceForMarks() {
        return Math.max(this.markSize, 0);
    }

    public void layoutVertically(double availableSpace) {
        if (!this.exists()) {
            return;
        }
        int tickCount = this.countTicks(this.fields);
        this.topGutter = 5;
        this.bottomGutter = 5;
        availableSpace -= (double)(this.topGutter + this.bottomGutter);
        if (this.categorical) {
            this.tickValues = this.makeSkippingTickValues(availableSpace, tickCount);
        } else {
            int tickHeight = this.fontSize * 3 / 4;
            if ((double)(tickHeight * tickCount) > availableSpace && this.tickCount == null) {
                this.tickCount = (int)(availableSpace / (double)tickHeight);
            }
        }
        this.size = this.tickValues == null ? this.maxCategoryWidth() : this.maxTickWidth();
        this.size += this.estimatedTitleHeight() + this.spaceForMarks();
    }

    private int maxTickWidth() {
        int maxCharCount = 1;
        for (Object s : this.tickValues) {
            int length = s.toString().length();
            if (s instanceof Range) {
                ++length;
            }
            maxCharCount = Math.max(maxCharCount, length);
        }
        return this.estimatedTickLength(maxCharCount);
    }

    private int estimatedTickLength(int maxCharCount) {
        return this.tickPadding.horizontal() + maxCharCount * (this.fontSize + 1) / 2;
    }
}

