/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class UserFileValidator
implements Validator<String> {
    private static final Logger logger = Logger.getLogger(UserFileValidator.class);

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        if (context == null || context.getSpace() == null) {
            logger.debug((Object)String.format("Can't check the validity of the variable value [%s], because missing the access to the scheduler user data space", parameterValue));
            return parameterValue;
        }
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            throw new ValidationException("Please provide a valid file path in the user space as the variable value.");
        }
        try {
            if (!context.getSpace().checkFileExists("USERSPACE", parameterValue)) {
                throw new ValidationException(String.format("Could not find the file path [%s] in the user data space. Please add the file into the user data space or change the variable value to a valid path.", parameterValue));
            }
            if (context.getSpace().isFolder("USERSPACE", parameterValue)) {
                throw new ValidationException(String.format("The file path [%s] in the user data space is a folder instead of a regular file. Please change the variable value to a valid path of a regular file.", parameterValue));
            }
        }
        catch (NotConnectedException | PermissionException e) {
            throw new ValidationException("Could not read user data space files from the scheduler, make sure you are connected and you have permission rights to read user data space files.", e);
        }
        return parameterValue;
    }
}

