#!/usr/bin/env python

import dbexceptions
import unittest
import sys, os

from rdbhdb import rdbhdb

need_version = '0.9.1'

class test_Rdbhdb(dbexceptions.DatabaseExcTest):
    driver = rdbhdb
    
        # get choice of server from environment
    HOST = os.environ.get('RDBHOST_TEST',"dev.rdbhost.com").strip("'")
    #print >> sys.stderr, 'Using SERVER', HOST

    connect_args = ()
    connect_kw_args = {
        'role' : 's0000000004',
        'authcode' : "ccUgclJl1xMZ0y1B2PQ2xRWYZX2akgaH6Ii7pmWmPnCGgqN1wO",
        'host' : HOST }

    lower_func = 'lower' # For stored procedure test

    def setUp(self):
        # Call superclass setUp In case this does something in the
        # future
        dbexceptions.DatabaseExcTest.setUp(self) 

        try:
            con = self._connect()
            con.close()
        except Exception, e:
            print 'connection not made. %s db must be created online.'%e[0]
            sys.exit(2)

    def tearDown(self):
        dbexceptions.DatabaseExcTest.tearDown(self)

    def test0_host(self):
        print 'using server', self.HOST
        
    def test1_version(self):
        self.assert_(rdbhdb.__version__==need_version,rdbhdb.__version__)


if __name__ == '__main__':
    unittest.main()
    