# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrestazure import AzureConfiguration

from .version import VERSION


class BatchServiceClientConfiguration(AzureConfiguration):
    """Configuration for BatchServiceClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param batch_url: The base URL for all Azure Batch service requests.
    :type batch_url: str
    """

    def __init__(
            self, credentials, batch_url):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if batch_url is None:
            raise ValueError("Parameter 'batch_url' must not be None.")
        base_url = '{batchUrl}'

        super(BatchServiceClientConfiguration, self).__init__(base_url)

        # Starting Autorest.Python 4.0.64, make connection pool activated by default
        self.keep_alive = True

        self.add_user_agent('azure-batch/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.batch_url = batch_url
