# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VolumeResourceDescription(Model):
    """This type describes a volume resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Volume resource.
    :type name: str
    :param description: User readable description of the volume.
    :type description: str
    :ivar status: Status of the volume. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the volume.
    :vartype status_details: str
    :ivar provider: Required. Provider of the volume. Default value:
     "SFAzureFile" .
    :vartype provider: str
    :param azure_file_parameters: This type describes a volume provided by an
     Azure Files file share.
    :type azure_file_parameters:
     ~azure.servicefabric.models.VolumeProviderParametersAzureFile
    """

    _validation = {
        'name': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'provider': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'azure_file_parameters': {'key': 'properties.azureFileParameters', 'type': 'VolumeProviderParametersAzureFile'},
    }

    provider = "SFAzureFile"

    def __init__(self, **kwargs):
        super(VolumeResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.status = None
        self.status_details = None
        self.azure_file_parameters = kwargs.get('azure_file_parameters', None)
