# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .backup_schedule_description_py3 import BackupScheduleDescription


class TimeBasedBackupScheduleDescription(BackupScheduleDescription):
    """Describes the time based backup schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_kind: Required. Constant filled by server.
    :type schedule_kind: str
    :param schedule_frequency_type: Required. Describes the frequency with
     which to run the time based backup schedule. Possible values include:
     'Invalid', 'Daily', 'Weekly'
    :type schedule_frequency_type: str or
     ~azure.servicefabric.models.BackupScheduleFrequencyType
    :param run_days: List of days of a week when to trigger the periodic
     backup. This is valid only when the backup schedule frequency type is
     weekly.
    :type run_days: list[str or ~azure.servicefabric.models.DayOfWeek]
    :param run_times: Required. Represents the list of exact time during the
     day in ISO8601 format. Like '19:00:00' will represent '7PM' during the
     day. Date specified along with time will be ignored.
    :type run_times: list[datetime]
    """

    _validation = {
        'schedule_kind': {'required': True},
        'schedule_frequency_type': {'required': True},
        'run_times': {'required': True},
    }

    _attribute_map = {
        'schedule_kind': {'key': 'ScheduleKind', 'type': 'str'},
        'schedule_frequency_type': {'key': 'ScheduleFrequencyType', 'type': 'str'},
        'run_days': {'key': 'RunDays', 'type': '[str]'},
        'run_times': {'key': 'RunTimes', 'type': '[iso-8601]'},
    }

    def __init__(self, *, schedule_frequency_type, run_times, run_days=None, **kwargs) -> None:
        super(TimeBasedBackupScheduleDescription, self).__init__(**kwargs)
        self.schedule_frequency_type = schedule_frequency_type
        self.run_days = run_days
        self.run_times = run_times
        self.schedule_kind = 'TimeBased'
