# -*- coding: utf-8 -*-

"""
A Django saddle site configuration by nl_0 <nl_0 at mail dot ru>.
Inspired by and partially based on django-harness (http://bitbucket.org/neithere/django-harness/)
by Andy Mikhailenko <andy at neithere dot net>.
The most recent version can be found at http://bitbucket.org/nl_0/django-saddle/
"""

# DO NOT EDIT THIS FILE!
# Please edit project/settings.py to override attributes defined here or add your own ones.

import os.path
import random
import sys

# Set project root relative to manage.py
PROJECT_ROOT = sys.path[0]

# Append to project root path if relative.
# This function is only used within this file.
def at_project_root(*args):
    arg=os.path.join(*args)
    return arg if arg.startswith('/') or arg[1]==':' else os.path.join(PROJECT_ROOT, arg)

# Define paths where to look for your Django apps.
# The project root should remain in the first position.
for p in (at_project_root('apps'),): #order is reversed
    sys.path.insert(1, p)

DEBUG = False

# Local time zone for this installation. All choices can be found here:
# http://www.postgresql.org/docs/8.1/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
TIME_ZONE = 'Europe/UK'

# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'en'

SITE_ID = 1

APPEND_SLASH = True

# These constants appear in default templates and are useful for basic SEO
SITE_NAME = SITE_KEYWORDS = SITE_DESCRIPTION = ''

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT  = at_project_root('media')
STATIC_ROOT = at_project_root('static')

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL  = '/media/'
STATIC_URL = '/static/'

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/admin-media/'

# Don't share it with anybody
if not hasattr(globals(), 'SECRET_KEY'):
    secret_file = at_project_root('local_secret.txt')
    try:
        SECRET_KEY = open(secret_file).read().strip()
    except IOError:
        try:
            chars = 'abcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*(-_=+)'
            SECRET_KEY = ''.join([random.choice(chars) for i in range(50)])
            secret = file(secret_file, 'w')
            secret.write(SECRET_KEY)
            secret.close()
        except IOError:
            raise Exception('Please create file %s filled with random characters'
                            ' to serve as your secret key.' % secret_file)
    del secret_file

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    #('django.template.loaders.cached.Loader', (
        'django.template.loaders.filesystem.load_template_source',
        'django.template.loaders.app_directories.load_template_source',
        #'django.template.loaders.eggs.Loader',
    #)),
)

MIDDLEWARE_CLASSES = (
    'django.middleware.cache.UpdateCacheMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
)
try:
    import django.contrib.messages.middleware.MessageMiddleware
    MIDDLEWARE_CLASSES+=('django.contrib.messages.middleware.MessageMiddleware',)
except ImportError: pass
MIDDLEWARE_CLASSES+=(
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.doc.XViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    #'django.contrib.csrf.middleware.CsrfMiddleware',
    'django.middleware.cache.FetchFromCacheMiddleware',
)

TEMPLATE_CONTEXT_PROCESSORS = [
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.media",
    "django.core.context_processors.request",
]
try:
    import django.contrib.auth.context_processors.auth
    TEMPLATE_CONTEXT_PROCESSORS+=[
        "django.contrib.auth.context_processors.auth",
        "django.contrib.messages.context_processors.messages",
    ]
except ImportError:
    TEMPLATE_CONTEXT_PROCESSORS+=["django.core.context_processors.auth"]

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
)

ROOT_URLCONF = 'project.urls'

TEMPLATE_DIRS = (
    at_project_root('project', 'templates'),
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.admin',
    'south',
    'django_extensions',
)
try:
    import django.contrib.messages
    INSTALLED_APPS+=('django.contrib.messages',)
except ImportError: pass

# Override some constants with site-specific ones
try:
    from project.settings import *
except ImportError:
    import sys
    sys.stderr.write('Unable to read settings.py\n')
    sys.exit(1)

# Override even site-specific constants with installation-related ones
# (e.g. locally use a test SQLite database instead of MySQL on production server)
try:
    from project.settings_local import *
except ImportError: pass

# Warn if project is marked as designed for a version of Django different from current.
# This can give a hint if something gets broken.
try:
    ver = REQUIRE_DJANGO_VERSION
    if isinstance(ver, (basestring, float)):
        ver = tuple(int(x) for x in str(ver).split('.'))
    assert isinstance(ver, tuple), ('DJANGO_VERSION must be string, float or '
                                    'tuple, e.g. "1.0", 1.0 or (1,0).')
    assert 1 < len(ver) < 3, 'DJANGO_VERSION tuple must contain between 1 and 3 integers'
    for i in range(0, len(ver)):
        assert isinstance(ver[i], int), 'Integer expected at DJANGO_VERSION[%d] but got %s' % (i, type(ver[i]))
    from django import VERSION, get_version
    if not ver == VERSION[:len(ver)]:
        str_ver = '.'.join(str(i) for i in ver)
        msg = 'This project was designed for Django %s. You have Django %s installed.\n'\
              'Please ensure there are no problems and update REQUIRE_DJANGO_VERSION '\
              'variable in project settings.' % (str_ver, get_version())
        from warnings import warn
        warn(msg, UserWarning)
    # cleanup
    del(VERSION)
    del(get_version)
except:
    pass


try:
    MANAGERS = ADMINS
except NameError:
    raise NameError, "ADMINS variable must be specified in this form: (('Your Name', 'your_email@domain.com'),)"

try:
    TEMPLATE_DEBUG
except NameError:
    TEMPLATE_DEBUG = DEBUG

try:
    INSTALLED_APPS += ADDITIONAL_APPS
except NameError: pass

try:
    MIDDLEWARE_CLASSES += ADDITIONAL_MIDDLEWARE
except NameError: pass

try:
    TEMPLATE_CONTEXT_PROCESSORS += ADDITIONAL_TEMPLATE_CONTEXT_PROCESSORS
except NameError: pass

try:
    if DEBUG_TOOLBAR_ON and DEBUG:
        MIDDLEWARE_CLASSES+=('debug_toolbar.middleware.DebugToolbarMiddleware',)
        INSTALLED_APPS+=('debug_toolbar',)
        DEBUG_TOOLBAR_PANELS = (
            'debug_toolbar.panels.version.VersionDebugPanel',
            'debug_toolbar.panels.timer.TimerDebugPanel',
            'debug_toolbar.panels.settings_vars.SettingsVarsDebugPanel',
            'debug_toolbar.panels.headers.HeaderDebugPanel',
            'debug_toolbar.panels.request_vars.RequestVarsDebugPanel',
            'debug_toolbar.panels.template.TemplateDebugPanel',
            'debug_toolbar.panels.sql.SQLDebugPanel',
            'debug_toolbar.panels.signals.SignalDebugPanel',
            'debug_toolbar.panels.logger.LoggingPanel',
        )
        DEBUG_TOOLBAR_CONFIG = {
            'INTERCEPT_REDIRECTS': False,
            'HIDE_DJANGO_SQL': False,
        }
except NameError: pass

try:
    EMAIL_FILE_PATH=at_project_root(EMAIL_FILE_PATH)
except NameError: pass

# Virtual environment support. If VIRTUALENV is defined and not empty, we will
# use its site-packages.
try:
    if VIRTUALENV:
        if '/site-packages/' not in VIRTUALENV:
            VIRTUALENV_ROOT=VIRTUALENV
            # assert partial path is defined, i.e. the VE root path, not that
            # of the site-packages directory, so add the necessary info
            import platform
            if platform.system()!='Windows':
                _ver = ('python%d.%d' % (sys.version_info[0], sys.version_info[1]),)
            else: _ver = ()
            _new_path = os.path.join(VIRTUALENV, *(('lib',)+_ver+('site-packages',)))
            VIRTUALENV = _new_path
            del _new_path, _ver
        else:
            VIRTUALENV_ROOT=os.path.normpath(os.path.join(VIRTUALENV,
                *(('..',)*(2 if platform.system()=='Windows' else 3))))
        #print '(saddle) Using virtual environment', VIRTUALENV_ROOT
        #print '(saddle) Adding site packages from', VIRTUALENV
        import site
        site.addsitedir(VIRTUALENV)
except NameError:
    VIRTUALENV = None

#defaults for django-cms-2.0
if 'cms' in INSTALLED_APPS:
    try:
        CMS_MEDIA_URL='/cms-media/'
    except ImportError: pass

try:
    WWW_HANDLER
except NameError:
    WWW_HANDLER='wsgi' #possible choices: wsgi, mod_python
