# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from msrest import Deserializer, Serializer
from azure.core import PipelineClient

from ._configuration import SearchServiceClientConfiguration
from .operations import IndexesOperations
from .operations import SearchServiceClientOperationsMixin
from . import models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any



class SearchServiceClient(SearchServiceClientOperationsMixin):
    """Client that can be used to manage and query indexes and documents,
        as well as manage other resources, on a search service.

    :param endpoint: The endpoint URL of the search service.
    :type endpoint: str
    :keyword int polling_interval: Default waiting time between two polls
        for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        endpoint,  # type: str
        **kwargs  # type: Any
    ):  # pylint: disable=missing-client-constructor-parameter-credential
        # type: (...) -> None
        base_url = '{endpoint}'
        self._config = SearchServiceClientConfiguration(endpoint, **kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.indexes = IndexesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> SearchServiceClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
