# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.
"""
A view of a generator function.

>>> def my_xrange(n):
...     i = 0
...     while i < n:
...         yield i
...         i = i + 1
... 
>>> gw = GeneratorView(my_xrange, 5)
>>> print [x for x in gw]
[0, 1, 2, 3, 4]
>>> print [x for x in gw]
[0, 1, 2, 3, 4]

Note: if each call to the generator returns a different sequence, this type will return that
different sequence.
"""

from ..picklablepartial import PicklablePartial as partial

__all__ = ['GeneratorView']

class GeneratorView(object):
    __slots__ = ['_func']

    def __init__(self, generator, *args, **kws):
        self._func = partial(generator, *args, **kws)

    def __iter__(self):
        return self._func()

    #def __hash__(self):
    #    return hash(self._func)
    __hash__ = None
