# Copyright (c) 2016, Tim Wentzlau
# Licensed under MIT

""" Handles multiprocessing functionality in Kervi """

from multiprocessing import Process #, Array, Value, Manager, freeze_support
import time
import kervi.spine as spine
from kervi.utility.process_spine import ProcessSpine
#import sys
import kervi.kervi_logging as k_logging

MAIN_SPINE = None
def start_root_spine(settings, reset_log=False):
    global MAIN_SPINE
    k_logging.init_process_logging("kervi-main", reset_log)
    k_logging.KerviLog("kervi main")
    spine.init_spine("kervi-main")
    MAIN_SPINE = ProcessSpine(settings["network"]["IPCBasePort"], settings, is_root=True)

def stop_root_spine():
    MAIN_SPINE.close_all_connections()


class KerviProcess(object):
    def __init__(self, name, settings, ipcPort):
        self.do_terminate = False
        self.port = ipcPort
        self.settings = settings
        spine.init_spine(name)
        self.spine = spine.Spine()
        self.process_spine = ProcessSpine(ipcPort, settings)
        self.init_process()
        self.spine.register_command_handler("terminateProcess", self.terminate)

    def terminate(self):
        print ("terminate:", self.port)
        self.process_spine.close_all_connections()
        self.spine.stop()
        self.terminate_process()
        self.do_terminate = True

    def init_process(self):
        self.spine.log.error("abstract init_process called in KerviProcess")

    def terminate_process(self):
        self.spine.log.error("abstract init_process called in KerviProcess")

def launch(name, process_class, settings, ipc_port):
    k_logging.init_process_logging("KerviSys-" + name, False)
    log = k_logging.KerviLog(name)
    log.info('create process:{0} ipc port:{1}:', process_class.__name__, ipc_port)
    process = process_class(name, settings, ipc_port)
    try:
        while not process.do_terminate:
            time.sleep(1)
    except:
        log.exception("error in process loop")

    log.info("process terminated:{0}", ipc_port)

def start_process(name, settings, portIdx, processClass):
    process = Process(target=launch, args=(name, processClass, settings, portIdx))
    process.start()
    return process

def stop_processes():
    spine.Spine().send_command("terminateProcess")
