# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .facet import Facet


class FacetResult(Facet):
    """Successfully executed facet containing additional statistics on the
    response of a query.

    All required parameters must be populated in order to send to Azure.

    :param expression: Required. Facet expression, same as in the
     corresponding facet request.
    :type expression: str
    :param result_type: Required. Constant filled by server.
    :type result_type: str
    :param total_records: Required. Number of total records in the facet
     results.
    :type total_records: long
    :param count: Required. Number of records returned in the facet response.
    :type count: int
    :param data: Required. A table containing the desired facets. Only present
     if the facet is valid.
    :type data: object
    """

    _validation = {
        'expression': {'required': True},
        'result_type': {'required': True},
        'total_records': {'required': True},
        'count': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'expression': {'key': 'expression', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'total_records': {'key': 'totalRecords', 'type': 'long'},
        'count': {'key': 'count', 'type': 'int'},
        'data': {'key': 'data', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(FacetResult, self).__init__(**kwargs)
        self.total_records = kwargs.get('total_records', None)
        self.count = kwargs.get('count', None)
        self.data = kwargs.get('data', None)
        self.result_type = 'FacetResult'
