# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServerUpgradeGetResult(Model):
    """Represents the response to a Get request for Upgrade status of an Azure
    SQL Server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The status of the Azure SQL Server Upgrade.
    :vartype status: str
    :ivar schedule_upgrade_after_time: The schedule time of the Azure SQL
     Server Upgrade (ISO8601 format).
    :vartype schedule_upgrade_after_time: datetime
    """ 

    _validation = {
        'status': {'readonly': True},
        'schedule_upgrade_after_time': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'schedule_upgrade_after_time': {'key': 'scheduleUpgradeAfterTime', 'type': 'iso-8601'},
    }

    def __init__(self):
        self.status = None
        self.schedule_upgrade_after_time = None
