# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RestorePoint(Resource):
    """Represents an Azure SQL Database restore point.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar restore_point_type: The restore point type of the Azure SQL
     Database restore point. Possible values include: 'DISCRETE', 'CONTINUOUS'
    :vartype restore_point_type: str or :class:`RestorePointTypes
     <azure.mgmt.sql.models.RestorePointTypes>`
    :ivar restore_point_creation_date: Restore point creation time (ISO8601
     format). Populated when restorePointType = CONTINUOUS. Null otherwise.
    :vartype restore_point_creation_date: datetime
    :ivar earliest_restore_date: Earliest restore time (ISO8601 format).
     Populated when restorePointType = DISCRETE. Null otherwise.
    :vartype earliest_restore_date: datetime
    """ 

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'restore_point_type': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'RestorePointTypes'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(self, location, tags=None):
        super(RestorePoint, self).__init__(location=location, tags=tags)
        self.restore_point_type = None
        self.restore_point_creation_date = None
        self.earliest_restore_date = None
