from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

rfcom = SchLib(tool=SKIDL).add_parts(*[
        Part(name='BL652',dest=TEMPLATE,tool=SKIDL,keywords='Bluetooth Nordic nRF52',description='Bluetooth module',ref_prefix='U',num_units=1,fplist=['Laird*BL652*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SIO_24',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SIO_23',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SIO_22',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SWDCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SIO_21',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SIO_20',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SIO_18',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SIO_16',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SIO_05/AIN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='SIO_17',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SIO_14',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='SIO_04/AIN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='SIO_19',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SIO_12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SIO_03/AIN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='SIO_31/AIN7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SIO_11',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='SIO_02/AIN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SIO_30/AIN6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SIO_10/NFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SIO_01',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SIO_29/AIN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SIO_09/NFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SIO_00',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SIO_28/AIN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='SIO_27',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SIO_08',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='SIO_26',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SIO_07',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SIO_13',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SIO_25',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SIO_06',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='SIO_15',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BTM112',dest=TEMPLATE,tool=SKIDL,keywords='Bluetooth BT SPP Module',description='Bluetooth SPP Module, UART, Class 2',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO8',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AIO0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AIO1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RESET',do_erc=True),
            Pin(num='7',name='SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SPI_CSB~',do_erc=True),
            Pin(num='9',name='SPI_CLK',do_erc=True),
            Pin(num='10',name='SPI_MOSI',do_erc=True),
            Pin(num='20',name='PCM_IN',do_erc=True),
            Pin(num='30',name='PIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~UART_CTS',do_erc=True),
            Pin(num='21',name='PCM_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='UART_TX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='~UART_RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='UART_RX',do_erc=True),
            Pin(num='24',name='~LINK~/PIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CONN/PIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='BTN/PIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PCM_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='PIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PCM_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PIO2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='BTM222',dest=TEMPLATE,tool=SKIDL,keywords='Bluetooth BT SPP Module',description='Bluetooth SPP Module, UART, Class 1',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='AIO0/SLEEPCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PIO0/RXEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PIO1/TXEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PIO2/USB_PU/CLK_REQ_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO3/USB_WKUP/CLK_REQ_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO4/USB_ON/BT_PRIOR',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='UART_CTS',do_erc=True),
            Pin(num='11',name='PIO5/USB_DETACH/BT_ACT',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='SPI_MOSI',do_erc=True),
            Pin(num='12',name='PIO6/CLK_REQ/WAN_ACT',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PCM_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='~SPI_CSB~',do_erc=True),
            Pin(num='13',name='PIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PCM_IN',do_erc=True),
            Pin(num='33',name='SPI_CLK',do_erc=True),
            Pin(num='14',name='PIO8',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PCM_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='PIO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PCM_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RESET~',do_erc=True),
            Pin(num='26',name='UART_RX',do_erc=True),
            Pin(num='36',name='PIO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='UART_TX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='RF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='UART_RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CC1000',dest=TEMPLATE,tool=SKIDL,keywords='Low Power RF Transciever',description='Single Chip Low Power RF Transceiver, TSSOP28',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='RF_IN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='RF_OUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='L1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='L2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='CHP_OUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='R_BIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='DIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='DCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='PCLK',do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='XOSC_Q2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='PALE',do_erc=True),
            Pin(num='18',name='XOSC_Q1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='RSSI/IF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='AGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CC1200',dest=TEMPLATE,tool=SKIDL,keywords='RF Tx Rx',description='Low-Power, High-Performance RF Transceiver',ref_prefix='U',num_units=1,fplist=['QFN-32-1EP_5x5mm_Pitch0.5mm', 'QFN-32-1EP_5x5mm_Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD_GUARD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~RESET~',do_erc=True),
            Pin(num='3',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DCPL',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='SI',do_erc=True),
            Pin(num='8',name='SCLK',do_erc=True),
            Pin(num='9',name='SO(GPIO1)',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GPIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='LNA_N',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='XOSC_Q1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~CS~',do_erc=True),
            Pin(num='21',name='DCPL_VCO',func=Pin.PWROUT,do_erc=True),
            Pin(num='31',name='XOSC_Q2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='AVDD_SYNTH1',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='EXT_XOSC',do_erc=True),
            Pin(num='13',name='AVDD_IF',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='LPF0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='GND_EP',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='LPF1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='AVDD_RF',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='AVDD_PFD_CHP',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='DCPL_PFD_CHP',func=Pin.PWROUT,do_erc=True),
            Pin(num='17',name='PA',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='AVDD_SYNTH2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='TRX_SW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='AVDD_XOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='LNA_P',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='DCPL_XOSC',func=Pin.PWROUT,do_erc=True)]),
        Part(name='CC2520',dest=TEMPLATE,tool=SKIDL,keywords='2.4GHz rf transceiver ZigBee 802.15.4',description='2.4 GHz ZigBee/IEEE 802.15.4 RF transceiver',ref_prefix='U',num_units=1,fplist=['*QFN*28*5x5mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SI',do_erc=True),
            Pin(num='3',name='~CS',do_erc=True),
            Pin(num='4',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GPIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GPIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AVDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AVDD5',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='12',name='XOSC_Q2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='AVDD4',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='XOSC_Q1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='AVDD3',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='AVDD_GUARD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='25',name='~RESET',do_erc=True),
            Pin(num='16',name='AVDD2',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VREG_EN',do_erc=True),
            Pin(num='17',name='RF_P',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='DCOUPL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='SCLK',do_erc=True),
            Pin(num='19',name='RF_N',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='AGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='HF-A11-SMT',dest=TEMPLATE,tool=SKIDL,keywords='WiFi IEEE802.11 b/g/n',description='WiFi IEEE802.11b/g/n with Ethernet Module, UART, GPIO',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='3.3V',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='UART_TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='UART_RXD',do_erc=True),
            Pin(num='6',name='UART_RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='UART_CTS',do_erc=True),
            Pin(num='8',name='TX+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='TX-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RX+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RX-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='UART1_RXD',do_erc=True),
            Pin(num='22',name='UART1_TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='1.8VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='~LINK~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='~RESET~',do_erc=True),
            Pin(num='25',name='RF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~READY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RELOAD~',do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MM002',dest=TEMPLATE,tool=SKIDL,keywords='IOT LoRa SIGFOX',description='NEMEUS Modem dual-mode LoRa/SIGFOX',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~NRST',do_erc=True),
            Pin(num='3',name='PB9-IO/I2C-SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PB8-IO/I2C-SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='BOOT',do_erc=True),
            Pin(num='6',name='PB7-IO/UART1-RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PB6-IO/UART1-TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB4-IO/NJTRST',do_erc=True),
            Pin(num='9',name='PB3-IO/JTDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PA15-IO/JTDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PA5-IO/SPI-SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PA14-IO/JTCK/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PA6-IO/SPI-MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PA13-IO/JTMS/SWDAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PA4-IO/SPI-NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PA12-IO/UART1-RTS/USB-DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PA3-IO/ADC/UART2-RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PA11-IO/UART1-CTS/USB-DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PA2-IO/ADC/UART2-TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='PA0-IO/ADC/UART2-CTS/WKUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='PA1-IO/ADC/UART2-RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ANT',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PA7-IO/SPI-MOSI',func=Pin.BIDIR,do_erc=True)]),
        Part(name='NRF24L01',dest=TEMPLATE,tool=SKIDL,keywords='Low Power RF Transciever',description='nRF24L01+, Ultra low power 2.4GHz RF Transceiver, QFN20 4x4mm',ref_prefix='U',num_units=1,fplist=['QFN*4x4*0.5mm*'],do_erc=True,aliases=['nRF24L01P'],pins=[
            Pin(num='1',name='CE',do_erc=True),
            Pin(num='2',name='CSN',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='MOSI',do_erc=True),
            Pin(num='5',name='MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='IRQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='XC2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='XC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VDD_PA',func=Pin.PWROUT,do_erc=True),
            Pin(num='12',name='ANT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='ANT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='IREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='DVDD',func=Pin.PWROUT,do_erc=True)]),
        Part(name='NRF24L01_Breakout',dest=TEMPLATE,tool=SKIDL,keywords='Low Power RF Transciever breakout carrier',description='Ultra low power 2.4GHz RF Transceiver, Carrier PCB',ref_prefix='U',num_units=1,fplist=['nRF24L01*Breakout*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CE',do_erc=True),
            Pin(num='4',name='~CSN',do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='MOSI',do_erc=True),
            Pin(num='7',name='MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='IRQ',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='RN42',dest=TEMPLATE,tool=SKIDL,keywords='Bluetooth Module',description='Class 2 Bluetooth Module with on-board antenna',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SPI_MOSI',do_erc=True),
            Pin(num='3',name='GPIO6',do_erc=True),
            Pin(num='4',name='GPIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RESET',do_erc=True),
            Pin(num='6',name='SPI_CLK',do_erc=True),
            Pin(num='7',name='PCM_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PCM_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PCM_IN',do_erc=True),
            Pin(num='10',name='PCM_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='GPIO3',do_erc=True),
            Pin(num='30',name='AIO0',do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GPIO8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GPIO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='UART_RX',do_erc=True),
            Pin(num='23',name='SPI_CSB',do_erc=True),
            Pin(num='33',name='GPIO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='UART_TX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='GPIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='UART_RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='AIO1',do_erc=True),
            Pin(num='16',name='UART_CTS',do_erc=True),
            Pin(num='36',name='SHIELD',do_erc=True),
            Pin(num='17',name='USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='RN42N',dest=TEMPLATE,tool=SKIDL,keywords='Bluetooth Module',description='Class 2 Bluetooth Module without antenna',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SPI_MOSI',do_erc=True),
            Pin(num='3',name='GPIO6',do_erc=True),
            Pin(num='4',name='GPIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RESET',do_erc=True),
            Pin(num='6',name='SPI_CLK',do_erc=True),
            Pin(num='7',name='PCM_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PCM_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PCM_IN',do_erc=True),
            Pin(num='10',name='PCM_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='GPIO3',do_erc=True),
            Pin(num='30',name='AIO0',do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='GPIO8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GPIO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='UART_RX',do_erc=True),
            Pin(num='23',name='SPI_CSB',do_erc=True),
            Pin(num='33',name='GPIO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='UART_TX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='GPIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='UART_RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='AIO1',do_erc=True),
            Pin(num='16',name='UART_CTS',do_erc=True),
            Pin(num='26',name='RF_ANT',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='SHIELD',do_erc=True),
            Pin(num='17',name='USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='SA605D',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SIM900',dest=TEMPLATE,tool=SKIDL,keywords='GSM GPRS Quad-Band SMS FAX',description='GSM Quad-Band Communication Module, GPRS, Audio Engine, AT Command Set',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PWRKEY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='PWRKEY_OUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='RI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='DCD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='DSR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='RTS',do_erc=True),
            Pin(num='9',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='RXD',do_erc=True),
            Pin(num='20',name='MIC_N',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='SIM_VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='40',name='GPIO1/KBR4',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='GPIO9/KBC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='RF_ANT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='DS_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='SPK_P',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='SIM_DATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GPIO2/KBR3',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GPIO10/KBC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DS_DTA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SPK_N',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='SIM_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='GPIO3/KBR2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='NETLIGHT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DS_D/C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='LINE_R',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='SIM_RST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='GPIO4/KBR1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DS_CS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='LINE_L',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='SIM_PRESENCE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='GPIO5/KBR0',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VDD_EXT',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='ADC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='PWM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='~RESET~',do_erc=True),
            Pin(num='26',name='VRTC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='PWM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='56',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='66',name='STATUS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='DBG_TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GPIO6/KBC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='GPIO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='DBG_RXD',do_erc=True),
            Pin(num='38',name='SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='GPIO7/KBC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='GPIO12',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='MIC_P',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='GPIO8/KBC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TD1205',dest=TEMPLATE,tool=SKIDL,keywords='IOT SIGFOX GPS',description='High-Performance, Low-Current SIGFOX™ Gateway And GPS Receiver With Integrated Antennas',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='BAT-',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='BAT+',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~RST',do_erc=True),
            Pin(num='6',name='UART-TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='UART-RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DB2-SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DB3-SWCLK',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TD1208',dest=TEMPLATE,tool=SKIDL,keywords='IOT SIGFOX',description='High-Performance, Low-Current SIGFOX™ Gateway',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Reserved',func=Pin.UNSPEC,do_erc=True),
            Pin(num='4',name='USR4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DB3-SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DB2-SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='USR2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TIM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='USR3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RF_GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='~RST',do_erc=True),
            Pin(num='24',name='RF',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RF_GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='USR0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='USR1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='UART-TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='UART-RX',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TR-52D',dest=TEMPLATE,tool=SKIDL,keywords='IQRF common transceiver, GMSK modulation',description='IQRF common transceiver, GMSK modulation',ref_prefix='IC',num_units=1,fplist=['IQRF?KON?SIM?01*'],do_erc=True,aliases=['TR-72D', 'DCTR-52D', 'DCTR-72D'],pins=[
            Pin(num='1',name='RA0/AN0/C12IN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RC2/Vout',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='RA5/RB4/RC6/AN4/AN11/TX/~SS~/C2OUT/CCP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC3/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC4/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC5/RC7/RX/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XBee_SMT',dest=TEMPLATE,tool=SKIDL,keywords='Digi XBee',description='Digi Xbee SMT RF module',ref_prefix='U',num_units=1,fplist=['Digi*XBee*SMT*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='DIO13/UART_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DIO14/UART_RX/~CONFIG',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DIO12',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RESET/OD_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DIO10/RSSI/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DIO11/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='DIO8/SLEEP_REQUEST',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='30',name='DIO3/AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='31',name='DIO2/AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='DIO19/SPI_~ATTN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='DIO1/AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='DIO0/AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DIO18/SPI_CLK',do_erc=True),
            Pin(num='24',name='DIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='15',name='DIO17/SPI_~SSEL',do_erc=True),
            Pin(num='25',name='DIO7/~CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DIO16/SPI_MOSI',do_erc=True),
            Pin(num='26',name='DIO9/ON/~SLEEP',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RF',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='DIO15/SPI_MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='VREF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='18',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='28',name='DIO5/ASSOCIATE',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='29',name='DIO6/~RTS',func=Pin.BIDIR,do_erc=True)]),
        Part(name='iM880A',dest=TEMPLATE,tool=SKIDL,keywords='IOT LoRa',description='IMST Long Range Radio Module - LoRa Alliance Certified',ref_prefix='U',num_units=1,do_erc=True,aliases=['iM880B'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='P1-IO/JTCK/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P2-IO/JTMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P3-IO/JTDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P4-IO/JTDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~RST',do_erc=True),
            Pin(num='8',name='P5-IO/UART-CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P6-IO/UART-RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='P11-IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P12-IO/I2C-SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P7-IO/SPI-MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='P8-IO/SPI-MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P13-IO/I2C-SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P9-IO/SPI-CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P14-IO/ADC',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P10-IO/SPI-NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P15-IO/WKUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='BOOT',do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RxD-IO/UART-RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='19',name='TxD-IO/UART-TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P17-IO/ADC',func=Pin.BIDIR,do_erc=True)])])