# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import PolicyClientConfiguration
from .operations import PolicyAssignmentsOperations
from .operations import PolicySetDefinitionsOperations
from .operations import PolicyDefinitionsOperations
from . import models


class PolicyClient(object):
    """To manage and control access to your resources, you can define customized policies and assign them at a scope.

    :ivar policy_assignments: PolicyAssignmentsOperations operations
    :vartype policy_assignments: azure.mgmt.resource.policy.v2017_06_01_preview.operations.PolicyAssignmentsOperations
    :ivar policy_set_definitions: PolicySetDefinitionsOperations operations
    :vartype policy_set_definitions: azure.mgmt.resource.policy.v2017_06_01_preview.operations.PolicySetDefinitionsOperations
    :ivar policy_definitions: PolicyDefinitionsOperations operations
    :vartype policy_definitions: azure.mgmt.resource.policy.v2017_06_01_preview.operations.PolicyDefinitionsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = PolicyClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.policy_assignments = PolicyAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.policy_set_definitions = PolicySetDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.policy_definitions = PolicyDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PolicyClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
