#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
""" 	Copyright (c) 2004 Colin Stewart (http://www.owlfish.com/)
		All rights reserved.
		
		Redistribution and use in source and binary forms, with or without
		modification, are permitted provided that the following conditions
		are met:
		1. Redistributions of source code must retain the above copyright
		   notice, this list of conditions and the following disclaimer.
		2. Redistributions in binary form must reproduce the above copyright
		   notice, this list of conditions and the following disclaimer in the
		   documentation and/or other materials provided with the distribution.
		3. The name of the author may not be used to endorse or promote products
		   derived from this software without specific prior written permission.
		
		THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
		IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
		OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
		IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
		INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
		NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
		DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
		THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
		(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
		THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
		
		If you make any bug fixes or feature enhancements please let me know!
		
		Unit test cases.
		
"""

from __future__ import unicode_literals
import unittest
import os
import io
import logging
import logging.config

from simpletal import simpleTAL, simpleTALES

if (os.path.exists("logging.ini")):
    logging.config.fileConfig("logging.ini")
else:
    logging.basicConfig()


class TALReplaceTestCases (unittest.TestCase):

    def setUp(self):
        self.context = simpleTALES.Context()
        entry = """Some structure: <b tal:content="weblog/subject"></b>"""

        weblog = {'subject': 'Test subject', 'entry': entry}

        self.context.addGlobal('test', 'testing')
        self.context.addGlobal('one', [1])
        self.context.addGlobal('two', ["one", "two"])
        self.context.addGlobal('three', [1, "Two", 3])
        self.context.addGlobal('weblog', weblog)

    def _runTest_(self, txt, result, errMsg="Error"):
        template = simpleTAL.compileHTMLTemplate(txt)
        file = io.StringIO()
        template.expand(self.context, file)
        realResult = file.getvalue()
        self.assertEqual(realResult, result, "%s - \npassed in: %s \ngot back %s \nexpected %s\n\nTemplate: %s" %
                         (errMsg, txt, realResult, result, template))

    def testContentNothing(self):
        self._runTest_('<html><p tal:replace="nothing"></p></html>',
                       '<html></html>', 'Content of nothing did not remove tag.')

    def testContentDefault(self):
        self._runTest_('<html><p tal:replace="default">Original</p></html>', '<html><p>Original</p></html>',
                       'Content of default did not evaluate to existing content without tags')

    def testContentString(self):
        self._runTest_('<html><p tal:replace="test">Original</p></html>',
                       '<html>testing</html>', 'Content of string did not evaluate to contain string')

    def testContentStructure(self):
        # This test uses a specific context
        entry = """Some structure: <b tal:content="weblog/subject"></b>"""
        weblog = {'subject': 'Test subject',
                  'entry': simpleTAL.compileHTMLTemplate(entry)}
        self.context.addGlobal('weblog', weblog)
        self._runTest_('<html><p tal:replace="structure weblog/entry">Original</p></html>',
                       '<html>Some structure: <b>Test subject</b></html>', 'Content of Structure did not evaluate to expected result')

if __name__ == '__main__':
    unittest.main()
