# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-07-08 12:28
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('auth', '0007_alter_validators_add_error_messages'),
    ]

    operations = [
        migrations.CreateModel(
            name='KernelPermissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
            ],
            options={
                'verbose_name': 'права доступа',
                'verbose_name_plural': 'права доступа',
                'db_table': 'krn_permissions',
            },
            managers=[
                ('base_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='KernelUser',
            fields=[
                ('kernelpermissions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='kernel.KernelPermissions')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('external_id', models.CharField(editable=False, max_length=120)),
                ('email', models.EmailField(db_index=True, max_length=255, unique=True, verbose_name='email')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='Фамилия')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='Имя')),
                ('middle_name', models.CharField(blank=True, max_length=30, verbose_name='Отчество')),
                ('phone', models.CharField(blank=True, max_length=30, verbose_name='Телефон')),
                ('date_birth', models.DateField(blank=True, null=True)),
                ('photo', models.ImageField(blank=True, null=True, upload_to='', verbose_name='Фотография')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_kernel.kerneluser_set+', to='contenttypes.ContentType')),
            ],
            options={
                'swappable': 'AUTH_USER_MODEL',
                'verbose_name': 'пользователи',
                'verbose_name_plural': 'пользователи',
                'db_table': 'krn_user',
            },
            bases=('kernel.kernelpermissions', models.Model),
        ),
        migrations.AddField(
            model_name='kernelpermissions',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='kernelpermissions',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
    ]
