/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import com.sun.msv.verifier.ErrorInfo;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.jarv.TheFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierHandler;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ValidationUtil {
    public static void validate(InputStream jobInputStream, InputStream schemaIs) throws SAXException, IOException, JobCreationException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            TheFactoryImpl vfactory = new TheFactoryImpl();
            Schema schema = vfactory.compileSchema(schemaIs);
            Verifier verifier = schema.newVerifier();
            VerifierHandler handler = verifier.getVerifierHandler();
            ContentHandlerDecorator contentHandlerDecorator = new ContentHandlerDecorator((ContentHandler)handler);
            reader.setContentHandler(contentHandlerDecorator);
            ValidationErrorHandler errHandler = new ValidationErrorHandler(contentHandlerDecorator);
            verifier.setErrorHandler((ErrorHandler)errHandler);
            reader.parse(new InputSource(jobInputStream));
        }
        catch (SAXException se) {
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof JobCreationException) {
                throw (JobCreationException)cause;
            }
            throw se;
        }
        catch (VerifierConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] getInputStreamBytes(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.toByteArray();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private static class ContentHandlerDecorator
    implements ContentHandler {
        private ContentHandler handler;
        private Stack<String> currentTask = new Stack();
        private Stack<String> currentE = new Stack();

        ContentHandlerDecorator(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.handler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.handler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.handler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (XMLTags.TASK.getXMLName().equals(this.currentE.push(qName))) {
                this.nameAttrValue(atts);
                this.currentTask.push(this.nameAttrValue(atts));
            }
            this.handler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (XMLTags.TASK.getXMLName().equals(this.currentE.pop())) {
                this.currentTask.pop();
            }
            this.handler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.handler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.handler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.handler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.handler.skippedEntity(name);
        }

        public String currentTask() {
            return this.currentTask.isEmpty() ? null : this.currentTask.peek();
        }

        private String nameAttrValue(Attributes atts) {
            return atts.getValue("name") == null ? "" : atts.getValue("name");
        }
    }

    private static class ValidationErrorHandler
    implements ErrorHandler {
        private ContentHandlerDecorator decorator;

        ValidationErrorHandler(ContentHandlerDecorator decorator) {
            this.decorator = decorator;
        }

        @Override
        public void error(SAXParseException se) throws SAXException {
            this.handleError(se);
        }

        @Override
        public void fatalError(SAXParseException se) throws SAXException {
            this.handleError(se);
        }

        @Override
        public void warning(SAXParseException se) throws SAXException {
            this.handleError(se);
        }

        private void handleError(SAXParseException se) throws SAXException {
            ErrorInfo errorInfo;
            StringBuilder sb = new StringBuilder();
            if (se instanceof ValidityViolation && (errorInfo = ((ValidityViolation)se).getErrorInfo()) instanceof ErrorInfo.IncompleteContentModel) {
                String qName = ((ErrorInfo.IncompleteContentModel)errorInfo).qName;
                if (XMLTags.TASK_FLOW.getXMLName().equals(qName)) {
                    sb.append("Uncompleted job: At least one task must be defined.").append('\n');
                } else if (XMLTags.TASK.getXMLName().equals(qName)) {
                    sb.append("Uncompleted task: At least the Executable element must be define.").append('\n');
                } else if (XMLTags.SCRIPT_EXECUTABLE.getXMLName().equals(qName)) {
                    sb.append("Uncompleted scriptExecutable.").append('\n');
                }
            }
            sb.append("Error: ").append(se.getMessage()).append(" at line ").append(se.getLineNumber()).append(" , column ").append(se.getColumnNumber()).append('.');
            JobCreationException ne = new JobCreationException(sb.toString(), (Throwable)se);
            String currentTask = this.decorator.currentTask();
            if (currentTask != null && !currentTask.isEmpty()) {
                ne.setTaskName(currentTask);
            }
            throw new SAXException(ne);
        }
    }
}

