/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.io.Serializable;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public enum JobStatus implements Serializable
{
    PENDING("Pending", true),
    RUNNING("Running", true),
    STALLED("Stalled", true),
    FINISHED("Finished", false),
    PAUSED("Paused", true),
    CANCELED("Canceled", false),
    FAILED("Failed", false),
    KILLED("Killed", false),
    IN_ERROR("In-Error", true);

    private final String definition;
    private final boolean jobAlive;

    private JobStatus(String def, boolean jobAlive) {
        this.definition = def;
        this.jobAlive = jobAlive;
    }

    public static JobStatus findPriority(String name) {
        for (JobStatus jobStatus : JobStatus.values()) {
            if (!name.equalsIgnoreCase(jobStatus.toString())) continue;
            return jobStatus;
        }
        return KILLED;
    }

    public String toString() {
        return this.definition;
    }

    public boolean isJobAlive() {
        return this.jobAlive;
    }
}

