# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class GlobalUsersOperations(object):
    """GlobalUsersOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.labservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get_environment(
        self,
        user_name,  # type: str
        environment_operations_payload,  # type: "_models.EnvironmentOperationsPayload"
        expand=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.GetEnvironmentResponse"
        """Gets the virtual machine details.

        :param user_name: The name of the user.
        :type user_name: str
        :param environment_operations_payload: Represents payload for any Environment operations like
         get, start, stop, connect.
        :type environment_operations_payload: ~azure.mgmt.labservices.models.EnvironmentOperationsPayload
        :param expand: Specify the $expand query. Example: 'properties($expand=environment)'.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetEnvironmentResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.GetEnvironmentResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GetEnvironmentResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.get_environment.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(environment_operations_payload, 'EnvironmentOperationsPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('GetEnvironmentResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_environment.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/getEnvironment'}  # type: ignore

    def get_operation_batch_status(
        self,
        user_name,  # type: str
        operation_batch_status_payload,  # type: "_models.OperationBatchStatusPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.OperationBatchStatusResponse"
        """Get batch operation status.

        :param user_name: The name of the user.
        :type user_name: str
        :param operation_batch_status_payload: Payload to get the status of an operation.
        :type operation_batch_status_payload: ~azure.mgmt.labservices.models.OperationBatchStatusPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OperationBatchStatusResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.OperationBatchStatusResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.OperationBatchStatusResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.get_operation_batch_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(operation_batch_status_payload, 'OperationBatchStatusPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('OperationBatchStatusResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_operation_batch_status.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/getOperationBatchStatus'}  # type: ignore

    def get_operation_status(
        self,
        user_name,  # type: str
        operation_status_payload,  # type: "_models.OperationStatusPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.OperationStatusResponse"
        """Gets the status of long running operation.

        :param user_name: The name of the user.
        :type user_name: str
        :param operation_status_payload: Payload to get the status of an operation.
        :type operation_status_payload: ~azure.mgmt.labservices.models.OperationStatusPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OperationStatusResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.OperationStatusResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.OperationStatusResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.get_operation_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(operation_status_payload, 'OperationStatusPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('OperationStatusResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_operation_status.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/getOperationStatus'}  # type: ignore

    def get_personal_preferences(
        self,
        user_name,  # type: str
        personal_preferences_operations_payload,  # type: "_models.PersonalPreferencesOperationsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.GetPersonalPreferencesResponse"
        """Get personal preferences for a user.

        :param user_name: The name of the user.
        :type user_name: str
        :param personal_preferences_operations_payload: Represents payload for any Environment
         operations like get, start, stop, connect.
        :type personal_preferences_operations_payload: ~azure.mgmt.labservices.models.PersonalPreferencesOperationsPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetPersonalPreferencesResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.GetPersonalPreferencesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GetPersonalPreferencesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.get_personal_preferences.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(personal_preferences_operations_payload, 'PersonalPreferencesOperationsPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('GetPersonalPreferencesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_personal_preferences.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/getPersonalPreferences'}  # type: ignore

    def list_environments(
        self,
        user_name,  # type: str
        list_environments_payload,  # type: "_models.ListEnvironmentsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ListEnvironmentsResponse"
        """List Environments for the user.

        :param user_name: The name of the user.
        :type user_name: str
        :param list_environments_payload: Represents the payload to list environments owned by a user.
        :type list_environments_payload: ~azure.mgmt.labservices.models.ListEnvironmentsPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListEnvironmentsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.ListEnvironmentsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ListEnvironmentsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.list_environments.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(list_environments_payload, 'ListEnvironmentsPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ListEnvironmentsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    list_environments.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/listEnvironments'}  # type: ignore

    def list_labs(
        self,
        user_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ListLabsResponse"
        """List labs for the user.

        :param user_name: The name of the user.
        :type user_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListLabsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.labservices.models.ListLabsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ListLabsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        accept = "application/json"

        # Construct URL
        url = self.list_labs.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ListLabsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    list_labs.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/listLabs'}  # type: ignore

    def register(
        self,
        user_name,  # type: str
        register_payload,  # type: "_models.RegisterPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Register a user to a managed lab.

        :param user_name: The name of the user.
        :type user_name: str
        :param register_payload: Represents payload for Register action.
        :type register_payload: ~azure.mgmt.labservices.models.RegisterPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.register.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(register_payload, 'RegisterPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    register.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/register'}  # type: ignore

    def _reset_password_initial(
        self,
        user_name,  # type: str
        reset_password_payload,  # type: "_models.ResetPasswordPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._reset_password_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(reset_password_payload, 'ResetPasswordPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _reset_password_initial.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/resetPassword'}  # type: ignore

    def begin_reset_password(
        self,
        user_name,  # type: str
        reset_password_payload,  # type: "_models.ResetPasswordPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Resets the user password on an environment This operation can take a while to complete.

        :param user_name: The name of the user.
        :type user_name: str
        :param reset_password_payload: Represents the payload for resetting passwords.
        :type reset_password_payload: ~azure.mgmt.labservices.models.ResetPasswordPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: Pass in True if you'd like the ARMPolling polling method,
         False for no polling, or your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._reset_password_initial(
                user_name=user_name,
                reset_password_payload=reset_password_payload,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_reset_password.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/resetPassword'}  # type: ignore

    def _start_environment_initial(
        self,
        user_name,  # type: str
        environment_operations_payload,  # type: "_models.EnvironmentOperationsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._start_environment_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(environment_operations_payload, 'EnvironmentOperationsPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _start_environment_initial.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/startEnvironment'}  # type: ignore

    def begin_start_environment(
        self,
        user_name,  # type: str
        environment_operations_payload,  # type: "_models.EnvironmentOperationsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Starts an environment by starting all resources inside the environment. This operation can take
        a while to complete.

        :param user_name: The name of the user.
        :type user_name: str
        :param environment_operations_payload: Represents payload for any Environment operations like
         get, start, stop, connect.
        :type environment_operations_payload: ~azure.mgmt.labservices.models.EnvironmentOperationsPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: Pass in True if you'd like the ARMPolling polling method,
         False for no polling, or your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._start_environment_initial(
                user_name=user_name,
                environment_operations_payload=environment_operations_payload,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_start_environment.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/startEnvironment'}  # type: ignore

    def _stop_environment_initial(
        self,
        user_name,  # type: str
        environment_operations_payload,  # type: "_models.EnvironmentOperationsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-10-15"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._stop_environment_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(environment_operations_payload, 'EnvironmentOperationsPayload')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _stop_environment_initial.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/stopEnvironment'}  # type: ignore

    def begin_stop_environment(
        self,
        user_name,  # type: str
        environment_operations_payload,  # type: "_models.EnvironmentOperationsPayload"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Stops an environment by stopping all resources inside the environment This operation can take a
        while to complete.

        :param user_name: The name of the user.
        :type user_name: str
        :param environment_operations_payload: Represents payload for any Environment operations like
         get, start, stop, connect.
        :type environment_operations_payload: ~azure.mgmt.labservices.models.EnvironmentOperationsPayload
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: Pass in True if you'd like the ARMPolling polling method,
         False for no polling, or your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._stop_environment_initial(
                user_name=user_name,
                environment_operations_payload=environment_operations_payload,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'userName': self._serialize.url("user_name", user_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_stop_environment.metadata = {'url': '/providers/Microsoft.LabServices/users/{userName}/stopEnvironment'}  # type: ignore
