/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.RangeMap;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.Pair;

class ShardingRangeMap {
    static final String CLASS_NAME = ShardingRangeMap.class.getName();
    private final Function<OracleShardingKey, Long> shardKeyOraHash;
    private final RangeMap<OracleShardingKey, RangeMap<Long, Chunk>> hashRangeMap = new RangeMap();
    private RangeMap<Long, Chunk> defaultHashRangeMap = new RangeMap();
    private final RangeMap<OracleShardingKey, RangeMap<OracleShardingKey, Chunk>> rangeMap = new RangeMap();
    private RangeMap<OracleShardingKey, Chunk> defaultRangeMap = new RangeMap();

    ShardingRangeMap(Map<RoutingKey, Chunk> routingTable, Function<OracleShardingKey, Long> shardKeyOraHash) {
        this.shardKeyOraHash = shardKeyOraHash;
        HashMap groupingMap = new HashMap();
        HashMap hashGroupingMap = new HashMap();
        routingTable.entrySet().forEach(entry -> {
            SuperShardingKeys skeys = ((RoutingKey)entry.getKey()).getSuperShardingKeys();
            ShardingKeys keys = ((RoutingKey)entry.getKey()).getShardingKeys();
            Chunk chunk = (Chunk)entry.getValue();
            if (keys instanceof HashRangeShardingKeys) {
                hashGroupingMap.computeIfAbsent(skeys, p -> new ArrayList()).add(new Pair<HashRangeShardingKeys, Chunk>((HashRangeShardingKeys)keys, chunk));
            } else {
                groupingMap.computeIfAbsent(skeys, p -> new ArrayList()).add(new Pair<ShardingKeys, Chunk>(keys, chunk));
            }
        });
        hashGroupingMap.entrySet().forEach(entry -> {
            RangeMap rmap = new RangeMap();
            ((List)entry.getValue()).forEach(pair -> ((HashRangeShardingKeys)pair.get1st()).getKeys().stream().forEach(p -> rmap.put(Long.valueOf(((OracleShardingKeyImpl)p.get1st()).getShardingKeyOraHash()), Long.valueOf(((OracleShardingKeyImpl)p.get2nd()).getShardingKeyOraHash()), (Chunk)pair.get2nd())));
            if (SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == entry.getKey()) {
                this.defaultHashRangeMap = rmap;
            } else if (0 == ((SuperShardingKeys)entry.getKey()).getKeys().size()) {
                this.defaultHashRangeMap = rmap;
            } else {
                ((SuperShardingKeys)entry.getKey()).getKeys().stream().forEach(srange -> this.hashRangeMap.put((OracleShardingKey)srange.get1st(), (OracleShardingKey)srange.get2nd(), rmap));
            }
        });
        groupingMap.entrySet().forEach(entry -> {
            RangeMap rmap = new RangeMap();
            ((List)entry.getValue()).forEach(pair -> ((ShardingKeys)pair.get1st()).getKeys().stream().forEach(p -> rmap.put((OracleShardingKey)p.get1st(), (OracleShardingKey)p.get2nd(), (Chunk)pair.get2nd())));
            if (SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == entry.getKey()) {
                this.defaultRangeMap = rmap;
            } else if (0 == ((SuperShardingKeys)entry.getKey()).getKeys().size()) {
                this.defaultRangeMap = rmap;
            } else {
                ((SuperShardingKeys)entry.getKey()).getKeys().stream().forEach(srange -> this.rangeMap.put((OracleShardingKey)srange.get1st(), (OracleShardingKey)srange.get2nd(), rmap));
            }
        });
    }

    private static <T> List<T> combine(List<T> ... lists) {
        return Stream.of(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Chunk> get(OracleShardingKey superKey, OracleShardingKey key) {
        if (Objects.isNull(key)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(superKey) || SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == superKey) {
            if (this.defaultRangeMap.isEmpty()) {
                return this.defaultHashRangeMap.get(this.shardKeyOraHash.apply(key));
            }
            if (this.defaultHashRangeMap.isEmpty()) {
                return this.defaultRangeMap.get(key);
            }
            assert (false) : "unexpected case: both hash and non-hash cases are defined";
            return Stream.of(this.defaultHashRangeMap.get(this.shardKeyOraHash.apply(key)), this.defaultRangeMap.get(key)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List<Chunk> l1 = this.rangeMap.get(superKey).stream().map(p -> p.get(key)).flatMap(Collection::stream).collect(Collectors.toList());
        List<Chunk> l2 = this.hashRangeMap.get(superKey).stream().map(p -> p.get(this.shardKeyOraHash.apply(key))).flatMap(Collection::stream).collect(Collectors.toList());
        if (l1.isEmpty()) {
            return l2;
        }
        if (l2.isEmpty()) {
            return l1;
        }
        assert (false) : "unexpected case: both hash and non-hash cases are defined";
        return Stream.of(l1, l2).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

